/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class FileConnectionConfigurationLatestIT {
    @AfterEach
    public void cleanUp() {
        SnowflakeUtil.systemUnsetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME");
    }

    @Test
    public void testThrowExceptionIfConfigurationDoesNotExist() {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)"non-existent");
        Assertions.assertThrows(SnowflakeSQLException.class, () -> SnowflakeDriver.INSTANCE.connect());
    }

    @Test
    public void testSimpleConnectionUsingFileConfigurationToken() throws SQLException {
        FileConnectionConfigurationLatestIT.verifyConnetionToSnowflake("aws-oauth");
    }

    @Test
    public void testSimpleConnectionUsingFileConfigurationTokenFromFile() throws SQLException {
        FileConnectionConfigurationLatestIT.verifyConnetionToSnowflake("aws-oauth-file");
    }

    private static void verifyConnetionToSnowflake(String connectionName) throws SQLException {
        SnowflakeUtil.systemSetEnv((String)"SNOWFLAKE_DEFAULT_CONNECTION_NAME", (String)connectionName);
        try (Connection con = DriverManager.getConnection("jdbc:snowflake:auto", null);
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("show parameters");){
            Assertions.assertTrue((boolean)resultSet.next());
        }
    }
}

