/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileUploaderPrep;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUploaderSessionlessTest
extends FileUploaderPrep {
    private ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testGetEncryptionMaterialMissing() throws Exception {
        JsonNode modifiedNode = exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.remove("encryptionMaterial");
        List encryptionMaterials = SnowflakeFileTransferAgent.getEncryptionMaterial((SFBaseFileTransferAgent.CommandType)SFBaseFileTransferAgent.CommandType.UPLOAD, (JsonNode)modifiedNode);
        Assertions.assertEquals((int)1, (int)encryptionMaterials.size());
        Assertions.assertNull(encryptionMaterials.get(0));
    }

    @Test
    public void testGetEncryptionMaterial() throws Exception {
        ArrayList<RemoteStoreFileEncryptionMaterial> expected = new ArrayList<RemoteStoreFileEncryptionMaterial>();
        RemoteStoreFileEncryptionMaterial content = new RemoteStoreFileEncryptionMaterial("EXAMPLE_QUERY_STAGE_MASTER_KEY", "EXAMPLE_QUERY_ID", Long.valueOf(123L));
        expected.add(content);
        for (JsonNode exampleNode : exampleNodes) {
            List encryptionMaterials = SnowflakeFileTransferAgent.getEncryptionMaterial((SFBaseFileTransferAgent.CommandType)SFBaseFileTransferAgent.CommandType.UPLOAD, (JsonNode)exampleNode);
            Assertions.assertEquals((int)1, (int)encryptionMaterials.size());
            Assertions.assertEquals((Object)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getQueryStageMasterKey(), (Object)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getQueryStageMasterKey());
            Assertions.assertEquals((Object)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getQueryId(), (Object)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getQueryId());
            Assertions.assertEquals((Long)((RemoteStoreFileEncryptionMaterial)expected.get(0)).getSmkId(), (Long)((RemoteStoreFileEncryptionMaterial)encryptionMaterials.get(0)).getSmkId());
        }
    }

    @Test
    public void testGetS3StageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)exampleS3JsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getUseS3RegionalUrl());
    }

    @Test
    public void testGetS3StageDataWithStageEndpoint() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)exampleS3StageEndpointJsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"s3-fips.us-east-1.amazonaws.com", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetAzureStageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)exampleAzureJsonNode, null);
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AZURE_SAS_TOKEN", "EXAMPLE_AZURE_SAS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.AZURE, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"EXAMPLE_LOCATION/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"westus", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"blob.core.windows.net", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals((Object)"EXAMPLE_STORAGE_ACCOUNT", (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetGCSStageData() throws Exception {
        StageInfo stageInfo = SnowflakeFileTransferAgent.getStageInfo((JsonNode)exampleGCSJsonNode, null);
        HashMap expectedCreds = new HashMap();
        Assertions.assertEquals((Object)StageInfo.StageType.GCS, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"foo/tables/9224/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"US-WEST1", (Object)stageInfo.getRegion());
        Assertions.assertEquals(null, (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
    }

    @Test
    public void testGetFileTransferMetadatasS3() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)exampleS3JsonNode);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assertions.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assertions.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assertions.assertNull((Object)metadata.getPresignedUrl());
        Assertions.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasS3MissingEncryption() throws Exception {
        JsonNode modifiedNode = exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.remove("encryptionMaterial");
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AWS_ID", "EXAMPLE_AWS_ID");
        expectedCreds.put("AWS_KEY", "EXAMPLE_AWS_KEY");
        expectedCreds.put("AWS_KEY_ID", "EXAMPLE_AWS_KEY_ID");
        expectedCreds.put("AWS_SECRET_KEY", "EXAMPLE_AWS_SECRET_KEY");
        expectedCreds.put("AWS_TOKEN", "EXAMPLE_AWS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.S3, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"stage/location/foo/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"us-west-2", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"null", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assertions.assertNull((Object)metadata.getEncryptionMaterial().getQueryId());
        Assertions.assertNull((Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assertions.assertNull((Object)metadata.getEncryptionMaterial().getSmkId());
        Assertions.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assertions.assertNull((Object)metadata.getPresignedUrl());
        Assertions.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasAzure() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)exampleAzureJsonNode);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap<String, String> expectedCreds = new HashMap<String, String>();
        expectedCreds.put("AZURE_SAS_TOKEN", "EXAMPLE_AZURE_SAS_TOKEN");
        Assertions.assertEquals((Object)StageInfo.StageType.AZURE, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"EXAMPLE_LOCATION/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"westus", (Object)stageInfo.getRegion());
        Assertions.assertEquals((Object)"blob.core.windows.net", (Object)stageInfo.getEndPoint());
        Assertions.assertEquals((Object)"EXAMPLE_STORAGE_ACCOUNT", (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assertions.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assertions.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assertions.assertNull((Object)metadata.getPresignedUrl());
        Assertions.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadatasGCS() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)exampleGCSJsonNode);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        HashMap expectedCreds = new HashMap();
        Assertions.assertEquals((Object)StageInfo.StageType.GCS, (Object)stageInfo.getStageType());
        Assertions.assertEquals((Object)"foo/tables/9224/", (Object)stageInfo.getLocation());
        Assertions.assertEquals(expectedCreds, (Object)stageInfo.getCredentials());
        Assertions.assertEquals((Object)"US-WEST1", (Object)stageInfo.getRegion());
        Assertions.assertEquals(null, (Object)stageInfo.getEndPoint());
        Assertions.assertEquals(null, (Object)stageInfo.getStorageAccount());
        Assertions.assertEquals((Object)true, (Object)stageInfo.getIsClientSideEncrypted());
        Assertions.assertEquals(Optional.empty(), (Object)stageInfo.gcsCustomEndpoint());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_ID", (Object)metadata.getEncryptionMaterial().getQueryId());
        Assertions.assertEquals((Object)"EXAMPLE_QUERY_STAGE_MASTER_KEY", (Object)metadata.getEncryptionMaterial().getQueryStageMasterKey());
        Assertions.assertEquals((long)123L, (long)metadata.getEncryptionMaterial().getSmkId());
        Assertions.assertEquals((Object)SFBaseFileTransferAgent.CommandType.UPLOAD, (Object)metadata.getCommandType());
        Assertions.assertEquals((Object)"EXAMPLE_PRESIGNED_URL", (Object)metadata.getPresignedUrl());
        Assertions.assertEquals((Object)"orders_100.csv", (Object)metadata.getPresignedUrlFileName());
    }

    @Test
    public void testGetFileTransferMetadataGCSWithUseRegionalUrl() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)exampleGCSJsonNodeWithUseRegionalUrl);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        Assertions.assertTrue((boolean)stageInfo.getUseRegionalUrl());
        Assertions.assertEquals(Optional.of("storage.us-west1.rep.googleapis.com"), (Object)stageInfo.gcsCustomEndpoint());
    }

    @Test
    public void testGetFileTransferMetadataGCSWithEndPoint() throws Exception {
        List metadataList = SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)exampleGCSJsonNodeWithEndPoint);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)metadataList.get(0);
        StageInfo stageInfo = metadata.getStageInfo();
        Assertions.assertFalse((boolean)stageInfo.getUseRegionalUrl());
        Assertions.assertEquals(Optional.of("example.com"), (Object)stageInfo.gcsCustomEndpoint());
    }

    @Test
    public void testGetFileTransferMetadatasUploadError() throws Exception {
        JsonNode downloadNode = this.mapper.readTree("{\"data\": {\"command\": \"DOWNLOAD\"}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)downloadNode);
            Assertions.fail();
        }
        catch (SnowflakeSQLException err) {
            Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assertions.assertEquals((Object)"JDBC driver internal error: This API only supports PUT commands.", (Object)err.getMessage());
        }
    }

    @Test
    public void testGetFileTransferMetadatasEncryptionMaterialError() throws Exception {
        JsonNode garbageNode = this.mapper.readTree("{\"data\": {\"src_locations\": [1, 2]}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)garbageNode);
            Assertions.fail();
        }
        catch (SnowflakeSQLException err) {
            Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assertions.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: Failed to parse the credentials"));
        }
    }

    @Test
    public void testGetFileTransferMetadatasUnsupportedLocationError() throws Exception {
        JsonNode modifiedNode = exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data").path("stageInfo");
        foo.put("locationType", "LOCAL_FS");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
            Assertions.fail();
        }
        catch (SnowflakeSQLException err) {
            Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assertions.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: This API only supports"));
        }
    }

    @Test
    public void testGetFileTransferMetadatasSrcLocationsArrayError() throws JsonProcessingException {
        JsonNode garbageNode = this.mapper.readTree("{\"data\": {\"src_locations\": \"abc\"}}");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)garbageNode);
            Assertions.fail();
        }
        catch (SnowflakeSQLException err) {
            Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assertions.assertTrue((boolean)err.getMessage().contains("JDBC driver internal error: src_locations must be an array"));
        }
    }

    @Test
    public void testGetFileMetadatasEncryptionMaterialsException() {
        JsonNode modifiedNode = exampleS3JsonNode.deepCopy();
        ObjectNode foo = (ObjectNode)modifiedNode.path("data");
        foo.put("encryptionMaterial", "[1, 2, 3]]");
        try {
            SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)modifiedNode);
            Assertions.fail();
        }
        catch (SnowflakeSQLException err) {
            Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)err.getErrorCode());
            Assertions.assertTrue((boolean)err.getMessage().contains("Failed to parse encryptionMaterial"));
        }
    }
}

