/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Properties;
import java.util.logging.Logger;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.jdbc.HeartbeatIT;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class HeartbeatAsyncLatestIT
extends HeartbeatIT {
    private static Logger logger = Logger.getLogger(HeartbeatAsyncLatestIT.class.getName());

    @Override
    protected void submitQuery(boolean useKeepAliveSession, int queryIdx) throws SQLException, InterruptedException {
        Properties sessionParams = new Properties();
        sessionParams.put("CLIENT_SESSION_KEEP_ALIVE", useKeepAliveSession ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        try (Connection connection = HeartbeatAsyncLatestIT.getConnection(sessionParams);
             Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.unwrap(SnowflakeStatement.class).executeAsyncQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 5))");){
            Thread.sleep(61000L);
            QueryStatus qs = resultSet.unwrap(SnowflakeResultSet.class).getStatus();
            SnowflakeResultSet rs = resultSet.unwrap(SnowflakeResultSet.class);
            Awaitility.await().atMost(Duration.ofSeconds(60L)).until(() -> !QueryStatus.isStillRunning((QueryStatus)rs.getStatus()));
            Assertions.assertEquals((Object)QueryStatus.SUCCESS, (Object)qs);
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)resultSet.next());
            logger.fine("Query " + queryIdx + " passed ");
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testAsynchronousQuerySuccess() throws Exception {
        this.testSuccess();
    }

    @Test
    @DontRunOnGithubActions
    public void testAsynchronousQueryFailure() throws Exception {
        this.testFailure();
    }

    @Test
    @DontRunOnGithubActions
    public void testIsValidWithInvalidSession() throws Exception {
        try (Connection connection = HeartbeatAsyncLatestIT.getConnection();){
            Assertions.assertTrue((boolean)connection.isValid(5));
            Thread.sleep(61000L);
            Assertions.assertFalse((boolean)connection.isValid(5));
        }
    }
}

