/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.AssumptionUtils;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class HeartbeatIT
extends AbstractDriverIT {
    private static Logger logger = Logger.getLogger(HeartbeatIT.class.getName());

    @BeforeAll
    public static void setUpClass() throws Exception {
        if (!AssumptionUtils.isRunningOnGithubActions()) {
            try (Connection connection = HeartbeatIT.getSnowflakeAdminConnection();
                 Statement statement = connection.createStatement();){
                statement.execute("alter system set master_token_validity=60,session_token_validity=20,SESSION_RECORD_ACCESS_INTERVAL_SECS=1");
            }
        }
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (!AssumptionUtils.isRunningOnGithubActions()) {
            try (Connection connection = HeartbeatIT.getSnowflakeAdminConnection();
                 Statement statement = connection.createStatement();){
                statement.execute("alter system set master_token_validity=default,session_token_validity=default,SESSION_RECORD_ACCESS_INTERVAL_SECS=default");
            }
        }
    }

    protected void submitQuery(boolean useKeepAliveSession, int queryIdx) throws SQLException, InterruptedException {
        Properties sessionParams = new Properties();
        sessionParams.put("CLIENT_SESSION_KEEP_ALIVE", useKeepAliveSession ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        try (Connection connection = HeartbeatIT.getConnection(sessionParams);
             Statement statement = connection.createStatement();){
            Thread.sleep(61000L);
            try (ResultSet resultSet = statement.executeQuery("SELECT 1");){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                Assertions.assertTrue((boolean)resultSet.next());
                logger.fine("Query " + queryIdx + " passed ");
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testSuccess() throws Exception {
        int concurrency = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ArrayList futures = new ArrayList();
        int idx = 0;
        while (idx < concurrency) {
            logger.fine("open a new connection and submit query " + idx);
            int queryIdx = idx++;
            futures.add(executorService.submit(() -> {
                try {
                    this.submitQuery(true, queryIdx);
                }
                catch (InterruptedException | SQLException e) {
                    throw new IllegalStateException("task interrupted", e);
                }
            }));
        }
        executorService.shutdown();
        for (idx = 0; idx < concurrency; ++idx) {
            ((Future)futures.get(idx)).get();
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testFailure() throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            Future<?> future = executorService.submit(() -> {
                try {
                    this.submitQuery(false, 0);
                }
                catch (SQLException e) {
                    throw new RuntimeSQLException("SQLException", e);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("task interrupted", e);
                }
            });
            executorService.shutdown();
            future.get();
            Assertions.fail((String)"should fail and raise an exception");
        }
        catch (ExecutionException ex) {
            Throwable rootCause = ex.getCause();
            MatcherAssert.assertThat((String)"Runtime Exception", (Object)rootCause, (Matcher)CoreMatchers.instanceOf(RuntimeSQLException.class));
            rootCause = rootCause.getCause();
            MatcherAssert.assertThat((String)"Root cause class", (Object)rootCause, (Matcher)CoreMatchers.instanceOf(SnowflakeSQLException.class));
            MatcherAssert.assertThat((String)"Error code", (Object)((SnowflakeSQLException)rootCause).getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)390114));
        }
    }

    class RuntimeSQLException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        RuntimeSQLException(String message, SQLException e) {
            super(message, e);
        }
    }
}

