/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.text.IsEmptyString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class MaxLobSizeLatestIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testIncreasedMaxLobSize() throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            stmt.execute("alter session set FEATURE_INCREASED_MAX_LOB_SIZE_IN_MEMORY='ENABLED'");
            stmt.execute("alter session set ENABLE_LARGE_VARCHAR_AND_BINARY_IN_RESULT=false");
            try {
                stmt.execute("select randstr(20000000, random()) as large_str");
            }
            catch (SnowflakeSQLException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"exceeds supported length"));
            }
            stmt.execute("alter session set ENABLE_LARGE_VARCHAR_AND_BINARY_IN_RESULT=true");
            try (ResultSet resultSet = stmt.executeQuery("select randstr(20000000, random()) as large_str");){
                Assertions.assertTrue((boolean)resultSet.next());
                MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)IsEmptyString.emptyOrNullString())));
            }
            finally {
                stmt.execute("alter session unset ENABLE_LARGE_VARCHAR_AND_BINARY_IN_RESULT");
                stmt.execute("alter session unset FEATURE_INCREASED_MAX_LOB_SIZE_IN_MEMORY");
            }
        }
    }
}

