/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class MultiStatementIT
extends BaseJDBCWithSharedConnectionIT {
    protected static String queryResultFormat = "json";

    @BeforeEach
    public void setQueryResultFormat() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
    }

    @Test
    public void testMultiStmtExecuteUpdateFail() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiStmtQuery = "select 1;\ncreate or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
            try {
                statement.executeUpdate(multiStmtQuery);
                Assertions.fail((String)"executeUpdate should have failed because the first statement yields a result set");
            }
            catch (SQLException ex) {
                MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.UPDATE_FIRST_RESULT_NOT_UPDATE_COUNT.getMessageCode()));
            }
        }
    }

    @Test
    public void testMultiStmtExecuteQueryFail() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            try {
                statement.executeQuery(multiStmtQuery);
                Assertions.fail((String)"executeQuery should have failed because the first statement yields an update count");
            }
            catch (SQLException ex) {
                MatcherAssert.assertThat((Object)ex.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.QUERY_FIRST_RESULT_NOT_RESULT_SET.getMessageCode()));
            }
        }
    }

    @Test
    public void testMultiStmtSetUnset() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("set testvar = 1; select 1");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            try (ResultSet rs = statement.executeQuery("select $testvar");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                try {
                    statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
                    statement.execute("unset testvar; select $testvar");
                    Assertions.fail((String)"Expected a failure");
                }
                catch (SQLException ex) {
                    Assertions.assertEquals((Object)"P0000", (Object)ex.getSQLState());
                }
                try {
                    statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
                    statement.execute("select $testvar");
                    Assertions.fail((String)"Expected a failure");
                }
                catch (SQLException ex) {
                    Assertions.assertEquals((Object)"02000", (Object)ex.getSQLState());
                }
            }
        }
    }

    @Test
    public void testMultiStmtParseError() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("set testvar = 1");
            try {
                statement.execute("garbage text; set testvar = 2");
                Assertions.fail((String)"Expected a compiler error to be thrown");
            }
            catch (SQLException ex) {
                Assertions.assertEquals((Object)"42000", (Object)ex.getSQLState());
            }
            try (ResultSet rs = statement.executeQuery("select $testvar");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
            }
        }
    }

    @Test
    public void testMultiStmtExecError() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
                statement.execute("set testvar = 1; select nonexistent_column from nonexistent_table; set testvar = 2");
                Assertions.fail((String)"Expected an execution error to be thrown");
            }
            catch (SQLException ex) {
                Assertions.assertEquals((Object)"P0000", (Object)ex.getSQLState());
            }
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            try (ResultSet rs = statement.executeQuery("select $testvar");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
            }
        }
    }

    @Test
    public void testMultiStmtTempTable() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String entry = "success";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("create or replace temporary table test_multi (cola string); insert into test_multi values ('" + entry + "')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            try (ResultSet rs = statement.executeQuery("select * from test_multi");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)entry, (Object)rs.getString(1));
            }
        }
    }

    @Test
    public void testMultiStmtUseStmt() throws SQLException {
        try (Statement statement = connection.createStatement();){
            SFSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
            String originalSchema = session.getSchema();
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("use schema public; select 1");
            Assertions.assertEquals((Object)"PUBLIC", (Object)session.getSchema());
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            try (ResultSet rs = statement.executeQuery("select current_schema()");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"PUBLIC", (Object)rs.getString(1));
            }
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute(String.format("use schema %s; select 1", originalSchema));
            session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
            Assertions.assertEquals((Object)originalSchema, (Object)session.getSchema());
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            rs = statement.executeQuery("select current_schema()");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)originalSchema, (Object)rs.getString(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testMultiStmtAlterSessionParams() throws SQLException {
        try (Statement statement = connection.createStatement();){
            SFSession session = statement.getConnection().unwrap(SnowflakeConnectionV1.class).getSfSession();
            String param = "AUTOCOMMIT";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("alter session set " + param + "=false; select 1");
            Assertions.assertFalse((boolean)session.getAutoCommit());
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("alter session set " + param + "=true; select 1");
            Assertions.assertTrue((boolean)session.getAutoCommit());
        }
    }

    @Test
    public void testMultiStmtMultiLine() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("select 1;\nselect 2");
            statement.execute("select \n 1; select 2");
            statement.execute("select \r\n 1; select 2");
        }
    }

    @Test
    public void testMultiStmtQuotes() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("create or replace temporary table \"test_multi\" (cola string); select * from \"test_multi\"");
            statement.execute("create or replace temporary table `test_multi` (cola string); select * from `test_multi`");
            statement.execute("select 'str'; select 'str2'");
            statement.execute("select '\\` backticks'; select '\\\\` more `backticks`'");
        }
    }

    @Test
    public void testMultiStmtCommitRollback() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.execute("begin");
            statement.execute("insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('def'); commit");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("rollback");
            try (ResultSet rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.execute("begin");
            statement.execute("insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('def'); rollback");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("commit");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("begin; insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("insert into test_multi_commit_rollback values ('def')");
            statement.execute("commit");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("begin; insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("insert into test_multi_commit_rollback values ('def')");
            statement.execute("rollback");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testMultiStmtCommitRollbackNoAutocommit() throws SQLException {
        try (Statement statement = connection.createStatement();){
            connection.setAutoCommit(false);
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.execute("insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('def'); commit");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("rollback");
            try (ResultSet rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.execute("insert into test_multi_commit_rollback values ('abc')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('def'); rollback");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("commit");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('abc'); insert into test_multi_commit_rollback values ('def')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("commit");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            statement.execute("create or replace table test_multi_commit_rollback (cola string)");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            statement.execute("insert into test_multi_commit_rollback values ('abc'); insert into test_multi_commit_rollback values ('def')");
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
            statement.execute("rollback");
            rs = statement.executeQuery("select count(*) from test_multi_commit_rollback");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testMultiStmtLarge() throws SQLException {
        try (Statement statement = connection.createStatement();){
            int i;
            StringBuilder multiStmtBuilder = new StringBuilder();
            String query = "SELECT %d;";
            for (i = 0; i < 100; ++i) {
                multiStmtBuilder.append(String.format(query, i));
            }
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)100);
            Assertions.assertTrue((boolean)statement.execute(multiStmtBuilder.toString()));
            for (i = 0; i < 100; ++i) {
                try (ResultSet rs = statement.getResultSet();){
                    Assertions.assertNotNull((Object)rs);
                    Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)i, (int)rs.getInt(1));
                    Assertions.assertFalse((boolean)rs.next());
                    if (i != 99) {
                        Assertions.assertTrue((boolean)statement.getMoreResults());
                        continue;
                    }
                    Assertions.assertFalse((boolean)statement.getMoreResults());
                    continue;
                }
            }
        }
    }

    @Test
    public void testMultiStmtCountNotMatch() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("select 1; select 2; select 3");
                Assertions.fail();
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)8));
            }
            try {
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
                statement.execute("select 1");
                Assertions.fail();
            }
            catch (SQLException e) {
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)8));
            }
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)0);
            statement.execute("select 1; select 2; select 3");
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testInvalidParameterCount() throws SQLException {
        String userName = null;
        String accountName = null;
        try (Statement statement = connection.createStatement();){
            try (ResultSet rs = statement.executeQuery("select current_account_locator()");){
                Assertions.assertTrue((boolean)rs.next());
                accountName = rs.getString(1);
            }
            rs = statement.executeQuery("select current_user()");
            try {
                Assertions.assertTrue((boolean)rs.next());
                userName = rs.getString(1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            String[] testSuites = new String[]{String.format("alter account %s set multi_statement_count = 20", accountName), String.format("alter account %s set multi_statement_count = -1", accountName), String.format("alter user %s set multi_statement_count = 20", userName), String.format("alter user %s set multi_statement_count = -1", userName), "alter session set multi_statement_count = -1"};
            int[] expectedErrorCodes = new int[]{1008, 1008, 1006, 1006, 1008};
            statement.execute("use role accountadmin");
            for (int i = 0; i < testSuites.length; ++i) {
                try {
                    statement.execute(testSuites[i]);
                    Assertions.fail();
                    continue;
                }
                catch (SQLException e) {
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)expectedErrorCodes[i]));
                }
            }
        }
    }
}

