/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class PreparedMultiStmtIT
extends BaseJDBCWithSharedConnectionIT {
    private static SnowflakeConnectionV1 sfConnectionV1;

    public PreparedMultiStmtIT() {
        sfConnectionV1 = (SnowflakeConnectionV1)connection;
    }

    public void setSessionResultFormat(String queryResultFormat) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteUpdateCount(String queryResultFormat) throws Exception {
        this.setSessionResultFormat(queryResultFormat);
        try (Statement statement = sfConnectionV1.createStatement();){
            try {
                statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
                statement.execute("create or replace table test_multi_bind(c1 number)");
                try (PreparedStatement preparedStatement = sfConnectionV1.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");){
                    MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
                    preparedStatement.setInt(1, 20);
                    preparedStatement.setInt(2, 30);
                    preparedStatement.setInt(3, 40);
                    int rowCount = preparedStatement.executeUpdate();
                    MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)preparedStatement.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                    MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)false));
                    MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)2));
                    try (ResultSet resultSet = statement.executeQuery("select c1 from test_multi_bind order by c1 asc");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)30));
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_multi_bind");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteLessBindings(String queryResultFormat) throws Exception {
        this.setSessionResultFormat(queryResultFormat);
        try (Statement statement = sfConnectionV1.createStatement();){
            try {
                statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
                statement.execute("create or replace table test_multi_bind(c1 number)");
                try (PreparedStatement preparedStatement = sfConnectionV1.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");){
                    MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
                    preparedStatement.setInt(1, 20);
                    preparedStatement.setInt(2, 30);
                    try {
                        preparedStatement.executeUpdate();
                        Assertions.fail();
                    }
                    catch (SQLException e) {
                        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)100132));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_multi_bind");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteMoreBindings(String queryResultFormat) throws Exception {
        this.setSessionResultFormat(queryResultFormat);
        try (Statement statement = sfConnectionV1.createStatement();){
            try {
                statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
                statement.execute("create or replace table test_multi_bind(c1 number)");
                try (PreparedStatement preparedStatement = sfConnectionV1.prepareStatement("insert into test_multi_bind(c1) values(?); insert into test_multi_bind values (?), (?)");){
                    MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)3));
                    preparedStatement.setInt(1, 20);
                    preparedStatement.setInt(2, 30);
                    preparedStatement.setInt(3, 40);
                    preparedStatement.setInt(4, 50);
                    int rowCount = preparedStatement.executeUpdate();
                    MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)preparedStatement.getResultSet(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                    MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)false));
                    MatcherAssert.assertThat((Object)preparedStatement.getUpdateCount(), (Matcher)CoreMatchers.is((Object)2));
                    try (ResultSet resultSet = statement.executeQuery("select c1 from test_multi_bind order by c1 asc");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)30));
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_multi_bind");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteQueryBindings(String queryResultFormat) throws Exception {
        this.setSessionResultFormat(queryResultFormat);
        try (Statement statement = sfConnectionV1.createStatement();){
            statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
            try (PreparedStatement preparedStatement = sfConnectionV1.prepareStatement("select ?; select ?, ?; select ?, ?, ?");){
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)6));
                preparedStatement.setInt(1, 10);
                preparedStatement.setInt(2, 20);
                preparedStatement.setInt(3, 30);
                preparedStatement.setInt(4, 40);
                preparedStatement.setInt(5, 50);
                preparedStatement.setInt(6, 60);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)10));
                }
                MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
                resultSet = preparedStatement.getResultSet();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
                    MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)30));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
                resultSet = preparedStatement.getResultSet();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
                    MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)50));
                    MatcherAssert.assertThat((Object)resultSet.getInt(3), (Matcher)CoreMatchers.is((Object)60));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteQueryNoBindings(String queryResultFormat) throws Exception {
        this.setSessionResultFormat(queryResultFormat);
        try (Statement statement = sfConnectionV1.createStatement();){
            statement.execute("alter session set MULTI_STATEMENT_COUNT=0");
            try (PreparedStatement preparedStatement = sfConnectionV1.prepareStatement("select 10; select 20, 30; select 40, 50, 60");){
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)10));
                }
                MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
                resultSet = preparedStatement.getResultSet();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)20));
                    MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)30));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                MatcherAssert.assertThat((Object)preparedStatement.getMoreResults(), (Matcher)CoreMatchers.is((Object)true));
                resultSet = preparedStatement.getResultSet();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)40));
                    MatcherAssert.assertThat((Object)resultSet.getInt(2), (Matcher)CoreMatchers.is((Object)50));
                    MatcherAssert.assertThat((Object)resultSet.getInt(3), (Matcher)CoreMatchers.is((Object)60));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }
}

