/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class PreparedStatement2IT
extends PreparedStatement0IT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStageBatchDates(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            Date dEpoch = new Date(0L);
            Date dAfterEpoch = new Date(86400000L);
            Date dBeforeEpoch = new Date(-86400000L);
            Date dNow = new Date(System.currentTimeMillis());
            Date dLeapYear = new Date(951782400000L);
            Date dFuture = new Date(32503680000000L);
            Date[] dates = new Date[]{dEpoch, dAfterEpoch, dBeforeEpoch, dNow, dLeapYear, dFuture};
            try {
                statement.execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
                try (PreparedStatement prepStatement = connection.prepareStatement("INSERT INTO test_prepst_date(id, d)  VALUES(?,?)");){
                    int[] countResult;
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                    for (int i = 0; i < dates.length; ++i) {
                        prepStatement.setInt(1, i);
                        prepStatement.setDate(2, dates[i]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assertions.assertEquals((int)1, (int)res);
                    }
                    Date[] nonStageResult = new Date[dates.length];
                    try (ResultSet rsNonStage = statement.executeQuery("SELECT * FROM test_prepst_date ORDER BY id ASC");){
                        for (int i = 0; i < nonStageResult.length; ++i) {
                            Assertions.assertTrue((boolean)rsNonStage.next());
                            nonStageResult[i] = rsNonStage.getDate(2);
                        }
                    }
                    statement.execute("DELETE FROM test_prepst_date WHERE 1=1");
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                    for (int i = 0; i < dates.length; ++i) {
                        prepStatement.setInt(1, i);
                        prepStatement.setDate(2, dates[i]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assertions.assertEquals((int)1, (int)res);
                    }
                    Date[] stageResult = new Date[dates.length];
                    try (ResultSet rsStage = statement.executeQuery("SELECT * FROM test_prepst_date ORDER BY id ASC");){
                        int i;
                        for (i = 0; i < stageResult.length; ++i) {
                            Assertions.assertTrue((boolean)rsStage.next());
                            stageResult[i] = rsStage.getDate(2);
                        }
                        for (i = 0; i < dates.length; ++i) {
                            Assertions.assertEquals((Object)nonStageResult[i], (Object)stageResult[i], (String)"Stage binding date should match non-stage binding date");
                        }
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS test_prepst_date");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBindWithNullValue(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table testBindNull(cola date, colb time, colc timestamp, cold number)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into testBindNull values (?, ?, ?, ?)");){
                Timestamp timestamp;
                Time time;
                Date date;
                prepStatement.setDate(1, null);
                prepStatement.setTime(2, null);
                prepStatement.setTimestamp(3, null);
                prepStatement.setBigDecimal(4, null);
                prepStatement.addBatch();
                prepStatement.executeBatch();
                try (ResultSet resultSet = statement.executeQuery("select * from testBindNull");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    date = resultSet.getDate(1);
                    Assertions.assertNull((Object)date);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                    time = resultSet.getTime(2);
                    Assertions.assertNull((Object)time);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                    timestamp = resultSet.getTimestamp(3);
                    Assertions.assertNull((Object)timestamp);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                    BigDecimal bg = resultSet.getBigDecimal(4);
                    Assertions.assertNull((Object)bg);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                }
                statement.execute("TRUNCATE table testbindnull");
                prepStatement.setDate(1, null, Calendar.getInstance());
                prepStatement.setTime(2, null, Calendar.getInstance());
                prepStatement.setTimestamp(3, null, Calendar.getInstance());
                prepStatement.setBigDecimal(4, null);
                prepStatement.addBatch();
                prepStatement.executeBatch();
                resultSet = statement.executeQuery("select * from testBindNull");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    date = resultSet.getDate(1);
                    Assertions.assertNull((Object)date);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                    time = resultSet.getTime(2);
                    Assertions.assertNull((Object)time);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                    timestamp = resultSet.getTimestamp(3);
                    Assertions.assertNull((Object)timestamp);
                    Assertions.assertTrue((boolean)resultSet.wasNull());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareDDL(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                try (PreparedStatement prepStatement = connection.prepareStatement("create or replace table testprepareddl(cola number)");){
                    prepStatement.execute();
                }
                try (ResultSet resultSet = statement.executeQuery("show tables like 'testprepareddl'");){
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
                }
            }
            finally {
                statement.execute("drop table if exists testprepareddl");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareSCL(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            try (PreparedStatement prepStatement = connection.prepareStatement("use SCHEMA  PUBLIC");){
                prepStatement.execute();
            }
            try (ResultSet resultSet = connection.createStatement().executeQuery("select current_schema()");){
                MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.is((Object)"PUBLIC"));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareTCL(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            String[] testCases;
            connection.setAutoCommit(false);
            for (String testCase : testCases = new String[]{"BEGIN", "COMMIT"}) {
                try (PreparedStatement prepStatement = connection.prepareStatement(testCase);
                     ResultSet resultSet = prepStatement.executeQuery();){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.is((Object)"Statement executed successfully."));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareShowCommand(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("show databases");
             ResultSet resultSet = prepStatement.executeQuery();){
            Assertions.assertTrue((boolean)resultSet.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testPrepareTimeout(String queryResultFormat) throws SQLException, InterruptedException {
        try (Connection adminCon = PreparedStatement2IT.getSnowflakeAdminConnection();
             Statement adminStatement = adminCon.createStatement();){
            adminStatement.execute("alter system set enable_combined_describe=true");
            try (Connection connection = this.getConn(queryResultFormat);
                 Statement statement = connection.createStatement();){
                statement.execute("create or replace table t(c1 string) as select 1");
                statement.execute("alter session set jdbc_enable_combined_describe=true");
                try (PreparedStatement prepStatement = connection.prepareStatement("select c1 from t order by c1 limit 1");){
                    Thread.sleep(5000L);
                    try (ResultSet resultSet = prepStatement.executeQuery();){
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
                    }
                }
                statement.execute("drop table if exists t");
            }
            finally {
                adminStatement.execute("alter system set enable_combined_describe=default");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSnow36284(String queryResultFormat) throws Exception {
        String query = "select * from (values ('a'), ('b')) x where x.COLUMN1 in (?,?);";
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.setString(1, "a");
            preparedStatement.setString(2, "b");
            try (ResultSet rs = preparedStatement.executeQuery();){
                int rowcount = 0;
                HashSet valuesReturned = Sets.newHashSetWithExpectedSize((int)2);
                while (rs.next()) {
                    ++rowcount;
                    valuesReturned.add(rs.getString(1));
                }
                Assertions.assertEquals((int)2, (int)rowcount, (String)"Should get back 2 rows");
                Assertions.assertEquals((Object)valuesReturned, (Object)Sets.newHashSet((Object[])new String[]{"a", "b"}), (String)"");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testSnow35923(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("alter session set optimizer_eliminate_scans_for_constant_select=false");
            statement.execute("create or replace table inc(a int, b int)");
            statement.execute("insert into inc(a, b) values (1, 2), (NULL, 4), (5,NULL), (7,8)");
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT coalesce(?, NULL) from inc;");){
                preparedStatement.setInt(1, 0);
                ResultSet rs = preparedStatement.executeQuery();
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBindObjectLiteral(String queryResultFormat) throws Exception {
        long t1Id = 0L;
        long t2Id = 0L;
        String t1 = null;
        try (Connection conn = this.getConn(queryResultFormat);
             Statement stmt = conn.createStatement();){
            int i;
            ResultSet result;
            int i2;
            ResultSet result2;
            String sqlText = "create or replace table identifier(?) (c1 number)";
            try (SnowflakePreparedStatementV1 pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);){
                t1 = "bindObjectTable1";
                pStmt.setString(1, t1);
                result2 = pStmt.executeQuery();
                if (result2 != null) {
                    result2.close();
                }
            }
            stmt.execute("select parse_json(system$dict_id('table', '" + t1 + "')):entityId;");
            try (ResultSet result3 = stmt.getResultSet();){
                if (result3.next()) {
                    t1Id = Long.valueOf(result3.getString(1));
                }
                Assertions.assertTrue((t1Id != 0L ? 1 : 0) != 0);
            }
            sqlText = "insert into identifier(?) values (1), (2), (3)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setParameter("resolve_object_ids", (Object)true);
                pStmt.setLong(1, t1Id);
                result2 = pStmt.executeQuery();
                if (result2 != null) {
                    result2.close();
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "select * from identifier(?) order by 1";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setString(1, t1);
                result2 = pStmt.executeQuery();
                try {
                    for (i2 = 0; i2 < 3; ++i2) {
                        Assertions.assertTrue((boolean)result2.next());
                    }
                    Assertions.assertFalse((boolean)result2.next());
                }
                finally {
                    if (result2 != null) {
                        result2.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "alter table identifier(?) add column c2 number";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setParameter("resolve_object_ids", (Object)true);
                pStmt.setLong(1, t1Id);
                result2 = pStmt.executeQuery();
                if (result2 != null) {
                    result2.close();
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "desc table identifier(?)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setString(1, t1);
                result2 = pStmt.executeQuery();
                try {
                    for (i2 = 0; i2 < 2; ++i2) {
                        Assertions.assertTrue((boolean)result2.next());
                    }
                    Assertions.assertFalse((boolean)result2.next());
                }
                finally {
                    if (result2 != null) {
                        result2.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            String t2 = "bindObjectTable2";
            sqlText = "create or replace table identifier(?) (c1 number)";
            try (SnowflakePreparedStatementV1 pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);){
                pStmt.setString(1, t2);
                result = pStmt.executeQuery();
                if (result != null) {
                    result.close();
                }
            }
            stmt.execute("select parse_json(system$dict_id('table', '" + t2 + "')):entityId;");
            result2 = stmt.getResultSet();
            try {
                if (result2.next()) {
                    t2Id = Long.valueOf(result2.getString(1));
                }
                Assertions.assertTrue((t2Id != 0L ? 1 : 0) != 0);
            }
            finally {
                if (result2 != null) {
                    result2.close();
                }
            }
            sqlText = "insert into identifier(?) values (?), (?), (?)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setString(1, t2);
                pStmt.setInt(2, 1);
                pStmt.setInt(3, 2);
                pStmt.setInt(4, 3);
                result = pStmt.executeQuery();
                if (result != null) {
                    result.close();
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "select * from identifier(?) order by 1";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setParameter("resolve_object_ids", (Object)true);
                pStmt.setLong(1, t2Id);
                result = pStmt.executeQuery();
                try {
                    for (i = 0; i < 3; ++i) {
                        Assertions.assertTrue((boolean)result.next());
                    }
                    Assertions.assertFalse((boolean)result.next());
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "select t2.c1 from identifier(?) as t1, identifier(?) as t2 where t1.c1 = t2.c1 and t1.c1 > (?)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setParameter("resolve_object_ids", (Object)true);
                pStmt.setString(1, t1);
                pStmt.setLong(2, t2Id);
                pStmt.setInt(3, 1);
                result = pStmt.executeQuery();
                try {
                    for (i = 0; i < 2; ++i) {
                        Assertions.assertTrue((boolean)result.next());
                    }
                    Assertions.assertFalse((boolean)result.next());
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "drop table identifier(?)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setString(1, "bindObjectTable1");
                result = pStmt.executeQuery();
                if (result != null) {
                    result.close();
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            sqlText = "drop table identifier(?)";
            pStmt = (SnowflakePreparedStatementV1)conn.prepareStatement(sqlText);
            try {
                pStmt.setParameter("resolve_object_ids", (Object)true);
                pStmt.setLong(1, t2Id);
                result = pStmt.executeQuery();
                if (result != null) {
                    result.close();
                }
            }
            finally {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            stmt.execute("show tables like 'bindobjecttable%'");
            result2 = stmt.getResultSet();
            try {
                Assertions.assertFalse((boolean)result2.next());
            }
            finally {
                if (result2 != null) {
                    result2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBindTimestampTZViaString(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter session set timestamp_tz_output_format='YYYY-MM-DD HH24:MI:SS.FF9 TZHTZM'");
                statement.execute("create or replace  table testbindtstz(cola timestamp_tz)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testbindtstz values(?)");){
                    preparedStatement.setString(1, "2017-11-30T18:17:05.123456789+08:00");
                    int count = preparedStatement.executeUpdate();
                    MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)1));
                }
                try (ResultSet resultSet = statement.executeQuery("select * from testbindtstz");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.is((Object)"2017-11-30 18:17:05.123456789 +0800"));
                }
            }
            finally {
                statement.execute("drop table if exists testbindtstz");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBindTimestampTZViaStringBatch(String queryResultFormat) throws SQLException {
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                statement.execute("create or replace table testbindtstz(cola timestamp_tz, colb timestamp_ntz)");
                statement.execute("ALTER SESSION SET TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
                statement.execute("ALTER SESSION SET TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testbindtstz values(?,?)");){
                    preparedStatement.setString(1, "2017-11-30 18:17:05.123456789 +08:00");
                    preparedStatement.setString(2, "2017-11-30 18:17:05.123456789");
                    preparedStatement.addBatch();
                    preparedStatement.setString(1, "2017-05-03 16:44:42.0");
                    preparedStatement.setString(2, "2017-05-03 16:44:42.0");
                    preparedStatement.addBatch();
                    int[] count = preparedStatement.executeBatch();
                    MatcherAssert.assertThat((Object)count[0], (Matcher)CoreMatchers.is((Object)1));
                    try (ResultSet resultSet = statement.executeQuery("select * from testbindtstz order by 1 desc");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.is((Object)"Thu, 30 Nov 2017 18:17:05 +0800"));
                        MatcherAssert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.is((Object)"Thu, 30 Nov 2017 18:17:05 Z"));
                        Assertions.assertTrue((boolean)resultSet.next());
                        MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.is((Object)"Wed, 03 May 2017 16:44:42 -0700"));
                        MatcherAssert.assertThat((Object)resultSet.getString(2), (Matcher)CoreMatchers.is((Object)"Wed, 03 May 2017 16:44:42 Z"));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists testbindtstz");
            }
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSnow41620(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE or REPLACE TABLE SNOW41620 (c1 varchar(20),c2 int  )");
            statement.execute("insert into SNOW41620 values('value1', 1), ('value2', 2), ('value3', 3)");
            String PARAMETERIZED_QUERY = "SELECT t0.C1, CASE WHEN t0.C1 IN (?, ?) THEN t0.C2  ELSE null END, CASE WHEN t0.C1 IN (?, ?) THEN t0.C2  ELSE null END FROM SNOW41620 t0";
            try (PreparedStatement pst = connection.prepareStatement(PARAMETERIZED_QUERY);){
                pst.setObject(1, "value1");
                pst.setObject(2, "value3");
                pst.setObject(3, "value2");
                pst.setObject(4, "value3");
                try (ResultSet bindStmtResultSet = pst.executeQuery();){
                    String DIRECT_QUERY = "SELECT t0.C1, CASE WHEN t0.C1 IN ('value1', 'value3') THEN t0.C2  ELSE null END,CASE WHEN t0.C1 IN ('value2', 'value3') THEN t0.C2  ELSE null END FROM SNOW41620 t0";
                    try (PreparedStatement pst1 = connection.prepareStatement(DIRECT_QUERY);
                         ResultSet directStmtResultSet = pst1.executeQuery();){
                        this.checkResultSetEqual(bindStmtResultSet, directStmtResultSet);
                    }
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSnow50141(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("select 1 where true=?");){
            prepStatement.setObject(1, true);
            try (ResultSet resultSet = prepStatement.executeQuery();){
                MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    private void checkResultSetEqual(ResultSet rs1, ResultSet rs2) throws SQLException {
        int columns = rs1.getMetaData().getColumnCount();
        Assertions.assertEquals((int)columns, (int)rs2.getMetaData().getColumnCount(), (String)"Resultsets do not match in the number of columns returned");
        while (rs1.next() && rs2.next()) {
            for (int columnIndex = 1; columnIndex <= columns; ++columnIndex) {
                Object res1 = rs1.getObject(columnIndex);
                Object res2 = rs2.getObject(columnIndex);
                Assertions.assertEquals((Object)res1, (Object)res2, (String)String.format("%s and %s are not equal values at column %d", res1, res2, columnIndex));
            }
            Assertions.assertEquals((Object)rs1.isLast(), (Object)rs2.isLast(), (String)"Number of records returned by the results does not match");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPreparedStatementWithSkipParsing(String queryResultFormat) throws Exception {
        try (Connection con = this.getConn(queryResultFormat);){
            PreparedStatement stmt = con.unwrap(SnowflakeConnectionV1.class).prepareStatement("select 1", true);
            try (ResultSet rs = stmt.executeQuery();){
                MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                MatcherAssert.assertThat((Object)rs.getInt(1), (Matcher)CoreMatchers.is((Object)1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPreparedStatementWithSkipParsingAndBinding(String queryResultFormat) throws Exception {
        try (Connection con = this.getConn(queryResultFormat);
             Statement statement = con.createStatement();){
            statement.execute("create or replace table t(c1 int)");
            try {
                try (PreparedStatement stmt = con.unwrap(SnowflakeConnectionV1.class).prepareStatement("insert into t(c1) values(?)", true);){
                    stmt.setInt(1, 123);
                    int ret = stmt.executeUpdate();
                    MatcherAssert.assertThat((Object)ret, (Matcher)CoreMatchers.is((Object)1));
                }
                stmt = con.unwrap(SnowflakeConnectionV1.class).prepareStatement("select * from t", true);
                try (ResultSet rs = stmt.executeQuery();){
                    MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)rs.getInt(1), (Matcher)CoreMatchers.is((Object)123));
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists t");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSnow44393(String queryResultFormat) throws Exception {
        try (Connection con = this.getConn(queryResultFormat);){
            Assertions.assertFalse((boolean)con.createStatement().execute("alter session set timestamp_ntz_output_format='YYYY-MM-DD HH24:MI:SS'"));
            try (PreparedStatement stmt = con.prepareStatement("select to_timestamp_ntz(?, 3)");){
                stmt.setBigDecimal(1, new BigDecimal("1261440000000"));
                try (ResultSet resultSet = stmt.executeQuery();){
                    Assertions.assertTrue((boolean)resultSet.next());
                    String res = resultSet.getString(1);
                    MatcherAssert.assertThat((Object)res, (Matcher)CoreMatchers.is((Object)"2009-12-22 00:00:00"));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testAddBatchNumericNullFloatMixed(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);){
            for (int threshold = 0; threshold < 2; ++threshold) {
                connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = " + threshold);
                String sql = "insert into TEST_PREPST(col, colB) values(?,?)";
                try (PreparedStatement stmt = connection.prepareStatement(sql);){
                    stmt.setInt(1, 1);
                    stmt.setNull(2, 2);
                    stmt.addBatch();
                    stmt.setInt(1, 2);
                    stmt.setObject(2, Float.valueOf(4.0f));
                    stmt.addBatch();
                    stmt.executeBatch();
                    Assertions.assertTrue((boolean)stmt.isWrapperFor(SnowflakePreparedStatement.class));
                    String qid1 = stmt.unwrap(SnowflakePreparedStatement.class).getQueryID();
                    Assertions.assertNotNull((Object)qid1);
                }
                stmt = connection.prepareStatement(sql);
                try {
                    stmt.setInt(1, 1);
                    stmt.setNull(2, 1);
                    stmt.addBatch();
                    stmt.setInt(1, 2);
                    stmt.setObject(2, Float.valueOf(4.0f));
                    stmt.addBatch();
                    stmt.executeBatch();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = connection.prepareStatement(sql);
                try {
                    stmt.setInt(1, 2);
                    stmt.setObject(2, Float.valueOf(4.0f));
                    stmt.addBatch();
                    stmt.setInt(1, 1);
                    stmt.setNull(2, 2);
                    stmt.addBatch();
                    stmt.setInt(1, 1);
                    stmt.setNull(2, 16);
                    stmt.addBatch();
                    stmt.executeBatch();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                stmt = connection.prepareStatement(sql);
                try {
                    stmt.setInt(1, 1);
                    stmt.setNull(2, 2);
                    stmt.addBatch();
                    stmt.setInt(1, 2);
                    stmt.setObject(2, Float.valueOf(4.0f));
                    stmt.addBatch();
                    stmt.setInt(1, 1);
                    stmt.setObject(2, "test1");
                    try {
                        stmt.addBatch();
                        Assertions.fail((String)"Must fail");
                    }
                    catch (SnowflakeSQLException ex) {
                        MatcherAssert.assertThat((String)"Error code is wrong", (Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode()));
                        MatcherAssert.assertThat((String)"Location", (Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Column: 2, Row: 3"));
                    }
                    continue;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInvalidUsageOfApi(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);
             final PreparedStatement preparedStatement = connection.prepareStatement("select 1");){
            int expectedCode = ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API.getMessageCode();
            this.assertException(new RunnableWithSQLException(){

                @Override
                public void run() throws SQLException {
                    preparedStatement.executeUpdate("select 1");
                }
            }, expectedCode);
            this.assertException(new RunnableWithSQLException(){

                @Override
                public void run() throws SQLException {
                    preparedStatement.execute("select 1");
                }
            }, expectedCode);
            this.assertException(new RunnableWithSQLException(){

                @Override
                public void run() throws SQLException {
                    preparedStatement.addBatch("select 1");
                }
            }, expectedCode);
        }
    }

    private void assertException(RunnableWithSQLException runnable, int expectedCode) {
        try {
            runnable.run();
            Assertions.fail();
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)expectedCode));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testCreatePreparedStatementWithParameters(String queryResultFormat) throws Throwable {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.prepareStatement("select 1", 1003, 1007);
            try {
                connection.prepareStatement("select 1", 1003, 1008);
                Assertions.fail((String)"updateable cursor is not supported.");
            }
            catch (SQLException ex) {
                Assertions.assertEquals((int)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode(), (int)ex.getErrorCode());
            }
            connection.prepareStatement("select 1", 1003, 1007, 2);
            try {
                connection.prepareStatement("select 1", 1003, 1007, 1);
                Assertions.fail((String)"hold cursor over commit is not supported.");
            }
            catch (SQLException ex) {
                Assertions.assertEquals((int)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode(), (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareAndGetMeta(String queryResultFormat) throws SQLException {
        try (Connection con = this.getConn(queryResultFormat);){
            try (PreparedStatement prepStatement = con.prepareStatement("select 1 where 1 > ?");){
                ResultSetMetaData meta = prepStatement.getMetaData();
                MatcherAssert.assertThat((Object)meta.getColumnCount(), (Matcher)CoreMatchers.is((Object)1));
            }
            prepStatement = con.prepareStatement("select 1 where 1 > ?");
            try {
                ParameterMetaData parameterMetaData = prepStatement.getParameterMetaData();
                MatcherAssert.assertThat((Object)parameterMetaData.getParameterCount(), (Matcher)CoreMatchers.is((Object)1));
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    private static interface RunnableWithSQLException {
        public void run() throws SQLException;
    }
}

