/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Properties;
import net.snowflake.client.jdbc.BaseWiremockTest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class ProxyLatestIT
extends BaseWiremockTest {
    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.unsetJvmProperties();
    }

    private String getProxyProtocol(Properties props) {
        return props.get("ssl").toString().equals("on") ? "https" : "http";
    }

    private int getProxyPort(String proxyProtocol) {
        if (Objects.equals(proxyProtocol, "http")) {
            return wiremockHttpPort;
        }
        return wiremockHttpsPort;
    }

    private void addProxyProperties(Properties props) {
        String proxyProtocol = this.getProxyProtocol(props);
        props.put("useProxy", "true");
        props.put("proxyProtocol", proxyProtocol);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", String.valueOf(this.getProxyPort(proxyProtocol)));
    }

    private void setJvmProperties(Properties props) {
        String proxyProtocol = this.getProxyProtocol(props);
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyProtocol", proxyProtocol);
        if (Objects.equals(proxyProtocol, "http")) {
            System.setProperty("http.proxyHost", "localhost");
            System.setProperty("http.proxyPort", String.valueOf(this.getProxyPort(proxyProtocol)));
        } else {
            System.setProperty("https.proxyHost", "localhost");
            System.setProperty("https.proxyPort", String.valueOf(this.getProxyPort(proxyProtocol)));
        }
    }

    private void unsetJvmProperties() {
        System.clearProperty("http.useProxy");
        System.clearProperty("http.proxyProtocol");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
    }

    private String getSnowflakeUrl(Properties props) {
        String protocol = this.getProxyProtocol(props);
        return String.format("%s://%s:%s", protocol, props.get("host"), props.get("port"));
    }

    private void proxyAll(Properties props) {
        String template = "{\n  \"request\": {\n    \"method\": \"ANY\",\n    \"urlPattern\": \".*\"\n  }\n,  \"response\": { \"proxyBaseUrl\": \"%s\" }\n}";
        String body = String.format(template, this.getSnowflakeUrl(props));
        this.addMapping(body);
    }

    private void verifyProxyWasUsed() {
        this.verifyRequestToProxy(".*login.*", 1);
        this.verifyRequestToProxy(".*query.*", 1);
    }

    private void verifyProxyNotUsed() {
        this.verifyRequestToProxy(".*", 0);
    }

    private void connectAndVerifySimpleQuery(Properties props) throws SQLException {
        try (Connection con = DriverManager.getConnection(String.format("jdbc:snowflake://%s:%s", props.get("host"), props.get("port")), props);
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("select 1");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    private void verifyRequestToProxy(String pathPattern, int expectedCount) {
        String body = String.format("{ \"method\":\"POST\",\"urlPattern\": \".*%s.*\" }", pathPattern);
        HttpPost postRequest = this.createWiremockPostRequest(body, "/__admin/requests/count");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);){
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(responseString);
            Assertions.assertEquals((int)expectedCount, (int)json.get("count").asInt(), (String)("expected request count not matched for pattern: " + pathPattern));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testProxyIsUsedWhenSetInProperties() throws SQLException {
        this.setCustomTrustStorePropertyPath();
        Properties props = this.getProperties();
        this.addProxyProperties(props);
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyWasUsed();
    }

    @Test
    public void testProxyIsUsedWhenSetInJVMParams() throws SQLException {
        this.setCustomTrustStorePropertyPath();
        Properties props = this.getProperties();
        this.setJvmProperties(props);
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyWasUsed();
    }

    @Test
    public void testProxyNotUsedWhenNonProxyHostsMatchingInProperties() throws SQLException {
        Properties props = this.getProperties();
        this.addProxyProperties(props);
        props.put("nonProxyHosts", "*");
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyNotUsed();
    }

    @Test
    public void testProxyIsUsedWhenNonProxyHostsNotMatchingInProperties() throws SQLException {
        this.setCustomTrustStorePropertyPath();
        Properties props = this.getProperties();
        this.addProxyProperties(props);
        props.put("nonProxyHosts", "notMatchingHost");
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyWasUsed();
    }

    @Test
    public void testProxyNotUsedWhenNonProxyHostsMatchingInJVMParams() throws SQLException {
        Properties props = this.getProperties();
        this.setJvmProperties(props);
        System.setProperty("http.nonProxyHosts", "*");
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyNotUsed();
    }

    @Test
    public void testProxyUsedWhenNonProxyHostsNotMatchingInJVMParams() throws SQLException {
        this.setCustomTrustStorePropertyPath();
        Properties props = this.getProperties();
        this.setJvmProperties(props);
        System.setProperty("http.nonProxyHosts", "notMatchingHost");
        this.proxyAll(props);
        this.connectAndVerifySimpleQuery(props);
        this.verifyProxyWasUsed();
    }
}

