/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class PutUnescapeBackslashIT
extends AbstractDriverIT {
    @BeforeAll
    public static void setUpClass() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutFileUnescapeBackslashes() throws Exception {
        String remoteSubDir = "testPut";
        String testDataFileName = "testdata.txt";
        Path topDataDir = null;
        try {
            topDataDir = Files.createTempDirectory("testPutFileUnescapeBackslashes", new FileAttribute[0]);
            topDataDir.toFile().deleteOnExit();
            Path subDir = Files.createDirectories(Paths.get(topDataDir.toString(), "test dir\\\\3"), new FileAttribute[0]);
            File dataFile = new File(subDir.toFile(), testDataFileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dataFile.getCanonicalPath()), "UTF-8"));){
                writer.write("1,test1");
            }
            try (Connection connection = PutUnescapeBackslashIT.getConnection();
                 Statement statement = connection.createStatement();){
                try {
                    String sql = String.format("PUT 'file://%s' @~/%s/", dataFile.getCanonicalPath(), remoteSubDir);
                    sql = sql.replaceAll("\\\\", "\\\\\\\\");
                    statement.execute(sql);
                    try (ResultSet resultSet = connection.createStatement().executeQuery(String.format("LS @~/%s/", remoteSubDir));){
                        while (resultSet.next()) {
                            MatcherAssert.assertThat((String)"File name doesn't match", (Object)resultSet.getString(1), (Matcher)CoreMatchers.startsWith((String)String.format("%s/%s", remoteSubDir, testDataFileName)));
                        }
                    }
                }
                catch (Throwable throwable) {
                    statement.execute(String.format("RM @~/%s", remoteSubDir));
                    throw throwable;
                }
                statement.execute(String.format("RM @~/%s", remoteSubDir));
            }
        }
        finally {
            FileUtils.deleteDirectory((File)topDataDir.toFile());
        }
    }
}

