/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.jdbc.BaseWiremockTest;
import net.snowflake.client.jdbc.RestRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class RestRequestWiremockLatestIT
extends BaseWiremockTest {
    String connectionResetByPeerScenario = "{\n    \"mappings\": [\n        {\n            \"scenarioName\": \"Connection reset by peer\",\n            \"requiredScenarioState\": \"Started\",\n            \"newScenarioState\": \"Connection is stable\",\n            \"request\": {\n                \"method\": \"GET\",\n                \"url\": \"/endpoint\"\n            },\n            \"response\": {\n                \"fault\": \"CONNECTION_RESET_BY_PEER\"\n            }\n        },\n        {\n            \"scenarioName\": \"Connection reset by peer\",\n            \"requiredScenarioState\": \"Connection is stable\",\n            \"request\": {\n                \"method\": \"GET\",\n                \"url\": \"/endpoint\"\n            },\n            \"response\": {\n                \"status\": 200\n            }\n        }\n    ],\n    \"importOptions\": {\n        \"duplicatePolicy\": \"IGNORE\",\n        \"deleteAllNotInImport\": true\n    }}";

    @Test
    public void testProxyIsUsedWhenSetInProperties() throws Exception {
        this.importMapping(this.connectionResetByPeerScenario);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().disableAutomaticRetries();
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            HttpGet request = new HttpGet(String.format("http://%s:%d/endpoint", "localhost", wiremockHttpPort));
            RestRequest.execute((CloseableHttpClient)httpClient, (HttpRequestBase)request, (long)0L, (long)0L, (int)0, (int)0, (int)0, (AtomicBoolean)new AtomicBoolean(false), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (ExecTimeTelemetryData)new ExecTimeTelemetryData());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            assert (response.getStatusLine().getStatusCode() == 200);
        }
    }
}

