/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="resultSet")
public class ResultSetAlreadyClosedIT
extends BaseJDBCWithSharedConnectionIT {
    @Test
    public void testQueryResultSetAlreadyClosed() throws Throwable {
        try (Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select 1");
            resultSet.close();
            this.checkAlreadyClosed(resultSet);
        }
    }

    @Test
    public void testMetadataResultSetAlreadyClosed() throws Throwable {
        String database = connection.getCatalog();
        String schema = connection.getSchema();
        DatabaseMetaData metaData = connection.getMetaData();
        this.checkAlreadyClosed(metaData.getCatalogs());
        this.checkAlreadyClosed(metaData.getSchemas());
        this.checkAlreadyClosed(metaData.getSchemas(database, null));
        this.checkAlreadyClosed(metaData.getTables(database, schema, null, null));
        this.checkAlreadyClosed(metaData.getColumns(database, schema, null, null));
    }

    @Test
    public void testResultSetAlreadyClosed() throws Throwable {
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT 1");){
            this.checkAlreadyClosed(resultSet);
        }
    }

    @Test
    public void testEmptyResultSetAlreadyClosed() throws Throwable {
        try (SnowflakeResultSetV1.EmptyResultSet resultSet = new SnowflakeResultSetV1.EmptyResultSet();){
            this.checkAlreadyClosedEmpty(resultSet);
        }
    }

    private void checkAlreadyClosed(ResultSet resultSet) throws SQLException {
        resultSet.close();
        resultSet.close();
        Assertions.assertTrue((boolean)resultSet.isClosed());
        Assertions.assertFalse((boolean)resultSet.next());
        this.expectResultSetAlreadyClosedException(resultSet::wasNull);
        this.expectResultSetAlreadyClosedException(() -> resultSet.getString(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBoolean(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getByte(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getShort(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getInt(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getLong(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getFloat(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDouble(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBigDecimal(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBytes(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDate(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTime(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTimestamp(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getCharacterStream(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getClob(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDate(1, Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTime(1, Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTimestamp(1, Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getString("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBoolean("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getByte("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getShort("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getInt("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getLong("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getFloat("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDouble("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBigDecimal("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBytes("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getString("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDate("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTime("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTimestamp("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getCharacterStream("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getClob("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getDate("col1", Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTime("col1", Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getTimestamp("col1", Calendar.getInstance()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBigDecimal(1, 28));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBigDecimal("col1", 38));
        this.expectResultSetAlreadyClosedException(resultSet::getWarnings);
        this.expectResultSetAlreadyClosedException(() -> resultSet.unwrap(SnowflakeBaseResultSet.class).getWarnings());
        this.expectResultSetAlreadyClosedException(resultSet::clearWarnings);
        this.expectResultSetAlreadyClosedException(() -> resultSet.unwrap(SnowflakeBaseResultSet.class).clearWarnings());
        this.expectResultSetAlreadyClosedException(resultSet::getMetaData);
        this.expectResultSetAlreadyClosedException(() -> resultSet.findColumn("col1"));
        this.expectResultSetAlreadyClosedException(resultSet::isBeforeFirst);
        this.expectResultSetAlreadyClosedException(resultSet::isAfterLast);
        this.expectResultSetAlreadyClosedException(resultSet::isFirst);
        this.expectResultSetAlreadyClosedException(resultSet::isLast);
        this.expectResultSetAlreadyClosedException(resultSet::getRow);
        this.expectResultSetAlreadyClosedException(() -> resultSet.setFetchDirection(1000));
        this.expectResultSetAlreadyClosedException(() -> resultSet.setFetchSize(10));
        this.expectResultSetAlreadyClosedException(() -> resultSet.unwrap(SnowflakeBaseResultSet.class).setFetchSize(10));
        this.expectResultSetAlreadyClosedException(resultSet::getFetchDirection);
        this.expectResultSetAlreadyClosedException(resultSet::getFetchSize);
        this.expectResultSetAlreadyClosedException(resultSet::getType);
        this.expectResultSetAlreadyClosedException(resultSet::getConcurrency);
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeBaseResultSet)resultSet.unwrap(SnowflakeBaseResultSet.class)).getConcurrency());
        this.expectResultSetAlreadyClosedException(resultSet::getHoldability);
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeBaseResultSet)resultSet.unwrap(SnowflakeBaseResultSet.class)).getHoldability());
        this.expectResultSetAlreadyClosedException(resultSet::getStatement);
    }

    private void checkAlreadyClosedEmpty(SnowflakeResultSetV1.EmptyResultSet resultSet) throws SQLException {
        resultSet.close();
        resultSet.close();
        Assertions.assertTrue((boolean)resultSet.isClosed());
        Assertions.assertFalse((boolean)resultSet.next());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).beforeFirst());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).afterLast());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).first());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).last());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).getRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).previous());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).rowUpdated());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).rowInserted());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).rowDeleted());
        this.expectResultSetAlreadyClosedException(() -> resultSet.absolute(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.relative(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.setFetchDirection(1));
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).getFetchDirection());
        this.expectResultSetAlreadyClosedException(() -> resultSet.setFetchSize(1));
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).getFetchSize());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).getType());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).getConcurrency());
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNull(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNull("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBoolean(2, true));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBoolean("col2", true));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateByte(3, (byte)0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateByte("col3", (byte)0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateShort(4, (short)0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateShort("col4", (short)0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateInt(5, 0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateInt("col5", 0));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateLong(6, 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateLong("col6", 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateFloat(6, 4.0f));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateFloat("col6", 4.0f));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateDouble(7, 12.5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateDouble("col7", 12.5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBigDecimal(8, BigDecimal.valueOf(12.5)));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBigDecimal("col8", BigDecimal.valueOf(12.5)));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateString(9, "hello"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateString("col9", "hello"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBytes(10, new byte[0]));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBytes("col10", new byte[0]));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateDate(11, new Date(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateDate("col11", new Date(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateTime(12, new Time(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateTime("col12", new Time(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateTimestamp(13, new Timestamp(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateTimestamp("col13", new Timestamp(System.currentTimeMillis())));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream(14, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream(14, (InputStream)new BaseJDBCTest.FakeInputStream(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream(14, (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream("col14", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream("col14", (InputStream)new BaseJDBCTest.FakeInputStream(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateAsciiStream("col14", (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getAsciiStream(14));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getAsciiStream("col14"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream(15, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream(15, (InputStream)new BaseJDBCTest.FakeInputStream(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream(15, (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream("col15", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream("col15", (InputStream)new BaseJDBCTest.FakeInputStream(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBinaryStream("col15", (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBinaryStream(15));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBinaryStream("col15"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream(16, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream(16, (Reader)new BaseJDBCTest.FakeReader(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream(16, (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream("col16", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream("col16", (Reader)new BaseJDBCTest.FakeReader(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateCharacterStream("col16", (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateObject(17, new Object()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateObject(17, new Object(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateObject("col17", new Object()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateObject("col17", new Object(), 5));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject(17, SnowflakeResultSetV1.class));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject("col17", SnowflakeResultSetV1.class));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject(17, SnowflakeResultSetV1.class));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getObject("col17", SnowflakeResultSetV1.class));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob(18, (Blob)new BaseJDBCTest.FakeBlob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob(18, (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob(18, (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob("col18", (Blob)new BaseJDBCTest.FakeBlob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob("col18", (InputStream)new BaseJDBCTest.FakeInputStream()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateBlob("col18", (InputStream)new BaseJDBCTest.FakeInputStream(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBlob(18));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getBlob("col18"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNull(19));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNull("col19"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getUnicodeStream(20));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getUnicodeStream("col20"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateRef(21, (Ref)new BaseJDBCTest.FakeRef()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateRef("col21", (Ref)new BaseJDBCTest.FakeRef()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getRef(21));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getRef("col21"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateArray(22, (Array)new BaseJDBCTest.FakeArray()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateArray("col22", (Array)new BaseJDBCTest.FakeArray()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getArray(22));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getArray("col22"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getURL(23));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getURL("col23"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob(24, (Clob)new BaseJDBCTest.FakeNClob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob(24, (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob(24, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob("col24", (Clob)new BaseJDBCTest.FakeNClob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob("col24", (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateClob("col24", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNString(25, "hello"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNString("col25", "hello"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNString(25));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNString("col25"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob(26, (NClob)new BaseJDBCTest.FakeNClob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob(26, (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob(26, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob("col26", (NClob)new BaseJDBCTest.FakeNClob()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob("col26", (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNClob("col26", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNClob(26));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNClob("col26"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNCharacterStream(27, (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNCharacterStream(27, (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNCharacterStream("col26", (Reader)new BaseJDBCTest.FakeReader()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateNCharacterStream("col26", (Reader)new BaseJDBCTest.FakeReader(), 5L));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNCharacterStream(26));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getNCharacterStream("col26"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateSQLXML(27, (SQLXML)new BaseJDBCTest.FakeSQLXML()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateSQLXML("col27", (SQLXML)new BaseJDBCTest.FakeSQLXML()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getSQLXML(27));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getSQLXML("col27"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getRowId(1));
        this.expectResultSetAlreadyClosedException(() -> resultSet.getRowId("col1"));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateRowId(1, (RowId)new BaseJDBCTest.FakeRowId()));
        this.expectResultSetAlreadyClosedException(() -> resultSet.updateRowId("col1", (RowId)new BaseJDBCTest.FakeRowId()));
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).insertRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).updateRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).deleteRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).refreshRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).cancelRowUpdates());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).moveToInsertRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).moveToCurrentRow());
        this.expectResultSetAlreadyClosedException(() -> ((SnowflakeResultSetV1.EmptyResultSet)resultSet).cancelRowUpdates());
        this.expectResultSetAlreadyClosedException(() -> resultSet.isWrapperFor(SnowflakeResultSetV1.class));
        this.expectResultSetAlreadyClosedException(() -> resultSet.unwrap(SnowflakeResultSetV1.class));
    }
}

