/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.ResultSetArrowForce0MultiTimeZone;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="arrow")
public class ResultSetArrowForceTZMultiTimeZoneIT
extends ResultSetArrowForce0MultiTimeZone {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=ResultSetArrowForce0MultiTimeZone.DataWithScaleProvider.class)
    public void testTimestampTZWithScale(String queryResultFormat, String tz, int scale) throws SQLException {
        ResultSetArrowForceTZMultiTimeZoneIT.setTimezone(tz);
        Object[] cases = new String[]{"2017-01-01 12:00:00 Z", "2014-01-02 16:00:00 Z", "2014-01-02 12:34:56 Z", "1970-01-01 00:00:00 Z", "1970-01-01 00:00:01 Z", "1969-12-31 11:59:59 Z", "0000-01-01 00:00:01 Z", "0001-12-31 11:59:59 Z"};
        long[] times = new long[]{1483272000000L, 1388678400000L, 1388666096000L, 0L, 1000L, -43201000L, -62167391999000L, -62104276801000L};
        String table = "test_arrow_ts_tz";
        String column = "(a timestamp_tz(" + scale + "))";
        String values = "('" + StringUtils.join((Object[])cases, (String)"'),('") + "'), (null)";
        try (Connection con = this.init(table, column, values, queryResultFormat);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                int i = 0;
                while (i < cases.length) {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((long)times[i++], (long)rs.getTimestamp(1).getTime());
                    Assertions.assertEquals((int)0, (int)rs.getTimestamp(1).getNanos());
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertNull((Object)rs.getString(1));
            }
            finally {
                statement.execute("drop table " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=ResultSetArrowForce0MultiTimeZone.DataProvider.class)
    public void testTimestampTZWithNanos(String queryResultFormat, String tz) throws SQLException {
        ResultSetArrowForceTZMultiTimeZoneIT.setTimezone(tz);
        Object[] cases = new String[]{"2017-01-01 12:00:00.1", "2014-01-02 16:00:00.123456789", "2014-01-02 12:34:56.999999999", "1969-12-31 23:59:59.000000001", "1970-01-01 00:00:00.000000001", "1970-01-01 00:00:01.0000001", "1969-12-31 11:59:59.134", "0001-12-31 11:59:59.234141", "0000-01-01 00:00:01.790870987"};
        long[] times = new long[]{1483272000100L, 1388678400123L, 1388666096999L, -1000L, 0L, 1000L, -43200866L, -62104276800766L, -62167391998210L};
        int[] nanos = new int[]{100000000, 123456789, 999999999, 1, 1, 100, 134000000, 234141000, 790870987};
        String table = "test_arrow_ts_tz";
        String column = "(a timestamp_tz)";
        String values = "('" + StringUtils.join((Object[])cases, (String)" Z'),('") + " Z'), (null)";
        try (Connection con = this.init(table, column, values, queryResultFormat);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                int i = 0;
                while (i < cases.length) {
                    Assertions.assertTrue((boolean)rs.next());
                    if (i == cases.length - 1 && tz.equalsIgnoreCase("utc")) {
                        Assertions.assertEquals((Object)"0001-01-01 00:00:01.790870987", (Object)rs.getTimestamp(1).toString());
                    }
                    Assertions.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
                    Assertions.assertEquals((int)nanos[i++], (int)rs.getTimestamp(1).getNanos());
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertNull((Object)rs.getString(1));
            }
            finally {
                statement.execute("drop table " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=ResultSetArrowForce0MultiTimeZone.DataProvider.class)
    public void testTimestampTZWithMicros(String queryResultFormat, String tz) throws SQLException {
        ResultSetArrowForceTZMultiTimeZoneIT.setTimezone(tz);
        Object[] cases = new String[]{"2017-01-01 12:00:00.1", "2014-01-02 16:00:00.123456", "2014-01-02 12:34:56.999999", "1969-12-31 23:59:59.000001", "1970-01-01 00:00:00.000001", "1970-01-01 00:00:01.00001", "1969-12-31 11:59:59.134", "0001-12-31 11:59:59.234141", "0000-01-01 00:00:01.79087"};
        long[] times = new long[]{1483272000100L, 1388678400123L, 1388666096999L, -1000L, 0L, 1000L, -43200866L, -62104276800766L, -62167391998210L};
        int[] nanos = new int[]{100000000, 123456000, 999999000, 1000, 1000, 10000, 134000000, 234141000, 790870000};
        String table = "test_arrow_ts_tz";
        String column = "(a timestamp_tz(6))";
        String values = "('" + StringUtils.join((Object[])cases, (String)" Z'),('") + " Z'), (null)";
        try (Connection con = this.init(table, column, values, queryResultFormat);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                int i = 0;
                while (i < cases.length) {
                    Assertions.assertTrue((boolean)rs.next());
                    if (i == cases.length - 1 && tz.equalsIgnoreCase("utc")) {
                        Assertions.assertEquals((Object)"0001-01-01 00:00:01.79087", (Object)rs.getTimestamp(1).toString());
                    }
                    Assertions.assertEquals((long)times[i], (long)rs.getTimestamp(1).getTime());
                    Assertions.assertEquals((int)nanos[i++], (int)rs.getTimestamp(1).getNanos());
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertNull((Object)rs.getString(1));
            }
            finally {
                statement.execute("drop table " + table);
            }
        }
    }
}

