/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import net.snowflake.client.TestUtil;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="resultSet")
public class ResultSetAsyncIT
extends BaseJDBCWithSharedConnectionIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncResultSetFunctionsWithNewSession() throws SQLException {
        Map<String, String> params = ResultSetAsyncIT.getConnectionParameters();
        String queryID = null;
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
                statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
                String createTableSql = "select * from test_rsmd";
                try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(createTableSql);){
                    queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                }
            }
            finally {
                statement.execute("drop table if exists test_rsmd");
            }
        }
        try (Connection connection = ResultSetAsyncIT.getConnection();
             ResultSet resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
            Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
            Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getTableName(1));
            Assertions.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
            Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
            Assertions.assertEquals((int)22, (int)resultSetMetaData.getColumnDisplaySize(1));
            Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
            Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
            Assertions.assertEquals((int)3, (int)resultSetMetaData.getColumnType(1));
            Assertions.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
            Assertions.assertEquals((int)20, (int)resultSetMetaData.getPrecision(1));
            Assertions.assertEquals((int)5, (int)resultSetMetaData.getScale(1));
            Assertions.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
            Assertions.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
            Assertions.assertFalse((boolean)resultSetMetaData.isCurrency(1));
            Assertions.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
            Assertions.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
            Assertions.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
            Assertions.assertTrue((boolean)resultSetMetaData.isSearchable(1));
            Assertions.assertTrue((boolean)resultSetMetaData.isSigned(1));
            SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
            List colNames = secretMetaData.getColumnNames();
            Assertions.assertEquals((Object)"COLA", colNames.get(0));
            Assertions.assertEquals((Object)"COLB", colNames.get(1));
            Assertions.assertEquals((int)3, (int)secretMetaData.getInternalColumnType(1));
            Assertions.assertEquals((int)12, (int)secretMetaData.getInternalColumnType(2));
            TestUtil.assertValidQueryId(secretMetaData.getQueryID());
            Assertions.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResultSetMetadata() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
                statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
                try (ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_rsmd");){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
                    Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
                    Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getTableName(1));
                    Assertions.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)22, (int)resultSetMetaData.getColumnDisplaySize(1));
                    Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
                    Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
                    Assertions.assertEquals((int)3, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
                    Assertions.assertEquals((int)20, (int)resultSetMetaData.getPrecision(1));
                    Assertions.assertEquals((int)5, (int)resultSetMetaData.getScale(1));
                    Assertions.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
                    Assertions.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
                    Assertions.assertFalse((boolean)resultSetMetaData.isCurrency(1));
                    Assertions.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
                    Assertions.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
                    Assertions.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
                    Assertions.assertTrue((boolean)resultSetMetaData.isSearchable(1));
                    Assertions.assertTrue((boolean)resultSetMetaData.isSigned(1));
                    SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
                    List colNames = secretMetaData.getColumnNames();
                    Assertions.assertEquals((Object)"COLA", colNames.get(0));
                    Assertions.assertEquals((Object)"COLB", colNames.get(1));
                    Assertions.assertEquals((int)3, (int)secretMetaData.getInternalColumnType(1));
                    Assertions.assertEquals((int)12, (int)secretMetaData.getInternalColumnType(2));
                    TestUtil.assertValidQueryId(secretMetaData.getQueryID());
                    Assertions.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
                }
            }
            finally {
                statement.execute("drop table if exists test_rsmd");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderAndClosureFunctions() throws SQLException {
        ResultSet resultSet;
        String queryID = null;
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
            statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
            try {
                resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_rsmd");
                Assertions.assertTrue((boolean)resultSet.isBeforeFirst(), (String)"should be before the first");
                Assertions.assertFalse((boolean)resultSet.isFirst(), (String)"should not be the first");
                resultSet.next();
                Assertions.assertFalse((boolean)resultSet.isBeforeFirst(), (String)"should not be before the first");
                Assertions.assertTrue((boolean)resultSet.isFirst(), (String)"should be the first");
                queryID = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
                Assertions.assertFalse((boolean)resultSet.isClosed());
                resultSet.close();
                Assertions.assertTrue((boolean)resultSet.isClosed());
            }
            finally {
                statement.execute("drop table if exists test_rsmd");
            }
        }
        try (Connection connection = ResultSetAsyncIT.getConnection();){
            resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);
            Assertions.assertFalse((boolean)resultSet.isClosed());
            resultSet.next();
            resultSet.next();
            Assertions.assertTrue((boolean)resultSet.isLast());
            resultSet.next();
            Assertions.assertTrue((boolean)resultSet.isAfterLast());
            resultSet.close();
            Assertions.assertTrue((boolean)resultSet.isClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWasNull() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                Clob emptyClob = connection.createClob();
                emptyClob.setString(1L, "");
                statement.execute("create or replace table test_null(colA number, colB string, colNull string, emptyClob string)");
                try (PreparedStatement prepst = connection.prepareStatement("insert into test_null values (?, ?, ?, ?)");){
                    prepst.setNull(1, 4);
                    prepst.setString(2, "hello");
                    prepst.setString(3, null);
                    prepst.setClob(4, emptyClob);
                    prepst.execute();
                    try (ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_null");){
                        resultSet.next();
                        resultSet.getInt(1);
                        Assertions.assertTrue((boolean)resultSet.wasNull());
                        resultSet.getString(2);
                        Assertions.assertFalse((boolean)resultSet.wasNull());
                        Assertions.assertNull((Object)resultSet.getClob(3));
                        Assertions.assertNull((Object)resultSet.getClob("COLNULL"));
                        Assertions.assertEquals((Object)"", (Object)resultSet.getClob("EMPTYCLOB").toString());
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMethods() throws Throwable {
        String prepInsertString = "insert into test_get values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        int bigInt = Integer.MAX_VALUE;
        long bigLong = Long.MAX_VALUE;
        short bigShort = Short.MAX_VALUE;
        String str = "hello";
        double bigDouble = Double.MAX_VALUE;
        float bigFloat = Float.MAX_VALUE;
        byte[] bytes = new byte[]{-85, -51, 18};
        BigDecimal bigDecimal = new BigDecimal("10000000000");
        byte oneByte = 1;
        Date date = new Date(44L);
        Time time = new Time(500L);
        Timestamp ts = new Timestamp(333L);
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_get(colA integer, colB number, colC number, colD string, colE double, colF float, colG boolean, colH text, colI binary(3), colJ number(38,9), colK int, colL date, colM time, colN timestamp_ltz)");
                try (PreparedStatement prepStatement = connection.prepareStatement(prepInsertString);){
                    prepStatement.setInt(1, bigInt);
                    prepStatement.setLong(2, bigLong);
                    prepStatement.setLong(3, bigShort);
                    prepStatement.setString(4, str);
                    prepStatement.setDouble(5, bigDouble);
                    prepStatement.setFloat(6, bigFloat);
                    prepStatement.setBoolean(7, true);
                    prepStatement.setClob(8, clob);
                    prepStatement.setBytes(9, bytes);
                    prepStatement.setBigDecimal(10, bigDecimal);
                    prepStatement.setByte(11, oneByte);
                    prepStatement.setDate(12, date);
                    prepStatement.setTime(13, time);
                    prepStatement.setTimestamp(14, ts);
                    prepStatement.execute();
                    try (ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from test_get");){
                        resultSet.next();
                        Assertions.assertEquals((int)bigInt, (int)resultSet.getInt(1));
                        Assertions.assertEquals((int)bigInt, (int)resultSet.getInt("COLA"));
                        Assertions.assertEquals((long)bigLong, (long)resultSet.getLong(2));
                        Assertions.assertEquals((long)bigLong, (long)resultSet.getLong("COLB"));
                        Assertions.assertEquals((short)bigShort, (short)resultSet.getShort(3));
                        Assertions.assertEquals((short)bigShort, (short)resultSet.getShort("COLC"));
                        Assertions.assertEquals((Object)str, (Object)resultSet.getString(4));
                        Assertions.assertEquals((Object)str, (Object)resultSet.getString("COLD"));
                        Reader reader = resultSet.getCharacterStream("COLD");
                        char[] sample = new char[str.length()];
                        Assertions.assertEquals((int)str.length(), (int)reader.read(sample));
                        Assertions.assertEquals((char)str.charAt(0), (char)sample[0]);
                        Assertions.assertEquals((Object)str, (Object)new String(sample));
                        Assertions.assertEquals((double)bigDouble, (double)resultSet.getDouble(5), (double)0.0);
                        Assertions.assertEquals((double)bigDouble, (double)resultSet.getDouble("COLE"), (double)0.0);
                        Assertions.assertEquals((float)bigFloat, (float)resultSet.getFloat(6), (float)0.0f);
                        Assertions.assertEquals((float)bigFloat, (float)resultSet.getFloat("COLF"), (float)0.0f);
                        Assertions.assertTrue((boolean)resultSet.getBoolean(7));
                        Assertions.assertTrue((boolean)resultSet.getBoolean("COLG"));
                        Assertions.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLH").toString());
                        DecimalFormat df = new DecimalFormat("#.00");
                        Assertions.assertEquals((Object)df.format(bigDecimal), (Object)df.format(resultSet.getBigDecimal(10)));
                        Assertions.assertEquals((Object)df.format(bigDecimal), (Object)df.format(resultSet.getBigDecimal("COLJ")));
                        Assertions.assertEquals((byte)oneByte, (byte)resultSet.getByte(11));
                        Assertions.assertEquals((byte)oneByte, (byte)resultSet.getByte("COLK"));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Assertions.assertEquals((Object)sdf.format(date), (Object)sdf.format(resultSet.getDate(12)));
                        Assertions.assertEquals((Object)sdf.format(date), (Object)sdf.format(resultSet.getDate("COLL")));
                        Assertions.assertEquals((Object)time, (Object)resultSet.getTime(13));
                        Assertions.assertEquals((Object)time, (Object)resultSet.getTime("COLM"));
                        Assertions.assertEquals((Object)ts, (Object)resultSet.getTimestamp(14));
                        Assertions.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLN"));
                        Assertions.assertEquals((Object)str, (Object)resultSet.getObject(4).toString());
                        Assertions.assertEquals((Object)str, (Object)resultSet.getObject("COLD").toString());
                        Assertions.assertEquals((Object)statement, (Object)resultSet.getStatement());
                    }
                }
            }
            finally {
                statement.execute("drop table if exists table_get");
            }
        }
    }

    @Test
    public void testEmptyResultSet() throws SQLException {
        try (Statement statement = connection.createStatement();
             ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery("select * from empty_table");){
            Assertions.assertFalse((boolean)rs.isClosed());
            Assertions.assertEquals((int)0, (int)rs.getInt(1));
            try {
                rs.getInt("col1");
                Assertions.fail((String)"Fetching from a column name that does not exist should return a SQLException");
            }
            catch (SQLException e) {
                Assertions.assertEquals((Object)"42703", (Object)e.getSQLState());
            }
        }
    }
}

