/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="resultSet")
public class ResultSetAsyncLatestIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncResultSet() throws SQLException {
        String queryID;
        try (Connection connection = ResultSetAsyncLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
                statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
                String createTableSql = "select * from test_rsmd";
                try (ResultSet rs = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(createTableSql);){
                    queryID = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                }
            }
            finally {
                statement.execute("drop table if exists test_rsmd");
            }
        }
        connection = ResultSetAsyncLatestIT.getConnection();
        try (ResultSet resultSet = connection.unwrap(SnowflakeConnection.class).createResultSet(queryID);){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
            Assertions.assertEquals((Object)secretMetaData.getQueryID(), (Object)resultSet.unwrap(SnowflakeResultSet.class).getQueryID());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

