/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetMultiTimeZoneIT
extends BaseJDBCTest {
    static TimeZone ogTz;

    @BeforeAll
    public static void setDefaultTimezone() {
        ogTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    private static void setTimezone(String timeZone) {
        System.setProperty("user.timezone", timeZone);
    }

    @AfterAll
    public static void clearTimezone() {
        TimeZone.setDefault(ogTz);
        System.clearProperty("user.timezone");
    }

    public Connection init(String queryResultFormat) throws SQLException {
        Connection connection = BaseJDBCTest.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
            statement.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
        return connection;
    }

    public Connection init() throws SQLException {
        Connection connection = BaseJDBCTest.getConnection();
        try (Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        }
        return connection;
    }

    @BeforeEach
    public void setUp() throws SQLException {
        try (Connection con = this.init();
             Statement statement = con.createStatement();){
            statement.execute("create or replace table test_rs (colA string)");
            statement.execute("insert into test_rs values('rowOne')");
            statement.execute("insert into test_rs values('rowTwo')");
            statement.execute("insert into test_rs values('rowThree')");
            statement.execute("create or replace table orders_jdbc(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
            Assertions.assertTrue((boolean)statement.execute("PUT file://" + ResultSetMultiTimeZoneIT.getFullPathFileInResource("orders_100.csv") + " @%orders_jdbc"), (String)"Failed to put a file");
            Assertions.assertTrue((boolean)statement.execute("PUT file://" + ResultSetMultiTimeZoneIT.getFullPathFileInResource("orders_101.csv") + " @%orders_jdbc"), (String)"Failed to put a file");
            int numRows = statement.executeUpdate("copy into orders_jdbc");
            Assertions.assertEquals((int)73, (int)numRows, (String)("Unexpected number of rows copied: " + numRows));
        }
    }

    @AfterEach
    public void tearDown() throws SQLException {
        System.clearProperty("user.timezone");
        try (Connection con = this.init();
             Statement statement = con.createStatement();){
            statement.execute("drop table if exists orders_jdbc");
            statement.execute("drop table if exists test_rs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testGetDateAndTime(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table dateTime(colA Date, colB Timestamp, colC Time)");
                java.util.Date today = new java.util.Date();
                Date date = ResultSetMultiTimeZoneIT.buildDate(2016, 3, 20);
                Timestamp ts = new Timestamp(today.getTime());
                Time tm = new Time(12345678L);
                String insertTime = "insert into datetime values(?, ?, ?)";
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into datetime values(?, ?, ?)");){
                    prepStatement.setDate(1, date);
                    prepStatement.setTimestamp(2, ts);
                    prepStatement.setTime(3, tm);
                    prepStatement.execute();
                    ResultSet resultSet = statement.executeQuery("select * from datetime");
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)date, (Object)resultSet.getDate(1));
                    Assertions.assertEquals((Object)date, (Object)resultSet.getDate("COLA"));
                    Assertions.assertEquals((Object)ts, (Object)resultSet.getTimestamp(2));
                    Assertions.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLB"));
                    Assertions.assertEquals((Object)tm, (Object)resultSet.getTime(3));
                    Assertions.assertEquals((Object)tm, (Object)resultSet.getTime("COLC"));
                }
                statement.execute("create or replace table datetime(colA timestamp_ltz, colB timestamp_ntz, colC timestamp_tz)");
                statement.execute("insert into dateTime values ('2019-01-01 17:17:17', '2019-01-01 17:17:17', '2019-01-01 17:17:17')");
                prepStatement = connection.prepareStatement("insert into datetime values(?, '2019-01-01 17:17:17', '2019-01-01 17:17:17')");
                try {
                    Timestamp dateTime = new Timestamp(date.getTime());
                    prepStatement.setTimestamp(1, dateTime);
                    prepStatement.execute();
                    try (ResultSet resultSet = statement.executeQuery("select * from datetime");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        formatter.setTimeZone(TimeZone.getDefault());
                        String d = formatter.format(resultSet.getDate("COLA"));
                        Assertions.assertEquals((Object)"2019-01-02 01:17:17", (Object)d);
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((Object)date, (Object)resultSet.getDate(1));
                        Assertions.assertEquals((Object)date, (Object)resultSet.getDate("COLA"));
                    }
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists datetime");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testTimeRange(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        String insertTime = "insert into timeTest values (?), (?), (?), (?)";
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table timeTest (c1 time)");
                long ms1 = -2202968667333L;
                long ms2 = -1L;
                long ms3 = 86400000L;
                long ms4 = 1451680250123L;
                Time tm1 = new Time(ms1);
                Time tm2 = new Time(ms2);
                Time tm3 = new Time(ms3);
                Time tm4 = new Time(ms4);
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into timeTest values (?), (?), (?), (?)");){
                    prepStatement.setTime(1, tm1);
                    prepStatement.setTime(2, tm2);
                    prepStatement.setTime(3, tm3);
                    prepStatement.setTime(4, tm4);
                    prepStatement.execute();
                }
                long M = 86400000L;
                try (ResultSet resultSet = statement.executeQuery("select * from timeTest");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNotEquals((Object)tm1, (Object)resultSet.getTime(1));
                    Assertions.assertEquals((Object)new Time((ms1 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNotEquals((Object)tm2, (Object)resultSet.getTime(1));
                    Assertions.assertEquals((Object)new Time((ms2 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNotEquals((Object)tm3, (Object)resultSet.getTime(1));
                    Assertions.assertEquals((Object)new Time((ms3 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertNotEquals((Object)tm4, (Object)resultSet.getTime(1));
                    Assertions.assertEquals((Object)new Time((ms4 % 86400000L + 86400000L) % 86400000L), (Object)resultSet.getTime(1));
                }
            }
            finally {
                statement.execute("drop table if exists timeTest");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testCurrentTime(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        String insertTime = "insert into datetime values (?, ?, ?)";
        try (Connection connection = this.init(queryResultFormat);){
            Assertions.assertFalse((boolean)connection.createStatement().execute("alter session set TIMEZONE='UTC'"));
            try (Statement statement = connection.createStatement();){
                try {
                    statement.execute("create or replace table datetime (d date, ts timestamp, tm time)");
                    try (PreparedStatement prepStatement = connection.prepareStatement("insert into datetime values (?, ?, ?)");){
                        long currentMillis = System.currentTimeMillis();
                        Date currentDate = new Date(currentMillis);
                        Timestamp currentTS = new Timestamp(currentMillis);
                        Time currentTime = new Time(currentMillis);
                        prepStatement.setDate(1, currentDate);
                        prepStatement.setTimestamp(2, currentTS);
                        prepStatement.setTime(3, currentTime);
                        prepStatement.execute();
                        try (ResultSet resultSet = statement.executeQuery("select ts::date = d from datetime");){
                            Assertions.assertTrue((boolean)resultSet.next());
                            Assertions.assertTrue((boolean)resultSet.getBoolean(1));
                        }
                        resultSet = statement.executeQuery("select ts::time = tm from datetime");
                        try {
                            Assertions.assertTrue((boolean)resultSet.next());
                            Assertions.assertTrue((boolean)resultSet.getBoolean(1));
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                }
                finally {
                    statement.execute("drop table if exists datetime");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testBindTimestampTZ(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table testBindTimestampTZ(cola int, colb timestamp_tz)");
                long millSeconds = System.currentTimeMillis();
                Timestamp ts = new Timestamp(millSeconds);
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into testBindTimestampTZ values (?, ?)");){
                    prepStatement.setInt(1, 123);
                    prepStatement.setTimestamp(2, ts, Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    prepStatement.execute();
                }
                try (ResultSet resultSet = statement.executeQuery("select cola, colb from testBindTimestampTz");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((String)"integer", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)123));
                    MatcherAssert.assertThat((String)"timestamp_tz", (Object)resultSet.getTimestamp(2), (Matcher)CoreMatchers.equalTo((Object)ts));
                }
            }
            finally {
                statement.execute("drop table if exists testBindTimestampTZ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testGetOldDate(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table testOldDate(d date)");
                statement.execute("insert into testOldDate values ('0001-01-01'), (to_date('1000-01-01')), ('1300-01-01'), ('1400-02-02'), ('1500-01-01'), ('1600-02-03')");
                try (ResultSet resultSet = statement.executeQuery("select * from testOldDate order by d");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"0001-01-01", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("0001-01-01"), (Object)resultSet.getDate(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"1000-01-01", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("1000-01-01"), (Object)resultSet.getDate(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"1300-01-01", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("1300-01-01"), (Object)resultSet.getDate(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"1400-02-02", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("1400-02-02"), (Object)resultSet.getDate(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"1500-01-01", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("1500-01-01"), (Object)resultSet.getDate(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"1600-02-03", (Object)resultSet.getString(1));
                    Assertions.assertEquals((Object)Date.valueOf("1600-02-03"), (Object)resultSet.getDate(1));
                }
            }
            finally {
                statement.execute("drop table if exists testOldDate");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void testGetStringForDates(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            String expectedDate1 = "2020-08-01";
            String expectedDate2 = "1920-11-11";
            try (ResultSet rs = statement.executeQuery("SELECT '" + expectedDate1 + "'::DATE as D1");){
                rs.next();
                Assertions.assertEquals((Object)expectedDate1, (Object)rs.getString(1));
            }
            rs = statement.executeQuery("SELECT '" + expectedDate2 + "'::DATE as D1");
            try {
                rs.next();
                Assertions.assertEquals((Object)expectedDate2, (Object)rs.getString(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testDateTimeRelatedTypeConversion(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table testDateTime(colDate DATE, colTS timestamp_ltz, colTime TIME, colString string)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testDateTime values(?, ?, ?, ?)");){
                    Timestamp ts = ResultSetMultiTimeZoneIT.buildTimestamp(2016, 3, 20, 3, 25, 45, 67800000);
                    Date date = ResultSetMultiTimeZoneIT.buildDate(2016, 3, 20);
                    Time time = new Time(12345678L);
                    preparedStatement.setDate(1, date);
                    preparedStatement.setTimestamp(2, ts);
                    preparedStatement.setTime(3, time);
                    preparedStatement.setString(4, "aaa");
                    preparedStatement.execute();
                    try (ResultSet resultSet = statement.executeQuery("select * from testDateTime");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((Object)date, (Object)resultSet.getDate("COLDATE"));
                        try {
                            resultSet.getDate("COLTIME");
                            Assertions.fail();
                        }
                        catch (SnowflakeSQLException e) {
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)e.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
                        }
                        Assertions.assertEquals((Object)new Timestamp(date.getTime()), (Object)resultSet.getTimestamp("COLDATE"));
                        Assertions.assertEquals((Object)ts, (Object)resultSet.getTimestamp("COLTS"));
                        Assertions.assertEquals((Object)new Timestamp(time.getTime()), (Object)resultSet.getTimestamp("COLTIME"));
                        try {
                            resultSet.getTimestamp("COLSTRING");
                            Assertions.fail();
                        }
                        catch (SnowflakeSQLException e) {
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)e.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
                        }
                        try {
                            resultSet.getTime("COLDATE");
                            Assertions.fail();
                        }
                        catch (SnowflakeSQLException e) {
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)e.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)e.getSQLState());
                        }
                        Assertions.assertEquals((Object)time, (Object)resultSet.getTime("COLTIME"));
                        Assertions.assertEquals((Object)new Time(ts.getTime()), (Object)resultSet.getTime("COLTS"));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists testDateTime");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testGetOldTimestamp(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table testOldTs(cola timestamp_ntz)");
                statement.execute("insert into testOldTs values ('1582-06-22 17:00:00'), ('1000-01-01 17:00:00')");
                try (ResultSet resultSet = statement.executeQuery("select * from testOldTs");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"1582-06-22 17:00:00.0"));
                    MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"Fri, 22 Jun 1582 17:00:00 Z"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"1000-01-01 17:00:00.0"));
                    MatcherAssert.assertThat((Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"Mon, 01 Jan 1000 17:00:00 Z"));
                }
            }
            finally {
                statement.execute("drop table if exists testOldTs");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testPrepareOldTimestamp(String tz, String queryResultFormat) throws SQLException {
        ResultSetMultiTimeZoneIT.setTimezone(tz);
        TimeZone origTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table testPrepOldTs(cola timestamp_ntz, colb date)");
                statement.execute("alter session set client_timestamp_type_mapping=timestamp_ntz");
                PreparedStatement ps = con.prepareStatement("insert into testPrepOldTs values (?, ?)");
                ps.setTimestamp(1, Timestamp.valueOf("0001-01-01 08:00:00"));
                ps.setDate(2, Date.valueOf("0001-01-01"));
                ps.executeUpdate();
                ResultSet resultSet = statement.executeQuery("select * from testPrepOldTs");
                Assertions.assertTrue((boolean)resultSet.next());
                MatcherAssert.assertThat((Object)resultSet.getTimestamp(1).toString(), (Matcher)CoreMatchers.equalTo((Object)"0001-01-01 08:00:00.0"));
                MatcherAssert.assertThat((Object)resultSet.getDate(2).toString(), (Matcher)CoreMatchers.equalTo((Object)"0001-01-01"));
            }
            finally {
                statement.execute("drop table if exists testPrepOldTs");
                TimeZone.setDefault(origTz);
            }
        }
    }

    static class DataProvider
    implements ArgumentsProvider {
        DataProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            ArrayList<String> timezones = new ArrayList<String>(){
                {
                    this.add("UTC");
                    this.add("Asia/Singapore");
                    this.add("CET");
                }
            };
            ArrayList<String> queryFormats = new ArrayList<String>(){
                {
                    this.add("json");
                    this.add("arrow");
                }
            };
            ArrayList<Arguments.ArgumentSet> args = new ArrayList<Arguments.ArgumentSet>();
            for (String timeZone : timezones) {
                for (String queryFormat : queryFormats) {
                    args.add(Arguments.argumentSet((String)(timeZone + " " + queryFormat), (Object[])new Object[]{timeZone, queryFormat}));
                }
            }
            return args.stream();
        }
    }
}

