/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.providers.BooleanProvider;
import net.snowflake.client.providers.ProvidersUtil;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import net.snowflake.client.providers.SnowflakeArgumentsProvider;
import net.snowflake.client.providers.TimezoneProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetMultiTimeZoneLatestIT
extends BaseJDBCWithSharedConnectionIT {
    private static String originalTz;

    @BeforeAll
    public static void saveTimezone() {
        originalTz = System.getProperty("user.timezone");
    }

    @AfterAll
    public static void restoreTimezone() {
        if (originalTz != null) {
            System.setProperty("user.timezone", originalTz);
        } else {
            System.clearProperty("user.timezone");
        }
    }

    private static void setTimezone(String tz) {
        System.setProperty("user.timezone", tz);
    }

    public void init(String queryResultFormat, String tz) throws SQLException {
        ResultSetMultiTimeZoneLatestIT.setTimezone(tz);
        try (Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
            statement.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void testTimesWithGetTimestamp(String queryResultFormat, String tz) throws SQLException {
        this.init(queryResultFormat, tz);
        try (Statement statement = this.createStatement(queryResultFormat);){
            String timeStringValue = "10:30:50.123456789";
            String timestampStringValue = "1970-01-01 " + timeStringValue;
            int length = timestampStringValue.length();
            statement.execute("create or replace table SRC_DATE_TIME (C2_TIME_3 TIME(3), C3_TIME_5 TIME(5), C4_TIME TIME(9))");
            statement.execute("insert into SRC_DATE_TIME values ('" + timeStringValue + "','" + timeStringValue + "','" + timeStringValue + "')");
            try (ResultSet rs = statement.executeQuery("select * from SRC_DATE_TIME");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)timestampStringValue.substring(0, length - 6), (Object)rs.getTimestamp(1).toString());
                Assertions.assertEquals((Object)timestampStringValue.substring(0, length - 4), (Object)rs.getTimestamp(2).toString());
                Assertions.assertEquals((Object)timestampStringValue, (Object)rs.getTimestamp(3).toString());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void testTimestampNTZWithDaylightSavings(String queryResultFormat, String tz) throws SQLException {
        this.init(queryResultFormat, tz);
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("alter session set TIMESTAMP_TYPE_MAPPING='TIMESTAMP_NTZ',TIMEZONE='Europe/London'");
            try (ResultSet rs = statement.executeQuery("select TIMESTAMP '2011-09-04 00:00:00'");){
                Assertions.assertTrue((boolean)rs.next());
                Timestamp expected = Timestamp.valueOf("2011-09-04 00:00:00");
                Assertions.assertEquals((Object)expected, (Object)rs.getTimestamp(1));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnGithubActions
    public void testDateAndTimestampWithTimezone(String queryResultFormat, String tz) throws SQLException {
        this.init(queryResultFormat, tz);
        Calendar cal = null;
        SimpleDateFormat sdf = null;
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=true");
            try (ResultSet rs = statement.executeQuery("SELECT DATE '1970-01-02 00:00:00' as datefield, TIMESTAMP '1970-01-02 00:00:00' as timestampfield");){
                Assertions.assertTrue((boolean)rs.next());
                cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setTimeZone(cal.getTimeZone());
                Date dateWithZone = rs.getDate(1, cal);
                Timestamp timestampWithZone = rs.getTimestamp(2, cal);
                Assertions.assertEquals((Object)sdf.format(dateWithZone), (Object)sdf.format(timestampWithZone));
                Assertions.assertEquals((Object)rs.getTimestamp(1, cal), (Object)rs.getTimestamp(2, cal));
                Assertions.assertEquals((Object)rs.getDate(1, cal), (Object)rs.getDate(2, cal));
                Assertions.assertEquals((Object)"1970-01-02 00:00:00", (Object)sdf.format(rs.getDate(1)));
                Assertions.assertEquals((Object)"1970-01-02 08:00:00", (Object)sdf.format(rs.getDate(2)));
                Assertions.assertEquals((Object)"1970-01-02 08:00:00", (Object)sdf.format(rs.getTimestamp(2)));
                Assertions.assertEquals((Object)"1970-01-02 00:00:00", (Object)sdf.format(rs.getTimestamp(1)));
            }
            statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=false");
            rs = statement.executeQuery("SELECT DATE '1945-05-10 00:00:00' as datefield");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)rs.getDate(1, cal), (Object)rs.getDate(1));
                Assertions.assertEquals((Object)"1945-05-10 00:00:00", (Object)sdf.format(rs.getDate(1, cal)));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DataWithFlagProvider.class)
    public void testUseSessionTimeZoneHelper(String queryResultFormat, String tz, boolean useDefaultParamSettings) throws SQLException {
        this.init(queryResultFormat, tz);
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table datetimetypes(colA timestamp_ltz, colB timestamp_ntz, colC timestamp_tz, colD time, colE date)");
                statement.execute("alter session set JDBC_USE_SESSION_TIMEZONE=true");
                if (!useDefaultParamSettings) {
                    statement.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
                    statement.execute("alter session set CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ=false");
                    statement.execute("alter session set JDBC_FORMAT_DATE_WITH_TIMEZONE=true");
                }
                String expectedTimestamp = "2019-01-01 17:17:17.6";
                String expectedTime = "17:17:17";
                String expectedDate = "2019-01-01";
                String expectedTimestamp2 = "1943-12-31 01:01:33.0";
                String expectedTime2 = "01:01:33";
                String expectedDate2 = "1943-12-31";
                try (PreparedStatement prepSt = connection.prepareStatement("insert into datetimetypes values(?, ?, ?, ?, ?)");){
                    prepSt.setString(1, expectedTimestamp);
                    prepSt.setString(2, expectedTimestamp);
                    prepSt.setString(3, expectedTimestamp);
                    prepSt.setString(4, expectedTime);
                    prepSt.setString(5, expectedDate);
                    prepSt.execute();
                    prepSt.setString(1, expectedTimestamp2);
                    prepSt.setString(2, expectedTimestamp2);
                    prepSt.setString(3, expectedTimestamp2);
                    prepSt.setString(4, expectedTime2);
                    prepSt.setString(5, expectedDate2);
                    prepSt.execute();
                }
                try (ResultSet rs = statement.executeQuery("select * from datetimetypes");){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)expectedDate, (Object)rs.getDate("COLA").toString());
                    Assertions.assertEquals((Object)expectedDate, (Object)rs.getDate("COLB").toString());
                    Assertions.assertEquals((Object)expectedDate, (Object)rs.getDate("COLC").toString());
                    Assertions.assertEquals((Object)expectedDate, (Object)rs.getDate("COLE").toString());
                    Assertions.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLA").toString());
                    Assertions.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLB").toString());
                    Assertions.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLC").toString());
                    Assertions.assertEquals((Object)"1970-01-01 17:17:17.0", (Object)rs.getTimestamp("COLD").toString());
                    Assertions.assertEquals((Object)"2019-01-01 00:00:00.0", (Object)rs.getTimestamp("COLE").toString());
                    Assertions.assertEquals((Object)expectedTime, (Object)rs.getTime("COLA").toString());
                    Assertions.assertEquals((Object)expectedTime, (Object)rs.getTime("COLB").toString());
                    Assertions.assertEquals((Object)expectedTime, (Object)rs.getTime("COLC").toString());
                    Assertions.assertEquals((Object)expectedTime, (Object)rs.getTime("COLD").toString());
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLA").toString());
                    Assertions.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLB").toString());
                    Assertions.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLC").toString());
                    Assertions.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLE").toString());
                    Assertions.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLA").toString());
                    Assertions.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLB").toString());
                    Assertions.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLC").toString());
                    Assertions.assertEquals((Object)"1970-01-01 01:01:33.0", (Object)rs.getTimestamp("COLD").toString());
                    Assertions.assertEquals((Object)"1943-12-31 00:00:00.0", (Object)rs.getTimestamp("COLE").toString());
                    Assertions.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLA").toString());
                    Assertions.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLB").toString());
                    Assertions.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLC").toString());
                    Assertions.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLD").toString());
                }
                statement.execute("create or replace table tabletz (colA timestamp_tz)");
                prepSt = connection.prepareStatement("insert into tabletz values(?), (?)");
                try {
                    prepSt.setString(1, expectedTimestamp + " +0500");
                    prepSt.setString(2, expectedTimestamp2 + " -0200");
                    prepSt.execute();
                    try (ResultSet rs = statement.executeQuery("select * from tabletz");){
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)expectedTimestamp, (Object)rs.getTimestamp("COLA").toString());
                        Assertions.assertEquals((Object)expectedTime, (Object)rs.getTime("COLA").toString());
                        Assertions.assertEquals((Object)expectedDate, (Object)rs.getDate("COLA").toString());
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)expectedTimestamp2, (Object)rs.getTimestamp("COLA").toString());
                        Assertions.assertEquals((Object)expectedTime2, (Object)rs.getTime("COLA").toString());
                        Assertions.assertEquals((Object)expectedDate2, (Object)rs.getDate("COLA").toString());
                    }
                }
                finally {
                    if (prepSt != null) {
                        prepSt.close();
                    }
                }
            }
            finally {
                statement.execute("alter session unset JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC");
                statement.execute("alter session unset CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
                statement.execute("alter session unset JDBC_FORMAT_DATE_WITH_TIMEZONE");
                statement.execute("alter session unset JDBC_USE_SESSION_TIMEZONE");
            }
        }
    }

    private static class DataWithFlagProvider
    extends SnowflakeArgumentsProvider {
        private DataWithFlagProvider() {
        }

        @Override
        protected List<Arguments> rawArguments(ExtensionContext context) {
            return ProvidersUtil.cartesianProduct(context, new DataProvider(), new BooleanProvider());
        }
    }

    private static class DataProvider
    extends SnowflakeArgumentsProvider {
        private DataProvider() {
        }

        @Override
        protected List<Arguments> rawArguments(ExtensionContext context) {
            return ProvidersUtil.cartesianProduct(context, new SimpleResultFormatProvider(), new TimezoneProvider(4));
        }
    }
}

