/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.ResultSet0IT;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaDataV1;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetVectorLatestIT
extends ResultSet0IT {
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetIntVectorAsIntArray(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            Object[] vector = new Integer[]{-1, 5};
            try (ResultSet resultSet = stmt.executeQuery("select " + this.vectorToString((Number[])vector, "int"));){
                Assertions.assertTrue((boolean)resultSet.next());
                Object[] result = (Integer[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Integer.class);
                Assertions.assertArrayEquals((Object[])vector, (Object[])result);
                this.assertVectorMetadata(resultSet, 1, 4, 1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetIntVectorAsLongArray(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            Object[] vector = new Long[]{-1L, 5L};
            try (ResultSet resultSet = stmt.executeQuery("select " + this.vectorToString((Number[])vector, "int"));){
                Assertions.assertTrue((boolean)resultSet.next());
                Object[] result = (Long[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Long.class);
                Assertions.assertArrayEquals((Object[])vector, (Object[])result);
                this.assertVectorMetadata(resultSet, 1, 4, 1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetFloatVectorAsFloatArray(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            Object[] vector = new Float[]{Float.valueOf(-1.2f), Float.valueOf(5.1f), Float.valueOf(15.87f)};
            try (ResultSet resultSet = stmt.executeQuery("select " + this.vectorToString((Number[])vector, "float"));){
                Assertions.assertTrue((boolean)resultSet.next());
                Object[] result = (Float[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Float.class);
                Assertions.assertArrayEquals((Object[])vector, (Object[])result);
                this.assertVectorMetadata(resultSet, 1, 6, 1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetNullAsIntVector(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            try (ResultSet resultSet = stmt.executeQuery("select null::vector(int, 2)");){
                Assertions.assertTrue((boolean)resultSet.next());
                Integer[] result = (Integer[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Integer.class);
                Assertions.assertNull((Object)result);
                this.assertVectorMetadata(resultSet, 1, 4, 1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetNullAsFloatVector(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            try (ResultSet resultSet = stmt.executeQuery("select null::vector(float, 2)");){
                Assertions.assertTrue((boolean)resultSet.next());
                Integer[] result = (Integer[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Integer.class);
                Assertions.assertNull((Object)result);
                this.assertVectorMetadata(resultSet, 1, 6, 1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetIntVectorFromTable(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            stmt.execute("create or replace table test_vector_int(x vector(int, 2), y int)");
            stmt.execute("insert into test_vector_int select [3, 7]::vector(int, 2), 15");
            try (ResultSet resultSet = stmt.executeQuery("select x, y from test_vector_int");){
                Assertions.assertTrue((boolean)resultSet.next());
                Object[] result = (Integer[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Integer.class);
                Assertions.assertArrayEquals((Object[])new Integer[]{3, 7}, (Object[])result);
                this.assertVectorMetadata(resultSet, 1, 4, 2);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetFloatVectorFromTable(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            stmt.execute("create or replace table test_vector_float(x vector(float, 2), y float)");
            stmt.execute("insert into test_vector_float select [-3, 7.1]::vector(float, 2), 20.3");
            try (ResultSet resultSet = stmt.executeQuery("select x, y from test_vector_float");){
                Assertions.assertTrue((boolean)resultSet.next());
                Object[] result = (Float[])resultSet.unwrap(SnowflakeBaseResultSet.class).getArray(1, Float.class);
                Assertions.assertArrayEquals((Object[])new Float[]{Float.valueOf(-3.0f), Float.valueOf(7.1f)}, (Object[])result);
                this.assertVectorMetadata(resultSet, 1, 6, 2);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetVectorViaGetStringIsEqualToTheGetObject(String queryResultFormat) throws SQLException {
        try (Statement stmt = this.createStatement(queryResultFormat);){
            this.enforceQueryResultFormat(stmt, queryResultFormat);
            Number[] intVector = new Integer[]{-1, 5};
            Number[] floatVector = new Float[]{Float.valueOf(-1.2f), Float.valueOf(5.1f), Float.valueOf(15.87f)};
            try (ResultSet resultSet = stmt.executeQuery("select " + this.vectorToString(intVector, "int") + ", " + this.vectorToString(floatVector, "float") + ", " + this.nullVectorToString("int") + ", " + this.nullVectorToString("float"));){
                Assertions.assertTrue((boolean)resultSet.next());
                ResultSetVectorLatestIT.assertGetObjectAndGetStringBeTheSame(resultSet, "[-1,5]", 1);
                String floatArrayRepresentation = "json".equalsIgnoreCase(queryResultFormat) ? "[-1.200000,5.100000,15.870000]" : "[-1.2,5.1,15.87]";
                ResultSetVectorLatestIT.assertGetObjectAndGetStringBeTheSame(resultSet, floatArrayRepresentation, 2);
                ResultSetVectorLatestIT.assertGetObjectAndGetStringAreNull(resultSet, 3);
                ResultSetVectorLatestIT.assertGetObjectAndGetStringAreNull(resultSet, 4);
            }
        }
    }

    private static void assertGetObjectAndGetStringBeTheSame(ResultSet resultSet, String intArrayRepresentation, int columnIndex) throws SQLException {
        Assertions.assertEquals((Object)intArrayRepresentation, (Object)resultSet.getString(columnIndex));
        Assertions.assertEquals((Object)intArrayRepresentation, (Object)resultSet.getObject(columnIndex));
    }

    private static void assertGetObjectAndGetStringAreNull(ResultSet resultSet, int columnIndex) throws SQLException {
        Assertions.assertNull((Object)resultSet.getString(columnIndex));
        Assertions.assertNull((Object)resultSet.getObject(columnIndex));
    }

    private <T extends Number> String vectorToString(T[] vector, String vectorType) {
        return Arrays.toString(vector) + "::vector(" + vectorType + ", " + vector.length + ")";
    }

    private <T extends Number> String nullVectorToString(String vectorType) {
        return "null::vector(" + vectorType + ", 2)";
    }

    private void enforceQueryResultFormat(Statement stmt, String queryResultFormat) throws SQLException {
        String sql = String.format("alter session set jdbc_query_result_format = '%s'", queryResultFormat.toUpperCase());
        stmt.execute(sql);
    }

    private void assertVectorMetadata(ResultSet resultSet, int vectorColumnIndex, int expectedVectorFieldType, int allColumns) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        Assertions.assertEquals((int)allColumns, (int)metadata.getColumnCount());
        Assertions.assertEquals((int)50003, (int)metadata.getColumnType(vectorColumnIndex));
        Assertions.assertEquals((Object)"VECTOR", (Object)metadata.getColumnTypeName(vectorColumnIndex));
        SnowflakeResultSetMetaDataV1 sfMetadata = (SnowflakeResultSetMetaDataV1)metadata;
        Assertions.assertTrue((boolean)sfMetadata.isStructuredTypeColumn(vectorColumnIndex));
        Assertions.assertEquals((int)50003, (int)sfMetadata.getInternalColumnType(vectorColumnIndex));
        List columnFields = sfMetadata.getColumnFields(vectorColumnIndex);
        Assertions.assertEquals((int)1, (int)columnFields.size());
        Assertions.assertEquals((int)expectedVectorFieldType, (int)((FieldMetadata)columnFields.get(0)).getType());
    }
}

