/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SessionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionUtilTest {
    @Test
    public void testGetCommonParams() throws Exception {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        Map result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": true}]"));
        Assertions.assertTrue((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": false}]"));
        Assertions.assertFalse((boolean)((Boolean)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 0}]"));
        Assertions.assertEquals((int)0, (int)((Integer)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": 1000}]"));
        Assertions.assertEquals((int)1000, (int)((Integer)result.get("testParam")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"\"}]"));
        Assertions.assertEquals((Object)"", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"testParam\", \"value\": \"value\"}]"));
        Assertions.assertEquals((Object)"value", result.get("testParam"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": true}]"));
        Assertions.assertTrue((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_DISABLE_INCIDENTS\", \"value\": false}]"));
        Assertions.assertFalse((boolean)((Boolean)result.get("CLIENT_DISABLE_INCIDENTS")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 0}]"));
        Assertions.assertEquals((int)0, (int)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"CLIENT_STAGE_ARRAY_BINDING_THRESHOLD\", \"value\": 1000}]"));
        Assertions.assertEquals((int)1000, (int)((Integer)result.get("CLIENT_STAGE_ARRAY_BINDING_THRESHOLD")));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"\"}]"));
        Assertions.assertEquals((Object)"", result.get("TIMEZONE"));
        result = SessionUtil.getCommonParams((JsonNode)mapper.readTree("[{\"name\": \"TIMEZONE\", \"value\": \"value\"}]"));
        Assertions.assertEquals((Object)"value", result.get("TIMEZONE"));
    }
}

