/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public final class SessionVariablesIT
extends AbstractDriverIT {
    @Test
    public void testSettingSessionVariablesInConnectionProperties() throws SQLException {
        Properties properties = new Properties();
        properties.put("$var1", "some example 1");
        properties.put("$var2", "2");
        properties.put("var3", "some example 3");
        try (Connection con = SessionVariablesIT.getConnection(properties);
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("show variables");){
            HashMap<String, String> variablesInSession = new HashMap<String, String>();
            while (resultSet.next()) {
                variablesInSession.put(resultSet.getString("name"), resultSet.getString("value"));
            }
            Assertions.assertEquals((Object)"some example 1", variablesInSession.get("VAR1"));
            Assertions.assertEquals((Object)"2", variablesInSession.get("VAR2"));
            Assertions.assertNull(variablesInSession.get("VAR3"));
        }
    }
}

