/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Tag(value="core")
public class SnowflakeChunkDownloaderLatestIT
extends BaseJDBCTest {
    private static String originalProxyHost;
    private static String originalProxyPort;
    private static String originalNonProxyHosts;

    @BeforeAll
    public static void setUp() throws Exception {
        originalProxyHost = System.getProperty("https.proxyHost");
        originalProxyPort = System.getProperty("https.proxyPort");
        originalNonProxyHosts = System.getProperty("https.nonProxyHosts");
    }

    private static void restoreProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }

    @AfterAll
    public static void tearDown() throws Exception {
        SnowflakeChunkDownloaderLatestIT.restoreProperty("https.proxyHost", originalProxyHost);
        SnowflakeChunkDownloaderLatestIT.restoreProperty("https.proxyPort", originalProxyPort);
        SnowflakeChunkDownloaderLatestIT.restoreProperty("https.nonProxyHosts", originalNonProxyHosts);
    }

    @Test
    public void testChunkDownloaderRetry() throws SQLException, InterruptedException {
        System.setProperty("https.proxyHost", "127.0.0.1");
        System.setProperty("https.proxyPort", "8080");
        System.setProperty("http.nonProxyHosts", "*snowflakecomputing.com");
        Properties properties = new Properties();
        properties.put("maxHttpRetries", (Object)2);
        SnowflakeChunkDownloader snowflakeChunkDownloaderSpy = null;
        try (Connection connection = SnowflakeChunkDownloaderLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");){
            List resultSetSerializables = ((SnowflakeResultSet)resultSet).getResultSetSerializables(0x6400000L);
            SnowflakeResultSetSerializable resultSetSerializable = (SnowflakeResultSetSerializable)resultSetSerializables.get(0);
            SnowflakeChunkDownloader downloader = new SnowflakeChunkDownloader((SnowflakeResultSetSerializableV1)resultSetSerializable);
            snowflakeChunkDownloaderSpy = (SnowflakeChunkDownloader)Mockito.spy((Object)downloader);
            snowflakeChunkDownloaderSpy.getNextChunkToConsume();
        }
        catch (SnowflakeSQLException exception) {
            ((SnowflakeChunkDownloader)Mockito.verify(snowflakeChunkDownloaderSpy, (VerificationMode)Mockito.times((int)2))).getResultStreamProvider();
            Assertions.assertTrue((boolean)exception.getMessage().contains("Max retry reached for the download of chunk#0"));
            Assertions.assertTrue((boolean)exception.getMessage().contains("retry: 2"));
        }
    }
}

