/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.AbstractDriverIT;
import org.junit.jupiter.api.Assertions;

public class SnowflakeDriverConnectionStressTest {
    private static final String QUERY = "select current_user()";

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        int run_millis = 120000;
        int dop = 6;
        int queries_per_connection = 50;
        SnowflakeDriverConnectionStressTest.doTest(120000, 6, 50);
    }

    private static void doTest(int run_millis, int dop, final int num_queries) throws InterruptedException, ExecutionException {
        SnowflakeDriverConnectionStressTest.doConnectWithQuery(1);
        ExecutorService executorService = Executors.newFixedThreadPool(dop);
        final AtomicBoolean running = new AtomicBoolean(true);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (running.get()) {
                    SnowflakeDriverConnectionStressTest.doConnectWithQuery(num_queries);
                }
            }
        };
        ArrayList futures = new ArrayList(dop);
        for (int i = 0; i < dop; ++i) {
            Future<?> future = executorService.submit(r);
            futures.add(future);
        }
        Thread.sleep(run_millis);
        running.set(false);
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdownNow();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
    }

    private static void doConnectWithQuery(int num_queries) {
        try {
            long before = System.currentTimeMillis();
            SnowflakeDriverConnectionStressTest.connectAndQuery(num_queries);
            long diff = System.currentTimeMillis() - before;
            SnowflakeDriverConnectionStressTest.say("connect_with_queries_millis=" + diff);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void connectAndQuery(int num_queries) throws SQLException {
        try (Connection connection = AbstractDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            for (int i = 0; i < num_queries; ++i) {
                try (ResultSet resultSet = statement.executeQuery(QUERY);){
                    while (resultSet.next()) {
                        String user = resultSet.getString(1);
                        Assertions.assertNotNull((Object)user);
                    }
                    continue;
                }
            }
        }
    }

    protected static void say(String arg) {
        System.out.println(System.currentTimeMillis() + ":" + Thread.currentThread().getId() + " " + arg);
    }
}

