/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.storage.StorageException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.annotations.DontRunOnTestaccount;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeDriverIT;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageClientFactory;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="others")
public class SnowflakeDriverLatestIT
extends BaseJDBCTest {
    @TempDir
    private File tmpFolder;
    @TempDir
    private File tmpFolder2;
    public String testStageName = String.format("test_stage_%s", UUID.randomUUID().toString()).replaceAll("-", "_");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileContentEqual(String fileFullPath1, boolean compressedFile1, String fileFullPath2, boolean compressedFile2) throws Throwable {
        InputStream inputStream1 = new FileInputStream(fileFullPath1);
        InputStream inputStream2 = new FileInputStream(fileFullPath2);
        try {
            if (compressedFile1) {
                inputStream1 = new GZIPInputStream(inputStream1);
            }
            if (compressedFile2) {
                inputStream2 = new GZIPInputStream(inputStream2);
            }
            boolean bl = Arrays.equals(IOUtils.toByteArray((InputStream)inputStream1), IOUtils.toByteArray((InputStream)inputStream2));
            return bl;
        }
        finally {
            inputStream1.close();
            inputStream2.close();
        }
    }

    @Test
    public void testStaticVersionMatchesManifest() {
        Assertions.assertEquals((Object)SnowflakeDriver.implementVersion, (Object)SnowflakeDriver.getClientVersionStringFromManifest().replace("-SNAPSHOT", ""));
    }

    @Test
    @DontRunOnTestaccount
    public void testClientInfoConnectionProperty() throws Throwable {
        ResultSet res;
        Statement statement;
        String clientInfoJSONStr = null;
        JsonNode clientInfoJSON = null;
        Properties props = new Properties();
        props.put("snowflakeClientInfo", "{\"spark.version\":\"3.0.0\", \"spark.snowflakedb.version\":\"2.8.5\", \"spark.app.name\":\"SnowflakeSourceSuite\", \"scala.version\":\"2.12.11\", \"java.version\":\"1.8.0_221\", \"snowflakedb.jdbc.version\":\"3.13.2\"}");
        try (Connection connection = SnowflakeDriverLatestIT.getConnection(0, props, false, false);){
            statement = connection.createStatement();
            try {
                res = statement.executeQuery("select current_session_client_info()");
                try {
                    Assertions.assertTrue((boolean)res.next());
                    clientInfoJSONStr = res.getString(1);
                    clientInfoJSON = SnowflakeResultSetSerializableV1.mapper.readTree(clientInfoJSONStr);
                    Assertions.assertEquals((Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText(), (String)"spark version mismatch");
                    Assertions.assertEquals((Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText(), (String)"spark app mismatch");
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        System.setProperty("snowflake.client.info", "{\"spark.version\":\"fake\", \"spark.snowflakedb.version\":\"fake\", \"spark.app.name\":\"fake\", \"scala.version\":\"fake\", \"java.version\":\"fake\", \"snowflakedb.jdbc.version\":\"fake\"}");
        connection = SnowflakeDriverLatestIT.getConnection(0, props, false, false);
        try {
            statement = connection.createStatement();
            try {
                res = statement.executeQuery("select current_session_client_info()");
                try {
                    Assertions.assertTrue((boolean)res.next());
                    clientInfoJSONStr = res.getString(1);
                    clientInfoJSON = SnowflakeResultSetSerializableV1.mapper.readTree(clientInfoJSONStr);
                    Assertions.assertEquals((Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText(), (String)"spark version mismatch");
                    Assertions.assertEquals((Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText(), (String)"spark app mismatch");
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        System.clearProperty("snowflake.client.info");
    }

    @Test
    public void testGetSessionID() throws Throwable {
        try (Connection con = SnowflakeDriverLatestIT.getConnection();
             Statement statement = con.createStatement();
             ResultSet rset = statement.executeQuery("select current_session()");){
            String sessionID = con.unwrap(SnowflakeConnection.class).getSessionID();
            Assertions.assertTrue((boolean)rset.next());
            Assertions.assertEquals((Object)sessionID, (Object)rset.getString(1));
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPutThreshold() throws SQLException {
        try (Connection connection = SnowflakeDriverLatestIT.getConnection();){
            SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            try (Statement statement = connection.createStatement();){
                SFStatement sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
                statement.execute("CREATE OR REPLACE STAGE PUTTHRESHOLDSTAGE");
                String command = "PUT file://" + SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv") + " @PUTTHRESHOLDSTAGE";
                SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
                Assertions.assertEquals((int)0xC800000, (int)agent.getBigFileThreshold());
                String commandWithPut = command + " threshold=314572800";
                agent = new SnowflakeFileTransferAgent(commandWithPut, sfSession, sfStatement);
                Assertions.assertEquals((int)314572800, (int)agent.getBigFileThreshold());
                agent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
                Assertions.assertEquals((int)0xC800000, (int)agent.getBigFileThreshold());
                String commandWithInvalidThreshold = command + " threshold=-1";
                try {
                    agent = new SnowflakeFileTransferAgent(commandWithInvalidThreshold, sfSession, sfStatement);
                }
                catch (SQLException e) {
                    Assertions.assertEquals((Object)"22023", (Object)e.getSQLState());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled
    public void testGCPFileTransferMetadataWithOneFile() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount");
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
                List metadatas1 = sfAgent1.getFileTransferMetadatas();
                String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                    FileInputStream inputStream = new FileInputStream(srcPath1);
                    Assertions.assertTrue((boolean)oneMetadata.isForOneFile());
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
                }
                String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
                List metadatas2 = sfAgent2.getFileTransferMetadatas();
                String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                    String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                    Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                    p.waitFor();
                    FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                    Assertions.assertTrue((boolean)oneMetadata.isForOneFile());
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
                }
                Assertions.assertTrue((boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"), (String)"Failed to get files");
                Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
                Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
            }
            finally {
                statement.execute("DROP STAGE if exists " + this.testStageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testAzureS3FileTransferMetadataWithOneFile() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            Connection connection = SnowflakeDriverLatestIT.getConnection(accountName);
            try {
                Statement statement = connection.createStatement();
                try {
                    try {
                        statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                        SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                        String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
                        SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
                        List metadatas1 = sfAgent1.getFileTransferMetadatas();
                        String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                        for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                            FileInputStream inputStream = new FileInputStream(srcPath1);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).build());
                        }
                        String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
                        SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
                        List metadatas2 = sfAgent2.getFileTransferMetadatas();
                        String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
                        for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                            String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                            Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                            p.waitFor();
                            p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                            p.waitFor();
                            FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand2).build());
                        }
                        Assertions.assertTrue((boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"), (String)"Failed to get files");
                        Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
                        Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
                    }
                    finally {
                        statement.execute("DROP STAGE if exists " + this.testStageName);
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGCPFileTransferMetadataNegativeOnlySupportPut() throws Throwable {
        int expectExceptionCount = 1;
        int actualExceptionCount = -1;
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount");
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                statement.execute("put file://" + srcPath + " @" + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                File destFolder = new File(this.tmpFolder, "dest");
                destFolder.mkdirs();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String getCommand = "get @" + this.testStageName + " file://" + destFolderCanonicalPath;
                statement.execute(getCommand);
                SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(getCommand, sfSession, new SFStatement(sfSession));
                actualExceptionCount = 0;
                sfAgent.getFileTransferMetadatas();
                Assertions.fail((String)"Above function should raise exception for GET");
            }
            catch (Exception ex) {
                System.out.println("Negative test to hit expected exception: " + ex.getMessage());
                ++actualExceptionCount;
            }
            finally {
                statement.execute("DROP STAGE if exists " + this.testStageName);
            }
        }
        Assertions.assertEquals((int)expectExceptionCount, (int)actualExceptionCount);
    }

    @Test
    public void testGetPropertyInfo() throws SQLException {
        String url = "";
        Properties props = new Properties();
        Driver driver = DriverManager.getDriver("jdbc:snowflake://snowflake.reg.local:8082");
        DriverPropertyInfo[] info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)1, (int)info.length);
        Assertions.assertEquals((Object)"serverURL", (Object)info[0].name);
        Assertions.assertEquals((Object)"server URL in form of <protocol>://<host or domain>:<port number>/<path of resource>", (Object)info[0].description);
        url = null;
        props = new Properties();
        driver = DriverManager.getDriver("jdbc:snowflake://snowflake.reg.local:8082");
        info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)1, (int)info.length);
        Assertions.assertEquals((Object)"serverURL", (Object)info[0].name);
        Assertions.assertEquals((Object)"server URL in form of <protocol>://<host or domain>:<port number>/<path of resource>", (Object)info[0].description);
        url = "jdbc:snowflake://snowflake.reg.local:8082";
        info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)2, (int)info.length);
        Assertions.assertEquals((Object)"user", (Object)info[0].name);
        Assertions.assertEquals((Object)"username for account", (Object)info[0].description);
        Assertions.assertEquals((Object)"password", (Object)info[1].name);
        Assertions.assertEquals((Object)"password for account", (Object)info[1].description);
        props.put("user", "snowman");
        props.put("password", "test");
        info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)0, (int)info.length);
        props.put("useProxy", "true");
        info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)2, (int)info.length);
        Assertions.assertEquals((Object)"proxyHost", (Object)info[0].name);
        Assertions.assertEquals((Object)"proxy host name", (Object)info[0].description);
        Assertions.assertEquals((Object)"proxyPort", (Object)info[1].name);
        Assertions.assertEquals((Object)"proxy port; should be an integer", (Object)info[1].description);
        props.put("proxyHost", "dummyHost");
        props.put("proxyPort", "dummyPort");
        info = driver.getPropertyInfo(url, props);
        Assertions.assertEquals((int)0, (int)info.length);
        try {
            url = "snowflake.reg.local:8082";
            driver.getPropertyInfo(url, props);
        }
        catch (SQLException e) {
            Assertions.assertEquals((int)ErrorCode.INVALID_CONNECT_STRING.getMessageCode(), (int)e.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutOverwriteFalseNoDigest() throws Throwable {
        File file1 = new File(this.tmpFolder, "testfile.csv");
        file1.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file1));){
            bw.write("Writing original file content. This should get overwritten.");
        }
        File file2 = new File(this.tmpFolder2, "testfile.csv");
        file2.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file2));){
            bw.write("This is all new! This should be the result of the overwriting.");
        }
        String sourceFilePathOriginal = file1.getCanonicalPath();
        String sourceFilePathOverwrite = file2.getCanonicalPath();
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverLatestIT.getConnection(accounts.get(i), paramProperties);
                 Statement statement = connection.createStatement();){
                try {
                    statement.execute("CREATE OR REPLACE STAGE testing_stage");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePathOriginal + " @testing_stage"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePathOverwrite + " @testing_stage overwrite=false"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                    Assertions.assertTrue((boolean)statement.execute("GET @testing_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                    p.waitFor();
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "testfile.csv");
                    Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)unzipped, null));
                    continue;
                }
                finally {
                    statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPutDisable() throws Throwable {
        File file = new File(this.tmpFolder, "testfile99.csv");
        file.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write("This content won't be uploaded as PUT is disabled.");
        }
        String sourceFilePathOriginal = file.getCanonicalPath();
        Properties paramProperties = new Properties();
        paramProperties.put("enablePutGet", (Object)false);
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverLatestIT.getConnection(accounts.get(i), paramProperties);
                 Statement statement = connection.createStatement();){
                statement.execute("PUT file://" + sourceFilePathOriginal + " @testPutGet_disable_stage");
                Assertions.assertTrue((boolean)false, (String)"Shouldn't come here");
                continue;
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().equalsIgnoreCase("File transfers have been disabled."));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testGetDisable() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        Properties paramProperties = new Properties();
        paramProperties.put("enablePutGet", (Object)false);
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverLatestIT.getConnection(accounts.get(i), paramProperties);
                 Statement statement = connection.createStatement();){
                statement.execute("GET @testPutGet_disable_stage 'file://" + destFolderCanonicalPath + "' parallel=8");
                Assertions.assertTrue((boolean)false, (String)"Shouldn't come here");
                continue;
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().equalsIgnoreCase("File transfers have been disabled."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow76376() throws Throwable {
        block92: {
            try (Connection connection = SnowflakeDriverLatestIT.getConnection();
                 Statement regularStatement = connection.createStatement();){
                try {
                    ResultSet resultSet;
                    PreparedStatement preparedStatement;
                    block91: {
                        regularStatement.execute("create or replace table t(a int) as select * from values(1),(2),(8),(10)");
                        preparedStatement = connection.prepareStatement("SELECT * FROM t ORDER BY a LIMIT ? OFFSET ?");
                        try {
                            preparedStatement.setNull(1, 4);
                            preparedStatement.setNull(2, 4);
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)10, (int)resultSet.getInt(1));
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            } else {
                                Assertions.fail((String)"Could not execute preparedStatement with OFFSET and LIMIT set to NULL");
                            }
                            preparedStatement.setString(1, "");
                            preparedStatement.setString(2, "");
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)10, (int)resultSet.getInt(1));
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            } else {
                                Assertions.fail((String)"Could not execute preparedStatement with OFFSET and LIMIT set to empty string");
                            }
                            preparedStatement.setNull(1, 4);
                            preparedStatement.setInt(2, 2);
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)10, (int)resultSet.getInt(1));
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            } else {
                                Assertions.fail((String)"Could not execute preparedStatement with LIMIT set to NULL");
                            }
                            preparedStatement.setString(1, "");
                            preparedStatement.setInt(2, 2);
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)10, (int)resultSet.getInt(1));
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            } else {
                                Assertions.fail((String)"Could not execute preparedStatement with LIMIT set to empty string");
                            }
                            preparedStatement.setInt(1, 3);
                            preparedStatement.setNull(2, 4);
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            } else {
                                Assertions.fail((String)"Could not execute preparedStatement with OFFSET set to NULL");
                            }
                            preparedStatement.setInt(1, 3);
                            preparedStatement.setNull(2, 4);
                            if (preparedStatement.execute()) {
                                resultSet = preparedStatement.getResultSet();
                                try {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)8, (int)resultSet.getInt(1));
                                    break block91;
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            }
                            Assertions.fail((String)"Could not execute preparedStatement with OFFSET set to empty string");
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                    }
                    preparedStatement = connection.prepareStatement("SELECT 1 FROM t ORDER BY a LIMIT ? OFFSET ?");
                    try {
                        int i;
                        preparedStatement.setNull(1, 4);
                        preparedStatement.setNull(2, 4);
                        if (preparedStatement.execute()) {
                            resultSet = preparedStatement.getResultSet();
                            try {
                                for (i = 0; i < 4; ++i) {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                }
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        } else {
                            Assertions.fail((String)"Could not execute constant preparedStatement with OFFSET and LIMIT set to NULL");
                        }
                        preparedStatement.setString(1, "");
                        preparedStatement.setString(2, "");
                        if (preparedStatement.execute()) {
                            resultSet = preparedStatement.getResultSet();
                            try {
                                for (i = 0; i < 4; ++i) {
                                    Assertions.assertTrue((boolean)resultSet.next());
                                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                                }
                                break block92;
                            }
                            finally {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                        }
                        Assertions.fail((String)"Could not execute constant preparedStatement with OFFSET and LIMIT set to empty string");
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                finally {
                    regularStatement.execute("drop table t");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGeoOutputTypes() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_USER_DEFINED_TYPE_EXPANSION", (Object)true);
        paramProperties.put("ENABLE_GEOGRAPHY_TYPE", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table t_geo(geo geography);");
                regularStatement.execute("insert into t_geo values ('POINT(0 0)'), ('LINESTRING(1 1, 2 2)')");
                this.testGeoOutputTypeSingle(regularStatement, false, "geoJson", "OBJECT", "java.lang.String", 12);
                this.testGeoOutputTypeSingle(regularStatement, true, "geoJson", "GEOGRAPHY", "java.lang.String", 12);
                this.testGeoOutputTypeSingle(regularStatement, false, "wkt", "VARCHAR", "java.lang.String", 12);
                this.testGeoOutputTypeSingle(regularStatement, true, "wkt", "GEOGRAPHY", "java.lang.String", 12);
                this.testGeoOutputTypeSingle(regularStatement, false, "wkb", "BINARY", "[B", -2);
                this.testGeoOutputTypeSingle(regularStatement, true, "wkb", "GEOGRAPHY", "[B", -2);
            }
            finally {
                regularStatement.execute("drop table t_geo");
            }
        }
    }

    private void testGeoOutputTypeSingle(Statement regularStatement, boolean enableExternalTypeNames, String outputFormat, String expectedColumnTypeName, String expectedColumnClassName, int expectedColumnType) throws Throwable {
        regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
        regularStatement.execute("alter session set ENABLE_UDT_EXTERNAL_TYPE_NAMES=" + enableExternalTypeNames);
        try (ResultSet resultSet = regularStatement.executeQuery("select * from t_geo");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assertions.assertEquals((int)1, (int)metadata.getColumnCount());
            Assertions.assertEquals((Object)expectedColumnTypeName, (Object)metadata.getColumnTypeName(1));
            Assertions.assertEquals((Object)expectedColumnClassName, (Object)metadata.getColumnClassName(1));
            Assertions.assertEquals((int)expectedColumnType, (int)metadata.getColumnType(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGeoMetadata() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_FIX_182763", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table t_geo(geo geography);");
                this.testGeoMetadataSingle(connection, regularStatement, "geoJson", 12);
                this.testGeoMetadataSingle(connection, regularStatement, "geoJson", 12);
                this.testGeoMetadataSingle(connection, regularStatement, "wkt", 12);
                this.testGeoMetadataSingle(connection, regularStatement, "wkt", 12);
                this.testGeoMetadataSingle(connection, regularStatement, "wkb", -2);
                this.testGeoMetadataSingle(connection, regularStatement, "wkb", -2);
            }
            finally {
                regularStatement.execute("drop table t_geo");
            }
        }
    }

    private void testGeoMetadataSingle(Connection connection, Statement regularStatement, String outputFormat, int expectedColumnType) throws Throwable {
        regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
        DatabaseMetaData md = connection.getMetaData();
        try (ResultSet resultSet = md.getColumns(null, null, "T_GEO", null);){
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assertions.assertEquals((int)24, (int)metadata.getColumnCount());
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)expectedColumnType, (int)resultSet.getInt(5));
            Assertions.assertEquals((Object)"GEOGRAPHY", (Object)resultSet.getString(6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGeometryOutputTypes() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_USER_DEFINED_TYPE_EXPANSION", (Object)true);
        paramProperties.put("ENABLE_GEOMETRY_TYPE", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table t_geo2(geo geometry);");
                regularStatement.execute("insert into t_geo2 values ('POINT(0 0)'), ('LINESTRING(1 1, 2 2)')");
                this.testGeometryOutputTypeSingle(regularStatement, true, "geoJson", "GEOMETRY", "java.lang.String", 12);
                this.testGeometryOutputTypeSingle(regularStatement, true, "wkt", "GEOMETRY", "java.lang.String", 12);
            }
            finally {
                regularStatement.execute("drop table t_geo2");
            }
        }
    }

    private void testGeometryOutputTypeSingle(Statement regularStatement, boolean enableExternalTypeNames, String outputFormat, String expectedColumnTypeName, String expectedColumnClassName, int expectedColumnType) throws Throwable {
        regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
        regularStatement.execute("alter session set ENABLE_UDT_EXTERNAL_TYPE_NAMES=" + enableExternalTypeNames);
        try (ResultSet resultSet = regularStatement.executeQuery("select * from t_geo2");){
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assertions.assertEquals((int)1, (int)metadata.getColumnCount());
            Assertions.assertEquals((Object)expectedColumnTypeName, (Object)metadata.getColumnTypeName(1));
            Assertions.assertEquals((Object)expectedColumnClassName, (Object)metadata.getColumnClassName(1));
            Assertions.assertEquals((int)expectedColumnType, (int)metadata.getColumnType(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGeometryMetadata() throws Throwable {
        Properties paramProperties = new Properties();
        try (Connection connection = SnowflakeDriverLatestIT.getConnection(paramProperties);
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table t_geo2(geo geometry);");
                this.testGeometryMetadataSingle(connection, regularStatement, "geoJson", 12);
                this.testGeometryMetadataSingle(connection, regularStatement, "wkt", 12);
            }
            finally {
                regularStatement.execute("drop table t_geo2");
            }
        }
    }

    private void testGeometryMetadataSingle(Connection connection, Statement regularStatement, String outputFormat, int expectedColumnType) throws Throwable {
        regularStatement.execute("alter session set GEOGRAPHY_OUTPUT_FORMAT='" + outputFormat + "'");
        DatabaseMetaData md = connection.getMetaData();
        try (ResultSet resultSet = md.getColumns(null, null, "T_GEO2", null);){
            ResultSetMetaData metadata = resultSet.getMetaData();
            Assertions.assertEquals((int)24, (int)metadata.getColumnCount());
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)expectedColumnType, (int)resultSet.getInt(5));
            Assertions.assertEquals((Object)"GEOMETRY", (Object)resultSet.getString(6));
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPutGetGcsDownscopedCredential() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            this.putAndGetFile(statement);
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testPutGetGcsDownscopedCredentialWithDisabledDefaultCredentials() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        paramProperties.put(SFSessionProperty.DISABLE_GCS_DEFAULT_CREDENTIALS.getPropertyKey(), (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            this.putAndGetFile(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndGetFile(Statement statement) throws Throwable {
        String sourceFilePath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        try {
            statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
            Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"), (String)"Failed to put a file");
            SnowflakeDriverIT.findFile(statement, "ls @testPutGet_stage/");
            Assertions.assertTrue((boolean)statement.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get a file");
            File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_101.csv" + ".gz");
            Assertions.assertTrue((boolean)downloaded.exists());
            Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_101.csv" + ".gz");
            p.waitFor();
            File original = new File(sourceFilePath);
            File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_101.csv");
            System.out.println("Original file: " + original.getAbsolutePath() + ", size: " + original.length());
            System.out.println("Unzipped file: " + unzipped.getAbsolutePath() + ", size: " + unzipped.length());
            Assertions.assertEquals((long)original.length(), (long)unzipped.length());
        }
        finally {
            statement.execute("DROP STAGE IF EXISTS testGetPut_stage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutGetLargeFileGCSDownscopedCredential() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                File destFolder = new File(this.tmpFolder, "dest");
                destFolder.mkdirs();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                File largeTempFile = new File(this.tmpFolder, "largeFile.csv");
                largeTempFile.createNewFile();
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));){
                    bw.write("Creating large test file for GCP PUT/GET test");
                    bw.write(System.lineSeparator());
                    bw.write("Creating large test file for GCP PUT/GET test");
                    bw.write(System.lineSeparator());
                }
                File largeTempFile2 = new File(this.tmpFolder, "largeFile2.csv");
                largeTempFile2.createNewFile();
                String sourceFilePath = largeTempFile.getCanonicalPath();
                for (int i = 0; i < 12; ++i) {
                    this.copyContentFrom(largeTempFile, largeTempFile2);
                    this.copyContentFrom(largeTempFile2, largeTempFile);
                }
                statement.execute("CREATE OR REPLACE STAGE largefile_stage");
                Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"), (String)"Failed to put a file");
                SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
                statement.execute("create or replace table large_table (colA string)");
                statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
                statement.execute("create or replace stage extra_stage");
                statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
                Assertions.assertTrue((boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                Assertions.assertTrue((boolean)downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                p.waitFor();
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
                Assertions.assertEquals((long)largeTempFile.length(), (long)unzipped.length());
                Assertions.assertTrue((boolean)FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS largefile_stage");
                statement.execute("DROP STAGE IF EXISTS extra_stage");
                statement.execute("DROP TABLE IF EXISTS large_table");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutGetLargeFileAzure() throws Throwable {
        Properties paramProperties = new Properties();
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("azureaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                File destFolder = new File(this.tmpFolder, "dest");
                destFolder.mkdirs();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                File largeTempFile = new File(this.tmpFolder, "largeFile.csv");
                largeTempFile.createNewFile();
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));){
                    bw.write("Creating large test file for Azure PUT/GET test");
                    bw.write(System.lineSeparator());
                    bw.write("Creating large test file for Azure PUT/GET test");
                    bw.write(System.lineSeparator());
                }
                File largeTempFile2 = new File(this.tmpFolder, "largeFile2.csv");
                largeTempFile2.createNewFile();
                String sourceFilePath = largeTempFile.getCanonicalPath();
                for (int i = 0; i < 12; ++i) {
                    this.copyContentFrom(largeTempFile, largeTempFile2);
                    this.copyContentFrom(largeTempFile2, largeTempFile);
                }
                statement.execute("CREATE OR REPLACE STAGE largefile_stage");
                Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"), (String)"Failed to put a file");
                SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
                statement.execute("create or replace table large_table (colA string)");
                statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
                statement.execute("create or replace stage extra_stage");
                statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
                Assertions.assertTrue((boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                Assertions.assertTrue((boolean)downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                p.waitFor();
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
                Assertions.assertEquals((long)largeTempFile.length(), (long)unzipped.length());
                Assertions.assertTrue((boolean)FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS largefile_stage");
                statement.execute("DROP STAGE IF EXISTS extra_stage");
                statement.execute("DROP TABLE IF EXISTS large_table");
            }
        }
    }

    private void copyContentFrom(File file1, File file2) throws Exception {
        FileInputStream inputStream = new FileInputStream(file1);
        FileOutputStream outputStream = new FileOutputStream(file2);
        try (FileChannel fIn = inputStream.getChannel();
             FileChannel fOut = outputStream.getChannel();){
            fOut.transferFrom(fIn, 0L, fIn.size());
            fIn.position(0L);
            fOut.transferFrom(fIn, fIn.size(), fIn.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutS3RegionalUrl() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            Connection connection = SnowflakeDriverLatestIT.getConnection(accountName);
            try {
                Statement statement = connection.createStatement();
                try {
                    try {
                        FileInputStream inputStream;
                        statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                        SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                        String putCommand1 = "put file:///dummy/path/file1.gz @" + this.testStageName;
                        SnowflakeFileTransferAgent sfAgent1 = new SnowflakeFileTransferAgent(putCommand1, sfSession, new SFStatement(sfSession));
                        List metadatas1 = sfAgent1.getFileTransferMetadatas();
                        String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                        for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                            inputStream = new FileInputStream(srcPath1);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).setUseS3RegionalUrl(false).build());
                        }
                        for (SnowflakeFileTransferMetadata oneMetadata : metadatas1) {
                            inputStream = new FileInputStream(srcPath1);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand1).setUseS3RegionalUrl(true).build());
                        }
                        String putCommand2 = "put file:///dummy/path/file2.gz @" + this.testStageName;
                        SnowflakeFileTransferAgent sfAgent2 = new SnowflakeFileTransferAgent(putCommand2, sfSession, new SFStatement(sfSession));
                        List metadatas2 = sfAgent2.getFileTransferMetadatas();
                        String srcPath2 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_101.csv");
                        for (SnowflakeFileTransferMetadata oneMetadata : metadatas2) {
                            String gzfilePath = destFolderCanonicalPath + "/tmp_compress.gz";
                            Process p = Runtime.getRuntime().exec("cp -fr " + srcPath2 + " " + destFolderCanonicalPath + "/tmp_compress");
                            p.waitFor();
                            p = Runtime.getRuntime().exec("gzip " + destFolderCanonicalPath + "/tmp_compress");
                            p.waitFor();
                            FileInputStream gzInputStream = new FileInputStream(gzfilePath);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)gzInputStream).setRequireCompress(false).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand2).build());
                        }
                        Assertions.assertTrue((boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"), (String)"Failed to get files");
                        Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath1, false, destFolderCanonicalPath + "/file1.gz", true));
                        Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath2, false, destFolderCanonicalPath + "/file2.gz", true));
                    }
                    finally {
                        statement.execute("DROP STAGE if exists " + this.testStageName);
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testAzureS3UploadStreamingIngestFileMetadata() throws Throwable {
        String clientName = "clientName";
        String clientKey = "clientKey";
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            Connection connection = SnowflakeDriverLatestIT.getConnection(accountName);
            try {
                Statement statement = connection.createStatement();
                try {
                    try {
                        statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                        SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                        String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
                        SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
                        List metadata = sfAgent.getFileTransferMetadatas();
                        String srcPath1 = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                        for (SnowflakeFileTransferMetadata oneMetadata : metadata) {
                            FileInputStream inputStream = new FileInputStream(srcPath1);
                            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).setSFSession(sfSession).setCommand(putCommand).setStreamingIngestClientName(clientName).setStreamingIngestClientKey(clientKey).build());
                            SnowflakeStorageClient client = StorageClientFactory.getFactory().createClient(((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo(), 1, null, null);
                            String location = ((SnowflakeFileTransferMetadataV1)oneMetadata).getStageInfo().getLocation();
                            int idx = location.indexOf(47);
                            String remoteStageLocation = location.substring(0, idx);
                            String path = location.substring(idx + 1) + "file1.gz";
                            StorageObjectMetadata meta = client.getObjectMetadata(remoteStageLocation, path);
                            Assertions.assertEquals((Object)clientName, (Object)client.getStreamingIngestClientName(meta));
                            Assertions.assertEquals((Object)clientKey, (Object)client.getStreamingIngestClientKey(meta));
                        }
                    }
                    finally {
                        statement.execute("DROP STAGE if exists " + this.testStageName);
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testNoSpaceLeftOnDeviceException() throws SQLException {
        List<String> supportedAccounts = Arrays.asList("gcpaccount", "s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            Connection connection = SnowflakeDriverLatestIT.getConnection(accountName);
            try {
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                Statement statement = connection.createStatement();
                try {
                    try {
                        SFStatement sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
                        statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                        statement.execute("PUT file://" + SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage");
                        String command = "get @testPutGet_stage/orders_100.csv 'file:///tmp'";
                        SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(command, sfSession, sfStatement);
                        StageInfo info = sfAgent.getStageInfo();
                        SnowflakeStorageClient client = StorageClientFactory.getFactory().createClient(info, 1, null, null);
                        Assertions.assertThrows(SnowflakeSQLException.class, () -> client.handleStorageException((Exception)new StorageException(client.getMaxRetries(), "No space left on device", (Throwable)new IOException("No space left on device")), client.getMaxRetries(), "download", null, command, null));
                    }
                    finally {
                        statement.execute("DROP STAGE if exists testPutGet_stage");
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled
    public void testUploadWithGCSPresignedUrlWithoutConnection() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)false);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
                List metadata = sfAgent.getFileTransferMetadatas();
                String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource("orders_100.csv");
                for (SnowflakeFileTransferMetadata oneMetadata : metadata) {
                    FileInputStream inputStream = new FileInputStream(srcPath);
                    Assertions.assertTrue((boolean)oneMetadata.isForOneFile());
                    SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
                }
                Assertions.assertTrue((boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/' parallel=8"), (String)"Failed to get files");
                Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath, false, destFolderCanonicalPath + "/file1.gz", true));
            }
            finally {
                statement.execute("DROP STAGE if exists " + this.testStageName);
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testUploadWithGCSDownscopedCredentialWithoutConnection() throws Throwable {
        this.uploadWithGCSDownscopedCredentialWithoutConnection();
    }

    @Test
    @DontRunOnGithubActions
    public void testUploadWithGCSDownscopedCredentialAndDisabledGcsDefaultCredentialsWithoutConnection() throws Throwable {
        System.setProperty("net.snowflake.jdbc.disableGcsDefaultCredentials", "true");
        try {
            this.uploadWithGCSDownscopedCredentialWithoutConnection();
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.disableGcsDefaultCredentials");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadWithGCSDownscopedCredentialWithoutConnection() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                String[] fileNames;
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                SFSession sfSession = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
                String putCommand = "put file:///dummy/path/file1.gz @" + this.testStageName;
                SnowflakeFileTransferAgent sfAgent = new SnowflakeFileTransferAgent(putCommand, sfSession, new SFStatement(sfSession));
                List metadataList = sfAgent.getFileTransferMetadatas();
                Assertions.assertEquals((int)1, (int)metadataList.size());
                SnowflakeFileTransferMetadata oneMetadata = (SnowflakeFileTransferMetadata)metadataList.get(0);
                Assertions.assertFalse((boolean)oneMetadata.isForOneFile());
                for (String fileName : fileNames = new String[]{"orders_100.csv", "orders_101.csv"}) {
                    String srcPath = SnowflakeDriverLatestIT.getFullPathFileInResource(fileName);
                    try (FileInputStream inputStream = new FileInputStream(srcPath);){
                        String targetFileName = fileName + ".gz";
                        SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata(oneMetadata).setUploadStream((InputStream)inputStream).setDestFileName(targetFileName).setRequireCompress(true).setNetworkTimeoutInMilli(0).setOcspMode(OCSPMode.FAIL_OPEN).build());
                        Assertions.assertTrue((boolean)statement.execute("GET @" + this.testStageName + " 'file://" + destFolderCanonicalPath + "/'"), (String)"Failed to get files with down-scoped token");
                        Assertions.assertTrue((boolean)this.isFileContentEqual(srcPath, false, destFolderCanonicalPath + "/" + targetFileName, true));
                    }
                }
            }
            finally {
                statement.execute("DROP STAGE if exists " + this.testStageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testHTAPOptimizations() throws SQLException {
        Statement statement;
        Connection con;
        try {
            con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();
            try {
                statement = con.createStatement();
                try {
                    statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " set ENABLE_SNOW_654741_FOR_TESTING=true");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            con = SnowflakeDriverLatestIT.getConnection();
            try {
                SFSession session = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
                Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").equalsIgnoreCase(con.getSchema()));
                Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").equalsIgnoreCase(con.getCatalog()));
                Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_WAREHOUSE").equalsIgnoreCase(session.getWarehouse()));
                try (Statement statement2 = con.createStatement();){
                    try {
                        statement2.execute("alter session set TIMESTAMP_OUTPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FFTZH'");
                        statement2.execute("create or replace table testtable1 (cola string, colb int)");
                        statement2.execute("insert into testtable1 values ('row1', 1), ('row2', 2), ('row3', 3)");
                        try (ResultSet rs = statement2.executeQuery("select * from testtable1");){
                            Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs));
                            Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").equalsIgnoreCase(con.getSchema()));
                            Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").equalsIgnoreCase(con.getCatalog()));
                            Assertions.assertTrue((boolean)TestUtil.systemGetEnv("SNOWFLAKE_TEST_WAREHOUSE").equalsIgnoreCase(session.getWarehouse()));
                            Assertions.assertEquals((Object)"YYYY-MM-DD HH24:MI:SS.FFTZH", session.getCommonParameters().get("TIMESTAMP_OUTPUT_FORMAT"));
                        }
                    }
                    finally {
                        statement2.execute("alter session unset TIMESTAMP_OUTPUT_FORMAT");
                        statement2.execute("drop table if exists testtable1");
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        finally {
            con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();
            try {
                statement = con.createStatement();
                try {
                    statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " unset ENABLE_SNOW_654741_FOR_TESTING");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testHTAPStatementParameterCaching() throws SQLException {
        Statement statement;
        try (Connection con = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();){
            statement = con.createStatement();
            statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " set ENABLE_SNOW_654741_FOR_TESTING=true");
        }
        con = SnowflakeDriverLatestIT.getConnection();
        try {
            statement = con.createStatement();
            try {
                try {
                    statement.execute("create or replace table timetable (t1 time, t2 timestamp, t3 date)");
                    statement.execute("insert into timetable values ('13:53:11', '2023-08-17 13:53:33', '2023-08-17')");
                    statement.unwrap(SnowflakeStatement.class).setParameter("TIME_OUTPUT_FORMAT", (Object)"HH12:MI:SS.FF AM");
                    statement.unwrap(SnowflakeStatement.class).setParameter("DATE_OUTPUT_FORMAT", (Object)"DD-MON-YYYY");
                    statement.unwrap(SnowflakeStatement.class).setParameter("TIMESTAMP_OUTPUT_FORMAT", (Object)"YYYY-MM-DD\"T\"HH24:MI:SS");
                    try (ResultSet resultSet = statement.executeQuery("select * from timetable");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((Object)"01:53:11.000000000 PM", (Object)resultSet.getString(1));
                        Assertions.assertEquals((Object)"2023-08-17T13:53:33", (Object)resultSet.getString(2));
                        Assertions.assertEquals((Object)"17-Aug-2023", (Object)resultSet.getString(3));
                    }
                    statement.unwrap(SnowflakeStatement.class).setParameter("DATE_OUTPUT_FORMAT", (Object)"MM/DD/YYYY");
                    resultSet = statement.executeQuery("select * from timetable");
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((Object)"08/17/2023", (Object)resultSet.getString(3));
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    statement.execute("drop table if exists timetable");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
        try (Connection con2 = SnowflakeDriverLatestIT.getSnowflakeAdminConnection();){
            statement = con2.createStatement();
            try {
                statement.execute("alter account " + TestUtil.systemGetEnv("SNOWFLAKE_TEST_ACCOUNT") + " unset ENABLE_SNOW_654741_FOR_TESTING");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testS3PutInGS() throws Throwable {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        Properties paramProperties = new Properties();
        try (Connection connection = SnowflakeDriverLatestIT.getConnection("s3testaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE STAGE " + this.testStageName);
                String fileName = "testFile.json";
                String content = "testName: testS3PutInGs";
                String putSystemCall = String.format("call system$it('PUT_FILE_TO_STAGE', '%s', '%s', '%s', '%s')", this.testStageName, "testFile.json", "testName: testS3PutInGs", "false");
                statement.execute(putSystemCall);
                String getCall = String.format("GET @%s 'file://%s/'", this.testStageName, destFolderCanonicalPath);
                statement.execute(getCall);
                FileInputStream downloadedFileStream = new FileInputStream(destFolderCanonicalPath + "/" + "testFile.json");
                String downloadedFile = IOUtils.toString((InputStream)downloadedFileStream, (Charset)StandardCharsets.UTF_8);
                Assertions.assertTrue((boolean)"testName: testS3PutInGs".equals(downloadedFile), (String)"downloaded content does not equal uploaded content");
            }
            finally {
                statement.execute("DROP STAGE if exists " + this.testStageName);
            }
        }
    }

    @Test
    public void shouldLoadDriverWithDisabledTelemetryOob() throws ClassNotFoundException {
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        Assertions.assertFalse((boolean)TelemetryService.getInstance().isEnabled());
        Assertions.assertFalse((boolean)TelemetryService.getInstance().isHTAPEnabled());
    }
}

