/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowflakeFileTransferConfigTest {
    private static final SnowflakeFileTransferMetadataV1 SNOWFLAKE_FILE_TRANSFER_METADATA = new SnowflakeFileTransferMetadataV1("", "", "", "", Long.valueOf(0L), SFBaseFileTransferAgent.CommandType.UPLOAD, null);
    private static final ByteArrayInputStream UPLOAD_STREAM = new ByteArrayInputStream(new byte[0]);

    @Test
    public void shouldBuildDefaultConfig() {
        SnowflakeFileTransferConfig config = SnowflakeFileTransferConfigTest.createObligatoryConfigPartInBuilder().build();
        SnowflakeFileTransferConfigTest.assertObligatoryParameters(config);
        Assertions.assertFalse((boolean)config.isSilentException());
    }

    private static void assertObligatoryParameters(SnowflakeFileTransferConfig config) {
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((Object)SNOWFLAKE_FILE_TRANSFER_METADATA, (Object)config.getSnowflakeFileTransferMetadata());
        Assertions.assertEquals((Object)UPLOAD_STREAM, (Object)config.getUploadStream());
        Assertions.assertEquals((Object)OCSPMode.DISABLE_OCSP_CHECKS, (Object)config.getOcspMode());
    }

    @Test
    public void shouldBuildConfig() {
        SnowflakeFileTransferConfig config = SnowflakeFileTransferConfigTest.createObligatoryConfigPartInBuilder().setSilentException(true).build();
        SnowflakeFileTransferConfigTest.assertObligatoryParameters(config);
        Assertions.assertTrue((boolean)config.isSilentException());
    }

    private static SnowflakeFileTransferConfig.Builder createObligatoryConfigPartInBuilder() {
        return SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)SNOWFLAKE_FILE_TRANSFER_METADATA).setUploadStream((InputStream)UPLOAD_STREAM).setOcspMode(OCSPMode.DISABLE_OCSP_CHECKS);
    }
}

