/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.google.cloud.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Tag(value="others")
public class SnowflakeS3ClientHandleExceptionLatestIT
extends AbstractDriverIT {
    @TempDir
    private File tmpFolder;
    private Connection connection;
    private SFStatement sfStatement;
    private SFSession sfSession;
    private String command;
    private SnowflakeS3Client spyingClient;
    private int overMaxRetry;
    private int maxRetry;
    private static final String EXPIRED_AWS_TOKEN_ERROR_CODE = "ExpiredToken";

    @BeforeEach
    public void setup() throws SQLException {
        this.connection = SnowflakeS3ClientHandleExceptionLatestIT.getConnection("s3testaccount");
        this.sfSession = this.connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Statement statement = this.connection.createStatement();
        this.sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
        statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        this.command = "PUT file://" + SnowflakeS3ClientHandleExceptionLatestIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage";
        SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(this.command, this.sfSession, this.sfStatement);
        StageInfo info = agent.getStageInfo();
        ClientConfiguration clientConfig = new ClientConfiguration();
        SnowflakeS3Client client = new SnowflakeS3Client(info.getCredentials(), clientConfig, (RemoteStoreFileEncryptionMaterial)agent.getEncryptionMaterial().get(0), info.getProxyProperties(), info.getRegion(), info.getEndPoint(), info.getIsClientSideEncrypted(), (SFBaseSession)this.sfSession, info.getUseS3RegionalUrl());
        this.maxRetry = client.getMaxRetries();
        this.overMaxRetry = this.maxRetry + 1;
        this.spyingClient = (SnowflakeS3Client)Mockito.spy((Object)client);
    }

    @Test
    @DontRunOnGithubActions
    public void errorRenewExpired() throws SQLException, InterruptedException {
        final AmazonS3Exception ex = new AmazonS3Exception("unauthenticated");
        ex.setErrorCode(EXPIRED_AWS_TOKEN_ERROR_CODE);
        this.spyingClient.handleStorageException((Exception)ex, 0, "upload", this.sfSession, this.command, null);
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)1))).renew(Mockito.anyMap());
        final Exception[] exceptionContainer = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SnowflakeS3ClientHandleExceptionLatestIT.this.spyingClient.handleStorageException((Exception)ex, SnowflakeS3ClientHandleExceptionLatestIT.this.maxRetry, "upload", SnowflakeS3ClientHandleExceptionLatestIT.this.sfSession, SnowflakeS3ClientHandleExceptionLatestIT.this.command, null);
                }
                catch (SnowflakeSQLException e) {
                    exceptionContainer[0] = e;
                }
            }
        });
        thread.start();
        thread.interrupt();
        thread.join();
        Assertions.assertNull((Object)exceptionContainer[0], (String)"Exception must not have been thrown in here");
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)2))).renew(Mockito.anyMap());
    }

    @Test
    @DontRunOnGithubActions
    public void errorNotFound() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new AmazonS3Exception("Not found"), this.overMaxRetry, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorBadRequestTokenExpired() throws SQLException {
        AmazonServiceException ex = new AmazonServiceException("Bad Request");
        ex.setServiceName("Amazon S3");
        ex.setStatusCode(400);
        ex.setErrorCode("400 Bad Request");
        ex.setErrorType(AmazonServiceException.ErrorType.Client);
        ((SnowflakeS3Client)Mockito.doReturn((Object)true).when((Object)this.spyingClient)).isClientException400Or404((Exception)ex);
        this.spyingClient.handleStorageException((Exception)ex, 0, "download", this.sfSession, this.command, null);
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)1))).isClientException400Or404((Exception)ex);
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)1))).renew(Mockito.anyMap());
    }

    @Test
    @DontRunOnGithubActions
    public void errorClientUnknown() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new AmazonClientException("Not found", (Throwable)new IOException()), this.overMaxRetry, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorInvalidKey() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException(new Exception(new InvalidKeyException()), 0, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorInterruptedException() throws SnowflakeSQLException {
        try {
            this.spyingClient.handleStorageException((Exception)new InterruptedException(), 0, "upload", this.sfSession, this.command, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have exception here");
        }
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new InterruptedException(), 26, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorSocketTimeoutException() throws SnowflakeSQLException {
        try {
            this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 0, "upload", this.sfSession, this.command, null);
        }
        catch (Exception e) {
            Assertions.fail((String)"Should not have exception here");
        }
        ((SnowflakeS3Client)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 26, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorUnknownException() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException(new Exception(), 0, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorRenewExpiredNullSession() {
        AmazonS3Exception ex = new AmazonS3Exception("unauthenticated");
        ex.setErrorCode(EXPIRED_AWS_TOKEN_ERROR_CODE);
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)ex, 0, "upload", null, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorNoSpaceLeftOnDevice() throws IOException {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String getCommand = "get @testPutGet_stage/orders_100.csv 'file://" + destFolderCanonicalPath + "'";
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new StorageException(this.maxRetry, "No space left on device", (Throwable)new IOException("No space left on device")), 0, "download", null, getCommand, null));
    }

    @AfterEach
    public void cleanUp() throws SQLException {
        this.sfStatement.close();
        this.connection.close();
    }
}

