/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class StatementLargeUpdateIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeUpdate() throws Throwable {
        try (Connection con = StatementLargeUpdateIT.getConnection();
             Statement statement = con.createStatement();){
            long expectedUpdateRows = 0x80000009L;
            try {
                statement.execute("create or replace table test_large_update(c1 boolean)");
                long updatedRows = statement.executeLargeUpdate("insert into test_large_update select true from table(generator(rowcount=>" + expectedUpdateRows + "))");
                Assertions.assertEquals((long)expectedUpdateRows, (long)updatedRows);
                Assertions.assertEquals((long)expectedUpdateRows, (long)statement.getLargeUpdateCount());
            }
            finally {
                statement.execute("drop table if exists test_large_update");
            }
        }
    }
}

