/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Tag(value="others")
public class CloudStorageClientLatestIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testDownloadStreamShouldFailFastOnNotExistingFile() throws Throwable {
        String stageName = "testDownloadStream_stage_" + UUID.randomUUID().toString().replaceAll("-", "_");
        try (Connection connection = CloudStorageClientLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE TEMP STAGE " + stageName);
                try (InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("@" + stageName, "/fileNotExist.gz", true);){
                    Assertions.fail((String)"file should not exist");
                }
                catch (Throwable e) {
                    MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(SQLException.class));
                }
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS " + stageName);
            }
        }
    }
}

