/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.CipherInputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class EncryptionProviderTest {
    private final SecureRandom random = new SecureRandom();
    private final ArgumentCaptor<StorageObjectMetadata> storageObjectMetadataArgumentCaptor = ArgumentCaptor.forClass(StorageObjectMetadata.class);
    private final ArgumentCaptor<MatDesc> matDescArgumentCaptor = ArgumentCaptor.forClass(MatDesc.class);
    private final ArgumentCaptor<byte[]> ivDataArgumentCaptor = ArgumentCaptor.forClass(byte[].class);
    private final ArgumentCaptor<byte[]> encKekArgumentCaptor = ArgumentCaptor.forClass(byte[].class);
    private final ArgumentCaptor<Long> contentLengthArgumentCaptor = ArgumentCaptor.forClass(Long.class);
    private final StorageObjectMetadata meta = (StorageObjectMetadata)Mockito.mock(StorageObjectMetadata.class);
    private final SnowflakeStorageClient storageClient = (SnowflakeStorageClient)Mockito.mock(SnowflakeStorageClient.class);
    private final String queryStageMasterKey = Base64.getEncoder().encodeToString(this.random.generateSeed(16));
    private final RemoteStoreFileEncryptionMaterial encMat = new RemoteStoreFileEncryptionMaterial();
    byte[] plainText = "the quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8);

    @BeforeEach
    public void setUp() {
        this.encMat.setQueryStageMasterKey(this.queryStageMasterKey);
        this.encMat.setSmkId(123L);
        this.encMat.setQueryId("query-id");
    }

    @Test
    public void testEncryptAndDecryptStream() throws Exception {
        ByteArrayInputStream plainTextStream = new ByteArrayInputStream(this.plainText);
        CipherInputStream encrypted = EncryptionProvider.encrypt((StorageObjectMetadata)this.meta, (long)this.plainText.length, (InputStream)plainTextStream, (RemoteStoreFileEncryptionMaterial)this.encMat, (SnowflakeStorageClient)this.storageClient);
        byte[] cipherText = IOUtils.toByteArray((InputStream)encrypted);
        ((SnowflakeStorageClient)Mockito.verify((Object)this.storageClient)).addEncryptionMetadata((StorageObjectMetadata)this.storageObjectMetadataArgumentCaptor.capture(), (MatDesc)this.matDescArgumentCaptor.capture(), (byte[])this.ivDataArgumentCaptor.capture(), (byte[])this.encKekArgumentCaptor.capture(), ((Long)this.contentLengthArgumentCaptor.capture()).longValue());
        InputStream inputStream = EncryptionProvider.decryptStream((InputStream)new ByteArrayInputStream(cipherText), (String)Base64.getEncoder().encodeToString((byte[])this.encKekArgumentCaptor.getValue()), (String)Base64.getEncoder().encodeToString((byte[])this.ivDataArgumentCaptor.getValue()), (RemoteStoreFileEncryptionMaterial)this.encMat);
        byte[] decryptedPlainText = IOUtils.toByteArray((InputStream)inputStream);
        Assertions.assertArrayEquals((byte[])this.plainText, (byte[])decryptedPlainText);
    }

    @Test
    public void testEncryptAndDecryptFile() throws Exception {
        File tempFile = Files.createTempFile("encryption", "", new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        CipherInputStream encrypted = EncryptionProvider.encrypt((StorageObjectMetadata)this.meta, (long)this.plainText.length, (InputStream)new ByteArrayInputStream(this.plainText), (RemoteStoreFileEncryptionMaterial)this.encMat, (SnowflakeStorageClient)this.storageClient);
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray((InputStream)encrypted));
        ((SnowflakeStorageClient)Mockito.verify((Object)this.storageClient)).addEncryptionMetadata((StorageObjectMetadata)this.storageObjectMetadataArgumentCaptor.capture(), (MatDesc)this.matDescArgumentCaptor.capture(), (byte[])this.ivDataArgumentCaptor.capture(), (byte[])this.encKekArgumentCaptor.capture(), ((Long)this.contentLengthArgumentCaptor.capture()).longValue());
        EncryptionProvider.decrypt((File)tempFile, (String)Base64.getEncoder().encodeToString((byte[])this.encKekArgumentCaptor.getValue()), (String)Base64.getEncoder().encodeToString((byte[])this.ivDataArgumentCaptor.getValue()), (RemoteStoreFileEncryptionMaterial)this.encMat);
        byte[] decryptedCipherText = FileUtils.readFileToByteArray((File)tempFile);
        Assertions.assertArrayEquals((byte[])this.plainText, (byte[])decryptedCipherText);
    }
}

