/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.providers.SnowflakeArgumentsProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class StageInfoGcsCustomEndpointTest {
    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    public void shouldReturnEmptyGCSRegionalUrlWhenNotMeCentral1AndNotUseRegionalUrl(String region, boolean useRegionalUrl, String endPoint, Optional<String> expectedHost) {
        StageInfo stageInfo = StageInfo.createStageInfo((String)"GCS", (String)"bla", new HashMap(), (String)region, (String)endPoint, (String)"account", (boolean)true);
        stageInfo.setUseRegionalUrl(useRegionalUrl);
        Assertions.assertEquals(expectedHost, (Object)stageInfo.gcsCustomEndpoint());
    }

    private static class DataProvider
    extends SnowflakeArgumentsProvider {
        private DataProvider() {
        }

        @Override
        protected List<Arguments> rawArguments(ExtensionContext context) {
            return Arrays.asList(Arguments.of((Object[])new Object[]{"US-CENTRAL1", false, null, Optional.empty()}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", false, "", Optional.empty()}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", false, "null", Optional.empty()}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", false, "    ", Optional.empty()}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", false, "example.com", Optional.of("example.com")}), Arguments.of((Object[])new Object[]{"ME-CENTRAL2", false, null, Optional.of("storage.me-central2.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"ME-CENTRAL2", true, null, Optional.of("storage.me-central2.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"ME-CENTRAL2", true, "", Optional.of("storage.me-central2.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"ME-CENTRAL2", true, "  ", Optional.of("storage.me-central2.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"ME-CENTRAL2", true, "example.com", Optional.of("example.com")}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", true, null, Optional.of("storage.us-central1.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", true, "", Optional.of("storage.us-central1.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", true, " ", Optional.of("storage.us-central1.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", true, "null", Optional.of("storage.us-central1.rep.googleapis.com")}), Arguments.of((Object[])new Object[]{"US-CENTRAL1", true, "example.com", Optional.of("example.com")}));
        }
    }
}

