/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

import java.util.HashMap;
import net.snowflake.client.jdbc.diagnostic.SnowflakeEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowflakeEndpointTest {
    @Test
    public void shouldDetectPrivateLinkEndpoint() {
        HashMap<String, Boolean> hostsToPrivateLinks = new HashMap<String, Boolean>();
        hostsToPrivateLinks.put("snowhouse.snowflakecomputing.com", false);
        hostsToPrivateLinks.put("snowhouse.privatelink.snowflakecomputing.com", true);
        hostsToPrivateLinks.put("snowhouse.snowflakecomputing.cn", false);
        hostsToPrivateLinks.put("snowhouse.PRIVATELINK.snowflakecomputing.cn", true);
        hostsToPrivateLinks.forEach((host, expectedToBePrivateLink) -> {
            SnowflakeEndpoint endpoint = new SnowflakeEndpoint("SNOWFLAKE_DEPLOYMENT", host, 443);
            Assertions.assertEquals((Object)expectedToBePrivateLink, (Object)endpoint.isPrivateLink(), (String)String.format("Expecting %s to be private link: %s", host, expectedToBePrivateLink));
        });
    }
}

