/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.structuredtypes;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.ResultSetFormatType;
import net.snowflake.client.jdbc.structuredtypes.StructuredTypesGetStringBaseIT;
import net.snowflake.client.providers.ProvidersUtil;
import net.snowflake.client.providers.ResultFormatProvider;
import net.snowflake.client.providers.SnowflakeArgumentsProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class StructuredTypesArrowJsonCompatibilityLatestIT
extends StructuredTypesGetStringBaseIT {
    private static Map<ResultSetFormatType, Connection> connections = new HashMap<ResultSetFormatType, Connection>();

    @BeforeAll
    public static void setUpConnections() throws SQLException {
        for (ResultSetFormatType queryResultFormat : ResultSetFormatType.values()) {
            connections.put(queryResultFormat, StructuredTypesArrowJsonCompatibilityLatestIT.initConnection(queryResultFormat));
        }
    }

    @AfterAll
    public static void closeConnections() throws SQLException {
        for (Connection connection : connections.values()) {
            connection.close();
        }
    }

    @ParameterizedTest
    @DontRunOnGithubActions
    @ArgumentsSource(value=DataProvider.class)
    public void testArrowJsonCompatibility(ResultSetFormatType queryResultFormat, String selectSql, String expectedStructureTypeRepresentation) throws SQLException {
        this.withFirstRow(connections.get((Object)queryResultFormat), selectSql, resultSet -> this.assertResultSetIsCompatible((ResultSet)resultSet, expectedStructureTypeRepresentation));
    }

    private static class DataProvider
    extends SnowflakeArgumentsProvider {
        private DataProvider() {
        }

        @Override
        protected List<Arguments> rawArguments(ExtensionContext context) {
            return ProvidersUtil.cartesianProduct(context, new ResultFormatProvider(), new SampleProvider());
        }
    }

    public static class SampleProvider
    extends SnowflakeArgumentsProvider {
        @Override
        protected List<Arguments> rawArguments(ExtensionContext context) {
            LinkedList<Arguments> samples = new LinkedList<Arguments>();
            samples.add(Arguments.of((Object[])new Object[]{"select {'a':3}::map(text, int);", "{\"a\":3}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'a':'za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144'}::map(text, text);", "{\"a\":\"za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'a':'bla'}::map(text, text);", "{\"a\":\"bla\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'1':'bla'}::map(int, text);", "{\"1\":\"bla\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'1':[1,2,3]}::map(int, ARRAY(int));", "{\"1\":[1,2,3]}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'1':{'string':'a'}}::map(int, OBJECT(string VARCHAR));", "{\"1\":{\"string\":\"a\"}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'1':{'string':'a'}}::map(int, map(string, string));", "{\"1\":{\"string\":\"a\"}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'1':[{'string':'a'},{'bla':'ble'}]}::map(int, array(map(string, string)));", "{\"1\":[{\"string\":\"a\"},{\"bla\":\"ble\"}]}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select [1,2,3]::array(int)", "[1,2,3]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select [{'a':'a'}, {'b':'b'}]::array(map(string, string))", "[{\"a\":\"a\"}, {\"b\":\"b\"}]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select [{'a':true}, {'b':false}]::array(map(string, boolean))", "[{\"a\":true}, {\"b\":false}]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select [{'string':'a'}, {'string':'b'}]::array(object(string varchar))", "[{\"string\":\"a\"}, {\"string\":\"b\"}]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':'a'}::object(string varchar)", "{\"string\":\"a\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'x':'a','b':'a','c':'a','d':'a','e':'a'}::object(x varchar,b varchar,c varchar,d varchar,e varchar)", "{\"x\":\"a\",\"b\":\"a\",\"c\":\"a\",\"d\":\"a\",\"e\":\"a\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':[1,2,3]}::object(string array(int))", "{\"string\":[1,2,3]}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':{'a':15}}::object(string object(a int))", "{\"string\":{\"a\":15}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':{'a':15}}::object(string map(string,int))", "{\"string\":{\"a\":15}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':{'a':{'b':15}}}::object(string object(a map(string, int)))", "{\"string\":{\"a\":{\"b\":15}}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'string':{'a':{'b':[{'c': 15}]}}}::object(string map(string, object(b array(object(c int)))))", "{\"string\":{\"a\":{\"b\":[{\"c\":15}]}}}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'ltz': '2024-05-20 11:22:33'::TIMESTAMP_LTZ}::object(ltz TIMESTAMP_LTZ)", "{\"ltz\":\"Mon, 20 May 2024 11:22:33 +0200\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'ntz': '2024-05-20 11:22:33'::TIMESTAMP_NTZ}::object(ntz TIMESTAMP_NTZ)", "{\"ntz\":\"Mon, 20 May 2024 11:22:33 Z\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'tz': '2024-05-20 11:22:33+0800'::TIMESTAMP_TZ}::object(tz TIMESTAMP_TZ)", "{\"tz\":\"Mon, 20 May 2024 11:22:33 +0800\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'date': '2024-05-20'::DATE}::object(date DATE)", "{\"date\":\"2024-05-20\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'time': '22:14:55'::TIME}::object(time TIME)", "{\"time\":\"22:14:55\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'bool': TRUE}::object(bool BOOLEAN)", "{\"bool\":true}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'bool': 'y'}::object(bool BOOLEAN)", "{\"bool\":true}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select {'binary': TO_BINARY('616263', 'HEX')}::object(binary BINARY)", "{\"binary\":\"616263\"}"}));
            samples.add(Arguments.of((Object[])new Object[]{"select [1,2,3]::VECTOR(INT, 3)", "[1,2,3]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select ['a','b','c']::ARRAY(varchar)", "[\"a\",\"b\",\"c\"]"}));
            samples.add(Arguments.of((Object[])new Object[]{"select ['a','b','c']::ARRAY(variant)", "[\"a\",\"b\",\"c\"]"}));
            return samples;
        }
    }
}

