/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.structuredtypes.sqldata;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Time;
import java.sql.Timestamp;
import net.snowflake.client.jdbc.SnowflakeColumn;
import net.snowflake.client.jdbc.structuredtypes.sqldata.SimpleClass;

public class AllTypesClass
implements SQLData {
    public static String ALL_TYPES_QUERY = "select {'string': 'a', 'b': 1, 's': 2, 'i': 3, 'l': 4, 'f': 1.1, 'd': 2.2, 'bd': 3.3, 'bool': true, 'timestamp_ltz': '2021-12-22 09:43:44'::TIMESTAMP_LTZ, 'timestamp_ntz': '2021-12-23 09:44:44'::TIMESTAMP_NTZ, 'timestamp_tz': '2021-12-24 09:45:45 +0800'::TIMESTAMP_TZ, 'date': '2023-12-24'::DATE, 'time': '12:34:56'::TIME, 'binary': TO_BINARY('616263', 'HEX'), 'simpleClass': {'string': 'b', 'intValue': 2}}::OBJECT(string VARCHAR, b TINYINT, s SMALLINT, i INTEGER, l BIGINT, f FLOAT, d DOUBLE, bd DOUBLE, bool BOOLEAN, timestamp_ltz TIMESTAMP_LTZ, timestamp_ntz TIMESTAMP_NTZ, timestamp_tz TIMESTAMP_TZ, date DATE, time TIME, binary BINARY, simpleClass OBJECT(string VARCHAR, intValue INTEGER))";
    private String string;
    private Byte b;
    private Short s;
    private Integer i;
    private Long l;
    private Float f;
    private Double d;
    private BigDecimal bd;
    private Boolean bool;
    @SnowflakeColumn(type="timestamp_ltz")
    private Timestamp timestampLtz;
    @SnowflakeColumn(type="timestamp_ntz")
    private Timestamp timestampNtz;
    @SnowflakeColumn(type="timestamp_tz")
    private Timestamp timestampTz;
    private Date date;
    private Time time;
    private byte[] binary;
    private SimpleClass simpleClass;

    public AllTypesClass() {
    }

    public AllTypesClass(String string, Byte b, Short s, Integer i, Long l, Float f, Double d, BigDecimal bd, Boolean bool, Timestamp timestampLtz, Timestamp timestampNtz, Timestamp timestampTz, Date date, Time time, byte[] binary, SimpleClass simpleClass) {
        this.string = string;
        this.b = b;
        this.s = s;
        this.i = i;
        this.l = l;
        this.f = f;
        this.d = d;
        this.bd = bd;
        this.bool = bool;
        this.timestampLtz = timestampLtz;
        this.timestampNtz = timestampNtz;
        this.timestampTz = timestampTz;
        this.date = date;
        this.time = time;
        this.binary = binary;
        this.simpleClass = simpleClass;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return null;
    }

    @Override
    public void readSQL(SQLInput sqlInput, String typeName) throws SQLException {
        this.string = sqlInput.readString();
        if (sqlInput.wasNull()) {
            this.string = null;
        }
        this.b = sqlInput.readByte();
        if (sqlInput.wasNull()) {
            this.b = null;
        }
        this.s = sqlInput.readShort();
        if (sqlInput.wasNull()) {
            this.s = null;
        }
        this.i = sqlInput.readInt();
        if (sqlInput.wasNull()) {
            this.i = null;
        }
        this.l = sqlInput.readLong();
        if (sqlInput.wasNull()) {
            this.l = null;
        }
        this.f = Float.valueOf(sqlInput.readFloat());
        if (sqlInput.wasNull()) {
            this.f = null;
        }
        this.d = sqlInput.readDouble();
        if (sqlInput.wasNull()) {
            this.d = null;
        }
        this.bd = sqlInput.readBigDecimal();
        this.bool = sqlInput.readBoolean();
        if (sqlInput.wasNull()) {
            this.bool = null;
        }
        this.timestampLtz = sqlInput.readTimestamp();
        this.timestampNtz = sqlInput.readTimestamp();
        this.timestampTz = sqlInput.readTimestamp();
        this.date = sqlInput.readDate();
        this.time = sqlInput.readTime();
        this.binary = sqlInput.readBytes();
        this.simpleClass = sqlInput.readObject(SimpleClass.class);
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeString(this.string);
        stream.writeByte(this.b);
        stream.writeShort(this.s);
        stream.writeInt(this.i);
        stream.writeLong(this.l);
        stream.writeFloat(this.f.floatValue());
        stream.writeDouble(this.d);
        stream.writeBigDecimal(this.bd);
        stream.writeBoolean(this.bool);
        stream.writeTimestamp(this.timestampLtz);
        stream.writeTimestamp(this.timestampNtz);
        stream.writeTimestamp(this.timestampTz);
        stream.writeDate(this.date);
        stream.writeTime(this.time);
        stream.writeBytes(this.binary);
        stream.writeObject(this.simpleClass);
    }

    public String getString() {
        return this.string;
    }

    public Byte getB() {
        return this.b;
    }

    public Short getS() {
        return this.s;
    }

    public Integer getI() {
        return this.i;
    }

    public Long getL() {
        return this.l;
    }

    public Float getF() {
        return this.f;
    }

    public Double getD() {
        return this.d;
    }

    public BigDecimal getBd() {
        return this.bd;
    }

    public Boolean getBool() {
        return this.bool;
    }

    public Timestamp getTimestampLtz() {
        return this.timestampLtz;
    }

    public Timestamp getTimestampNtz() {
        return this.timestampNtz;
    }

    public Timestamp getTimestampTz() {
        return this.timestampTz;
    }

    public Date getDate() {
        return this.date;
    }

    public Time getTime() {
        return this.time;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public SimpleClass getSimpleClass() {
        return this.simpleClass;
    }
}

