/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import net.snowflake.client.loader.Loader;
import net.snowflake.client.loader.LoaderBase;
import net.snowflake.client.loader.Operation;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.TestDataConfigBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="loader")
public class LoaderLatestIT
extends LoaderBase {
    @Test
    public void testLoaderUpsert() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        TestDataConfigBuilder tdcbUpsert = new TestDataConfigBuilder(testConnection, putConnection);
        tdcbUpsert.setOperation(Operation.UPSERT).setTruncateTable(false).setColumns(Arrays.asList("ID", "C1", "C2", "C3", "C4", "C5")).setKeys(Collections.singletonList("ID"));
        StreamLoader loader = tdcbUpsert.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcbUpsert.getListener();
        loader.start();
        Date d = new Date();
        Object[] ups = new Object[]{10001, "inserted\\,", "something", 16.26873779296875, d, "{}"};
        loader.submitRow(ups);
        ups = new Object[]{39, "modified", "something", 40.1, d, "{}"};
        loader.submitRow(ups);
        loader.finish();
        MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"submitted row", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"updated/inserted", (Object)listener.updated.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        try (ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT C1, C4, C3 FROM \"%s\" WHERE ID=10001", "LOADER_test_TABLE"));){
            Assertions.assertTrue((boolean)rs.next());
            MatcherAssert.assertThat((String)"C1 is not correct", (Object)rs.getString("C1"), (Matcher)CoreMatchers.equalTo((Object)"inserted\\,"));
            long l = rs.getTimestamp("C4").getTime();
            MatcherAssert.assertThat((String)"C4 is not correct", (Object)l, (Matcher)CoreMatchers.equalTo((Object)d.getTime()));
            MatcherAssert.assertThat((String)"C3 is not correct", (Object)Double.toHexString(rs.getDouble("C3")), (Matcher)CoreMatchers.equalTo((Object)"0x1.044ccp4"));
        }
        rs = testConnection.createStatement().executeQuery(String.format("SELECT C1 AS N FROM \"%s\" WHERE ID=39", "LOADER_test_TABLE"));
        try {
            Assertions.assertTrue((boolean)rs.next());
            MatcherAssert.assertThat((String)"N is not correct", (Object)rs.getString("N"), (Matcher)CoreMatchers.equalTo((Object)"modified"));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Test
    public void testLoaderUpsertWithErrorAndRollback() throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.populate();
        try (PreparedStatement pstmt = testConnection.prepareStatement(String.format("INSERT INTO \"%s\"(ID,C1,C2,C3,C4,C5) SELECT column1, column2, column3, column4, column5, parse_json(column6) FROM VALUES(?,?,?,?,?,?)", "LOADER_test_TABLE"));){
            pstmt.setInt(1, 10001);
            pstmt.setString(2, "inserted\\,");
            pstmt.setString(3, "something");
            pstmt.setDouble(4, 16.26873779296875);
            pstmt.setDate(5, new java.sql.Date(new Date().getTime()));
            pstmt.setObject(6, "{}");
            pstmt.execute();
            testConnection.commit();
            TestDataConfigBuilder tdcbUpsert = new TestDataConfigBuilder(testConnection, putConnection);
            tdcbUpsert.setOperation(Operation.UPSERT).setTruncateTable(false).setStartTransaction(true).setPreserveStageFile(true).setColumns(Arrays.asList("ID", "C1", "C2", "C3", "C4", "C5")).setKeys(Collections.singletonList("ID"));
            StreamLoader loader = tdcbUpsert.getStreamLoader();
            TestDataConfigBuilder.ResultListener listener = tdcbUpsert.getListener();
            listener.throwOnError = true;
            loader.start();
            try {
                Object[] noerr = new Object[]{"10001", "inserted", "something", "42", new Date(), "{}"};
                loader.submitRow(noerr);
                Object[] err = new Object[]{"10002-", "inserted", "something", "42-", new Date(), "{}"};
                loader.submitRow(err);
                loader.finish();
                Assertions.fail((String)"Test must raise Loader.DataError exception");
            }
            catch (Loader.DataError e) {
                MatcherAssert.assertThat((String)"error message", (Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"10002-"), CoreMatchers.containsString((String)"not recognized")}));
            }
            MatcherAssert.assertThat((String)"processed", (Object)listener.processed.get(), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"submitted row", (Object)listener.getSubmittedRowCount(), (Matcher)CoreMatchers.equalTo((Object)2));
            MatcherAssert.assertThat((String)"updated/inserted", (Object)listener.updated.get(), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"error count", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)2));
            MatcherAssert.assertThat((String)"error record count", (Object)listener.getErrorRecordCount(), (Matcher)CoreMatchers.equalTo((Object)1));
            try (ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT COUNT(*) AS N FROM \"%s\"", "LOADER_test_TABLE"));){
                Assertions.assertTrue((boolean)rs.next());
                MatcherAssert.assertThat((String)"N", (Object)rs.getInt("N"), (Matcher)CoreMatchers.equalTo((Object)10001));
            }
            rs = testConnection.createStatement().executeQuery(String.format("SELECT C3 FROM \"%s\" WHERE id=10001", "LOADER_test_TABLE"));
            try {
                Assertions.assertTrue((boolean)rs.next());
                MatcherAssert.assertThat((String)"C3. No commit should happen", (Object)Double.toHexString(rs.getDouble("C3")), (Matcher)CoreMatchers.equalTo((Object)"0x1.044ccp4"));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testKeyClusteringTable() throws Exception {
        String targetTableName = "CLUSTERED_TABLE";
        try (Statement statement = testConnection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE \"%s\" (ID int, \"Column1\" varchar(255), \"Column2\" varchar(255))", targetTableName));
            statement.execute(String.format("alter table %s cluster by (ID, \"Column1\", \"Column2\")", targetTableName));
            TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
            tdcb.setTableName(targetTableName).setColumns(Arrays.asList("ID", "Column1"));
            StreamLoader loader = tdcb.getStreamLoader();
            loader.start();
            for (int i = 0; i < 5; ++i) {
                Object[] row = new Object[]{i, "foo_" + i};
                loader.submitRow(row);
            }
            loader.finish();
            try (ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT * FROM \"%s\" ORDER BY \"Column1\"", targetTableName));){
                Assertions.assertTrue((boolean)rs.next());
                MatcherAssert.assertThat((String)"The first id", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)0));
                MatcherAssert.assertThat((String)"The first str", (Object)rs.getString(2), (Matcher)CoreMatchers.equalTo((Object)"foo_0"));
            }
        }
    }
}

