/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.loader;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.client.loader.LoaderBase;
import net.snowflake.client.loader.StreamLoader;
import net.snowflake.client.loader.TestDataConfigBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="loader")
public class LoaderTimestampIT
extends LoaderBase {
    @Test
    public void testLoadTimestamp() throws Exception {
        String targetTableName = "LOADER_TEST_TIMESTAMP";
        try (Statement statement = testConnection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s (ID int, C1 varchar(255), C2 timestamp_ntz)", "LOADER_TEST_TIMESTAMP"));
            Object[] testData = new Object[]{new Date(), Timestamp.valueOf("0001-01-01 08:00:00"), java.sql.Date.valueOf("2001-01-02")};
            for (int i = 0; i < 2; ++i) {
                TimeZone targetTimeZone;
                TimeZone originalTimeZone;
                boolean useLocalTimezone = false;
                if (i == 0) {
                    useLocalTimezone = true;
                    originalTimeZone = TimeZone.getDefault();
                    targetTimeZone = TimeZone.getTimeZone("America/Los_Angeles");
                } else {
                    originalTimeZone = TimeZone.getTimeZone("UTC");
                    targetTimeZone = TimeZone.getTimeZone("UTC");
                }
                for (Object testTs : testData) {
                    this._testLoadTimestamp("LOADER_TEST_TIMESTAMP", originalTimeZone, targetTimeZone, testTs, useLocalTimezone, false);
                }
            }
        }
    }

    private void _testLoadTimestamp(String targetTableName, TimeZone originalTimeZone, TimeZone targetTimeZone, Object testTs, boolean useLocalTimeZone, boolean mapTimeToTimestamp) throws Exception {
        TestDataConfigBuilder tdcb = new TestDataConfigBuilder(testConnection, putConnection);
        tdcb.setStartTransaction(true).setTruncateTable(true).setTableName(targetTableName).setUseLocalTimezone(useLocalTimeZone).setMapTimeToTimestamp(mapTimeToTimestamp).setColumns(Arrays.asList("ID", "C1", "C2"));
        StreamLoader loader = tdcb.getStreamLoader();
        TestDataConfigBuilder.ResultListener listener = tdcb.getListener();
        TimeZone.setDefault(targetTimeZone);
        loader.start();
        for (int i = 0; i < 5; ++i) {
            Object[] row = new Object[]{i, "foo_" + i, testTs};
            loader.submitRow(row);
        }
        loader.finish();
        TimeZone.setDefault(originalTimeZone);
        MatcherAssert.assertThat((String)"Loader detected errors", (Object)listener.getErrorCount(), (Matcher)CoreMatchers.equalTo((Object)0));
        try (ResultSet rs = testConnection.createStatement().executeQuery(String.format("SELECT * FROM \"%s\"", targetTableName));){
            Assertions.assertTrue((boolean)rs.next());
            Timestamp ts = rs.getTimestamp("C2");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            sdf.setTimeZone(targetTimeZone);
            String currentTsStr = sdf.format(testTs);
            sdf.setTimeZone(originalTimeZone);
            String retrievedTsStr = sdf.format(new Date(ts.getTime()));
            MatcherAssert.assertThat((String)"Input and retrieved timestamp are different", (Object)retrievedTsStr, (Matcher)CoreMatchers.equalTo((Object)currentTsStr));
        }
    }

    @Test
    public void testLoadTimestampV1() throws Exception {
        String targetTableName = "LOADER_TEST_TIMESTAMP_V1";
        try (Statement statement = testConnection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s (ID int, C1 varchar(255), C2 timestamp_ntz)", "LOADER_TEST_TIMESTAMP_V1"));
            Object[] testData = new Object[]{new Time(1502931205000L), Time.valueOf("12:34:56")};
            for (int i = 0; i < 2; ++i) {
                TimeZone targetTimeZone;
                TimeZone originalTimeZone;
                boolean useLocalTimezone;
                if (i == 0) {
                    useLocalTimezone = true;
                    originalTimeZone = TimeZone.getDefault();
                    targetTimeZone = TimeZone.getTimeZone("America/Los_Angeles");
                } else {
                    useLocalTimezone = false;
                    originalTimeZone = TimeZone.getTimeZone("UTC");
                    targetTimeZone = TimeZone.getTimeZone("UTC");
                }
                for (Object testTs : testData) {
                    this._testLoadTimestamp("LOADER_TEST_TIMESTAMP_V1", originalTimeZone, targetTimeZone, testTs, useLocalTimezone, true);
                }
            }
        }
    }
}

