/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public abstract class AbstractLoggerIT {
    public static final String fakeCreds = "credentials=(aws_key_id='abc123' aws_secret_key='rtyuiop')";

    @BeforeEach
    void setUp() {
        this.setLogLevel(LogLevel.TRACE);
    }

    @Test
    public void TestLambdaIsNotEvaluatedIfMsgIsNotLogged() {
        this.setLogLevel(LogLevel.ERROR);
        this.logMessage(LogLevel.TRACE, "Value: {}", () -> {
            Assertions.fail((String)"Lambda expression evaluated even though message is not logged");
            return 0;
        });
    }

    @Test
    public void TestWithSingleLambdaArg() {
        this.logAndVerifyAtEachLogLevel("Value: 5", "Value: {}", () -> 5);
    }

    @Test
    public void TestWithMultipleLambdaArgs() {
        int a = 2;
        int b = 3;
        int c = 5;
        this.logAndVerifyAtEachLogLevel(String.format("Sum of %s and %s is %s", a, b + c, a + b + c), "Sum of {} and {} is {}", a, () -> b + c, () -> a + b + c);
    }

    @Test
    public void TestWithNullArgs() {
        this.logAndVerifyAtEachLogLevel("Values are null and null", "Values are {} and {}", null, () -> null);
    }

    @Test
    public void TestWithIsMaskedTrue() {
        for (LogLevel level : LogLevel.values()) {
            this.logMessage(level, fakeCreds, true);
            String loggedMsg = this.getLoggedMessage();
            String expectedMessage = "credentials=(aws_key_id='****' aws_secret_key='****')";
            Assertions.assertEquals((Object)expectedMessage, (Object)loggedMsg);
        }
    }

    @Test
    public void TestWithIsMaskedFalse() {
        for (LogLevel level : LogLevel.values()) {
            this.logMessage(level, fakeCreds, false);
            String loggedMsg = this.getLoggedMessage();
            Assertions.assertEquals((Object)fakeCreds, (Object)loggedMsg);
        }
    }

    @Test
    public void testWithThrowable() {
        for (LogLevel level : LogLevel.values()) {
            this.logMessage(level, "sample message", null);
        }
    }

    private void logAndVerifyAtEachLogLevel(String expectedLogMsg, String msg, Object ... args) {
        for (LogLevel level : LogLevel.values()) {
            this.clearLastLoggedMessageAndLevel();
            this.logMessage(level, msg, args);
            String loggedMsg = this.getLoggedMessage();
            Assertions.assertEquals((Object)expectedLogMsg, (Object)loggedMsg, (String)String.format("Message logged did not match expected value. expected=%s actual=%s", expectedLogMsg, loggedMsg));
            LogLevel loggedMsgLevel = this.getLoggedMessageLevel();
            Assertions.assertEquals((Object)((Object)level), (Object)((Object)loggedMsgLevel), (String)String.format("Message was not logged at expected log level. expected=%s actual=%s", level.toString(), loggedMsgLevel.toString()));
        }
    }

    abstract void logMessage(LogLevel var1, String var2, Object ... var3);

    abstract void logMessage(LogLevel var1, String var2, boolean var3);

    abstract void logMessage(LogLevel var1, String var2, Throwable var3);

    abstract void setLogLevel(LogLevel var1);

    abstract String getLoggedMessage();

    abstract LogLevel getLoggedMessageLevel();

    abstract void clearLastLoggedMessageAndLevel();

    protected static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

