/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.snowflake.client.log.JDK14JCLWrapper;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFFormatter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class JDK14JCLWrapperLatestIT {
    JDK14JCLWrapper wrapper = new JDK14JCLWrapper(JDK14JCLWrapperLatestIT.class.getName());
    JDK14Logger logger = (JDK14Logger)this.wrapper.getLogger();
    private String lastLogMessage = null;
    private Level logLevelToRestore = null;
    private TestJDK14LogHandler handler = new TestJDK14LogHandler((Formatter)new SFFormatter());

    @BeforeEach
    public void setUp() {
        JDK14JCLWrapperLatestIT jDK14JCLWrapperLatestIT = this;
        this.logLevelToRestore = jDK14JCLWrapperLatestIT.logger.getLevel();
        JDK14Logger.setLevel((Level)Level.FINEST);
        JDK14Logger.addHandler((Handler)this.handler);
        JDK14Logger.setUseParentHandlers((boolean)false);
    }

    @AfterEach
    public void tearDown() {
        JDK14Logger.setUseParentHandlers((boolean)true);
        JDK14Logger.setLevel((Level)this.logLevelToRestore);
        JDK14Logger.removeHandler((Handler)this.handler);
    }

    String getLoggedMessage() {
        return this.lastLogMessage;
    }

    private void testLogMessagesWithThrowable(LogLevel level, String message, Throwable t) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message, t);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message, t);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message, t);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message, t);
            }
        }
        Assertions.assertEquals((Object)message, (Object)this.getLoggedMessage());
    }

    private void testLogMessagesNoThrowable(LogLevel level, String message) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message);
            }
        }
        Assertions.assertEquals((Object)message, (Object)this.getLoggedMessage());
    }

    private void testNullLogMessagesWithThrowable(LogLevel level, String message, Throwable t) {
        switch (level) {
            case TRACE: {
                this.wrapper.trace((Object)message, t);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message, t);
            }
        }
        Assertions.assertEquals(null, (Object)this.getLoggedMessage());
    }

    private void testNullLogMessagesNoThrowable(LogLevel level, String message) {
        switch (level) {
            case TRACE: {
                this.wrapper.trace((Object)message);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message);
            }
        }
        Assertions.assertEquals(null, (Object)this.getLoggedMessage());
    }

    @Test
    public void testNullLogMessages() {
        LogLevel[] levelsWithNoOutput;
        LogLevel[] levelsDisplayingOutput = new LogLevel[]{LogLevel.FATAL, LogLevel.ERROR, LogLevel.WARN, LogLevel.INFO};
        for (LogLevel level : levelsWithNoOutput = new LogLevel[]{LogLevel.TRACE, LogLevel.DEBUG}) {
            this.testNullLogMessagesWithThrowable(level, "sample message", null);
            this.testNullLogMessagesNoThrowable(level, "sample message");
        }
        for (LogLevel level : levelsDisplayingOutput) {
            this.testLogMessagesWithThrowable(level, "sample message", null);
            this.testLogMessagesNoThrowable(level, "sample message");
        }
    }

    @Test
    public void testEnabledMessaging() {
        Assertions.assertFalse((boolean)this.wrapper.isTraceEnabled());
        Assertions.assertFalse((boolean)this.wrapper.isDebugEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isInfoEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isWarnEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isErrorEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isFatalEnabled());
    }

    private static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    private class TestJDK14LogHandler
    extends Handler {
        TestJDK14LogHandler(Formatter formatter) {
            super.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord record) {
            JDK14JCLWrapperLatestIT.this.lastLogMessage = this.getFormatter().formatMessage(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

