/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.StdErrOutThresholdAwareConsoleHandler;
import net.snowflake.client.log.StdOutConsoleHandler;
import net.snowflake.client.log.UnknownJavaUtilLoggingLevelException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class JDK14LoggerConsoleHandlerOverrideLatestIT
extends BaseJDBCTest {
    private static final PrintStream standardOut = System.out;
    private static final PrintStream standardErr = System.err;
    private static final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private static final ByteArrayOutputStream errStream = new ByteArrayOutputStream();
    private static final String errorMessage = "error message 1";
    private static final String warningMessage = "warning message 1";
    private static final String infoMessage = "info message 1";
    private static final String debugMessage = "debug message 1";

    @BeforeAll
    public static void replaceStreams() {
        System.setOut(new PrintStream(outputStream));
        System.setErr(new PrintStream(errStream));
    }

    @AfterAll
    public static void resetStreams() {
        System.setOut(standardOut);
        System.setErr(standardErr);
    }

    @Test
    public void shouldLogAllToStdErr() throws Exception {
        Properties paramProperties = new Properties();
        JDK14LoggerConsoleHandlerOverrideLatestIT.connectAndLog(paramProperties);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        Assertions.assertTrue((handlers.length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Arrays.stream(handlers).anyMatch(h -> h instanceof ConsoleHandler));
        System.out.flush();
        System.err.flush();
        Assertions.assertEquals((Object)"", (Object)outputStream.toString());
    }

    @Test
    public void shouldOverrideConsoleLoggerToStdOut() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("JAVA_LOGGING_CONSOLE_STD_OUT", (Object)true);
        JDK14LoggerConsoleHandlerOverrideLatestIT.connectAndLog(paramProperties);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        Assertions.assertTrue((handlers.length > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)Arrays.stream(handlers).anyMatch(h -> h instanceof ConsoleHandler));
        Assertions.assertTrue((boolean)Arrays.stream(handlers).anyMatch(h -> h instanceof StdOutConsoleHandler));
        System.out.flush();
        System.err.flush();
        String outString = outputStream.toString();
        Assertions.assertTrue((boolean)outString.contains(errorMessage), () -> "STDOUT: " + outString);
        Assertions.assertTrue((boolean)outString.contains(warningMessage), () -> "STDOUT: " + outString);
        Assertions.assertTrue((boolean)outString.contains(infoMessage), () -> "STDOUT: " + outString);
        Assertions.assertFalse((boolean)outString.contains(debugMessage), () -> "STDOUT: " + outString);
    }

    @Test
    public void shouldOverrideConsoleLoggerWithSpecificThreshold() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("JAVA_LOGGING_CONSOLE_STD_OUT", (Object)true);
        paramProperties.put("JAVA_LOGGING_CONSOLE_STD_OUT_THRESHOLD", "WARNING");
        JDK14LoggerConsoleHandlerOverrideLatestIT.connectAndLog(paramProperties);
        Handler[] handlers = Logger.getLogger("").getHandlers();
        Assertions.assertTrue((handlers.length > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)Arrays.stream(handlers).anyMatch(h -> h instanceof ConsoleHandler));
        Assertions.assertTrue((boolean)Arrays.stream(handlers).anyMatch(h -> h instanceof StdErrOutThresholdAwareConsoleHandler && ((StdErrOutThresholdAwareConsoleHandler)h).getThreshold().equals(Level.WARNING)));
        System.out.flush();
        System.err.flush();
        String outString = outputStream.toString();
        Assertions.assertFalse((boolean)outString.contains(errorMessage), () -> "STDOUT: " + outString);
        Assertions.assertTrue((boolean)outString.contains(warningMessage), () -> "STDOUT: " + outString);
        Assertions.assertTrue((boolean)outString.contains(infoMessage), () -> "STDOUT: " + outString);
        Assertions.assertFalse((boolean)outString.contains(debugMessage), () -> "STDOUT: " + outString);
    }

    private static void connectAndLog(Properties paramProperties) throws SQLException {
        try (Connection con = JDK14LoggerConsoleHandlerOverrideLatestIT.getConnection(paramProperties);){
            SFLogger logger = SFLoggerFactory.getLogger(JDK14LoggerConsoleHandlerOverrideLatestIT.class);
            logger.error(errorMessage, new Object[0]);
            logger.warn(warningMessage, new Object[0]);
            logger.info(infoMessage, new Object[0]);
            logger.debug(debugMessage, new Object[0]);
        }
    }

    @Test
    public void shouldThrowExceptionOnUnknownLevel() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("JAVA_LOGGING_CONSOLE_STD_OUT", (Object)true);
        paramProperties.put("JAVA_LOGGING_CONSOLE_STD_OUT_THRESHOLD", "UNKNOWN");
        Assertions.assertThrows(UnknownJavaUtilLoggingLevelException.class, () -> JDK14LoggerConsoleHandlerOverrideLatestIT.getConnection(paramProperties));
    }

    @BeforeEach
    public void reset() {
        JDK14Logger.resetToDefaultConsoleHandler();
        outputStream.reset();
        errStream.reset();
    }
}

