/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.snowflake.client.log.AbstractLoggerIT;
import net.snowflake.client.log.JDK14Logger;
import net.snowflake.client.log.SFFormatter;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;

@Tag(value="core")
public class JDK14LoggerLatestIT
extends AbstractLoggerIT {
    private static final JDK14Logger LOGGER = new JDK14Logger(JDK14LoggerLatestIT.class.getName());
    private static Level logLevelToRestore;
    private static final Logger internalLogger;
    private static boolean useParentHandlersToRestore;
    private TestJDK14LogHandler handler = new TestJDK14LogHandler((Formatter)new SFFormatter());
    private String lastLogMessage = null;
    private Level lastLogMessageLevel = null;

    @BeforeAll
    public static void oneTimeSetUp() {
        logLevelToRestore = internalLogger.getLevel();
        useParentHandlersToRestore = internalLogger.getUseParentHandlers();
        internalLogger.setUseParentHandlers(false);
    }

    @AfterAll
    public static void oneTimeTearDown() {
        internalLogger.setLevel(logLevelToRestore);
        internalLogger.setUseParentHandlers(useParentHandlersToRestore);
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        internalLogger.addHandler(this.handler);
    }

    @AfterEach
    public void tearDown() {
        internalLogger.removeHandler(this.handler);
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, Object ... args) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, args);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, args);
                break;
            }
            case INFO: {
                LOGGER.info(message, args);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, args);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, args);
            }
        }
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, boolean isMasked) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, isMasked);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, isMasked);
                break;
            }
            case INFO: {
                LOGGER.info(message, isMasked);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, isMasked);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, isMasked);
            }
        }
    }

    @Override
    void logMessage(AbstractLoggerIT.LogLevel level, String message, Throwable throwable) {
        switch (level) {
            case ERROR: {
                LOGGER.error(message, throwable);
                break;
            }
            case WARNING: {
                LOGGER.warn(message, throwable);
                break;
            }
            case INFO: {
                LOGGER.info(message, throwable);
                break;
            }
            case DEBUG: {
                LOGGER.debug(message, throwable);
                break;
            }
            case TRACE: {
                LOGGER.trace(message, throwable);
            }
        }
    }

    @Override
    void setLogLevel(AbstractLoggerIT.LogLevel level) {
        internalLogger.setLevel(this.toJavaCoreLoggerLevel(level));
    }

    @Override
    String getLoggedMessage() {
        return this.lastLogMessage;
    }

    @Override
    AbstractLoggerIT.LogLevel getLoggedMessageLevel() {
        return this.fromJavaCoreLoggerLevel(this.lastLogMessageLevel);
    }

    @Override
    void clearLastLoggedMessageAndLevel() {
        this.lastLogMessage = null;
        this.lastLogMessageLevel = null;
    }

    private Level toJavaCoreLoggerLevel(AbstractLoggerIT.LogLevel level) {
        switch (level) {
            case ERROR: {
                return Level.SEVERE;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case TRACE: {
                return Level.FINEST;
            }
        }
        return Level.FINEST;
    }

    private AbstractLoggerIT.LogLevel fromJavaCoreLoggerLevel(Level level) {
        if (Level.SEVERE.equals(level)) {
            return AbstractLoggerIT.LogLevel.ERROR;
        }
        if (Level.WARNING.equals(level)) {
            return AbstractLoggerIT.LogLevel.WARNING;
        }
        if (Level.INFO.equals(level)) {
            return AbstractLoggerIT.LogLevel.INFO;
        }
        if (Level.FINE.equals(level) || Level.FINER.equals(level)) {
            return AbstractLoggerIT.LogLevel.DEBUG;
        }
        if (Level.FINEST.equals(level) || Level.ALL.equals(level)) {
            return AbstractLoggerIT.LogLevel.TRACE;
        }
        throw new IllegalArgumentException(String.format("Specified log level '%s' not supported", level.toString()));
    }

    static {
        internalLogger = Logger.getLogger(JDK14LoggerLatestIT.class.getName());
        useParentHandlersToRestore = true;
    }

    private class TestJDK14LogHandler
    extends Handler {
        TestJDK14LogHandler(Formatter formatter) {
            super.setFormatter(formatter);
        }

        @Override
        public void publish(LogRecord record) {
            JDK14LoggerLatestIT.this.lastLogMessage = this.getFormatter().formatMessage(record);
            JDK14LoggerLatestIT.this.lastLogMessageLevel = record.getLevel();
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

