/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.snowflake.client.log.SFFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SFFormatterTest {
    private static final long TIME_DIFFERENCE_BOUNDARY = 600000L;
    private static final int STRESS_TEST_ITERATION = 2000;
    private LRGenerator recordGenerator;

    @BeforeEach
    public void setUp() {
        this.recordGenerator = new LRGenerator(SFFormatter.CLASS_NAME_PREFIX + "TestClass", "TestMethod");
        this.recordGenerator.setFormatter((Formatter)new SFFormatter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUTCTimeStampSimple() throws ParseException {
        TimeZone originalTz = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/Berlin"));
        try {
            String record = this.recordGenerator.generateLogRecordString(Level.INFO, "TestMessage");
            Date date = this.extractDate(record);
            long nowInMs = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
            Assertions.assertTrue((nowInMs - date.getTime() < 600000L ? 1 : 0) != 0, (String)"Time difference boundary should be less than 600000ms");
        }
        finally {
            TimeZone.setDefault(originalTz);
        }
    }

    @Test
    public void testUTCTimeStampStress() throws ParseException {
        for (int i = 0; i < 2000; ++i) {
            this.testUTCTimeStampSimple();
        }
    }

    private Date extractDate(String string) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        df.setCalendar(cal);
        Date date = df.parse(string);
        return date;
    }

    private class LRGenerator {
        private String srcClassName;
        private String srcMethodName;
        private Formatter formatter;

        public LRGenerator(String srcClassName, String srcMethodName) {
            this.srcClassName = srcClassName;
            this.srcMethodName = srcMethodName;
            this.formatter = null;
        }

        public LogRecord generateLogRecord(Level level, String message) {
            LogRecord record = new LogRecord(Level.INFO, "null");
            record.setSourceClassName(this.srcClassName);
            record.setSourceMethodName(this.srcMethodName);
            return record;
        }

        public String generateLogRecordString(Level level, String message) {
            return this.formatter.format(this.generateLogRecord(level, message));
        }

        public void setFormatter(Formatter formatter) {
            this.formatter = formatter;
        }
    }
}

