/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import net.snowflake.client.log.SLF4JJCLWrapper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class SLF4JJJCLWrapperLatestIT {
    private String lastLogMessage = null;
    private Level levelToRestore = null;
    SLF4JJCLWrapper wrapper = new SLF4JJCLWrapper(SLF4JJJCLWrapperLatestIT.class.getName());
    Logger logger = (Logger)this.wrapper.getLogger();
    private final Appender<ILoggingEvent> testAppender = new TestAppender();

    String getLoggedMessage() {
        return this.lastLogMessage;
    }

    @BeforeEach
    public void setUp() {
        this.levelToRestore = this.logger.getLevel();
        if (!this.testAppender.isStarted()) {
            this.testAppender.start();
        }
        this.logger.setLevel(Level.TRACE);
        this.logger.addAppender(this.testAppender);
    }

    @AfterEach
    public void tearDown() {
        this.logger.setLevel(this.levelToRestore);
        this.logger.detachAppender(this.testAppender);
    }

    private void testNullLogMessagesWithThrowable(LogLevel level, String message, Throwable t) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message, t);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message, t);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message, t);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message, t);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message, t);
                break;
            }
            case TRACE: {
                this.wrapper.trace((Object)message, t);
            }
        }
        Assertions.assertEquals(null, (Object)this.getLoggedMessage());
    }

    private void testNullLogMessagesNoThrowable(LogLevel level, String message) {
        switch (level) {
            case FATAL: {
                this.wrapper.fatal((Object)message);
                break;
            }
            case ERROR: {
                this.wrapper.error((Object)message);
                break;
            }
            case WARN: {
                this.wrapper.warn((Object)message);
                break;
            }
            case INFO: {
                this.wrapper.info((Object)message);
                break;
            }
            case DEBUG: {
                this.wrapper.debug((Object)message);
                break;
            }
            case TRACE: {
                this.wrapper.trace((Object)message);
            }
        }
        Assertions.assertEquals(null, (Object)this.getLoggedMessage());
    }

    @Test
    public void testNullLogMessages() {
        for (LogLevel level : LogLevel.values()) {
            this.testNullLogMessagesWithThrowable(level, "sample message", null);
            this.testNullLogMessagesNoThrowable(level, "sample message");
        }
    }

    @Test
    public void testEnabledMessaging() {
        Assertions.assertFalse((boolean)this.wrapper.isTraceEnabled());
        Assertions.assertFalse((boolean)this.wrapper.isDebugEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isInfoEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isWarnEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isErrorEnabled());
        Assertions.assertTrue((boolean)this.wrapper.isFatalEnabled());
    }

    private static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    private class TestAppender
    extends AppenderBase<ILoggingEvent> {
        private TestAppender() {
        }

        public void append(ILoggingEvent event) {
            SLF4JJJCLWrapperLatestIT.this.lastLogMessage = event.getFormattedMessage();
        }
    }
}

