/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.util;

import java.util.concurrent.TimeUnit;
import net.snowflake.client.util.Stopwatch;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StopwatchTest {
    Stopwatch stopwatch = new Stopwatch();

    @BeforeEach
    public void before() {
        this.stopwatch = new Stopwatch();
    }

    @Test
    public void testGetMillisWhenStopped() throws InterruptedException {
        this.stopwatch.start();
        TimeUnit.MILLISECONDS.sleep(20L);
        this.stopwatch.stop();
        MatcherAssert.assertThat((Object)this.stopwatch.elapsedMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(10L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(500L))));
    }

    @Test
    public void testGetMillisWithoutStopping() throws InterruptedException {
        this.stopwatch.start();
        TimeUnit.MILLISECONDS.sleep(100L);
        MatcherAssert.assertThat((Object)this.stopwatch.elapsedMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(10L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(500L))));
    }

    @Test
    public void testShouldBeStarted() {
        this.stopwatch.start();
        Assertions.assertTrue((boolean)this.stopwatch.isStarted());
    }

    @Test
    public void testShouldBeStopped() {
        Assertions.assertFalse((boolean)this.stopwatch.isStarted());
    }

    @Test
    public void testThrowsExceptionWhenStartedTwice() {
        this.stopwatch.start();
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.stopwatch.start());
        Assertions.assertTrue((boolean)e.getMessage().contains("Stopwatch is already running"));
    }

    @Test
    public void testThrowsExceptionWhenStoppedTwice() {
        this.stopwatch.start();
        this.stopwatch.stop();
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.stopwatch.stop());
        Assertions.assertTrue((boolean)e.getMessage().contains("Stopwatch is already stopped"));
    }

    @Test
    public void testThrowsExceptionWhenStoppedWithoutStarting() {
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.stopwatch.stop());
        Assertions.assertTrue((boolean)e.getMessage().contains("Stopwatch has not been started"));
    }

    @Test
    public void testThrowsExceptionWhenElapsedMillisWithoutStarting() {
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.stopwatch.elapsedMillis());
        Assertions.assertTrue((boolean)e.getMessage().contains("Stopwatch has not been started"));
    }

    @Test
    public void testShouldReset() {
        this.stopwatch.start();
        Assertions.assertTrue((boolean)this.stopwatch.isStarted());
        this.stopwatch.reset();
        Assertions.assertFalse((boolean)this.stopwatch.isStarted());
    }

    @Test
    public void testShouldRestart() {
        this.stopwatch.start();
        Assertions.assertTrue((boolean)this.stopwatch.isStarted());
        this.stopwatch.stop();
        Assertions.assertFalse((boolean)this.stopwatch.isStarted());
        this.stopwatch.restart();
        Assertions.assertTrue((boolean)this.stopwatch.isStarted());
    }
}

