/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.google.common.base.Strings;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFLoginOutput;
import net.snowflake.client.core.SecureStorageAppleManager;
import net.snowflake.client.core.SecureStorageLinuxManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.SecureStorageWindowsManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class CredentialManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(CredentialManager.class);
    private SecureStorageManager secureStorageManager;
    private static final String ID_TOKEN = "ID_TOKEN";
    private static final String MFA_TOKEN = "MFATOKEN";

    private CredentialManager() {
        this.initSecureStorageManager();
    }

    private void initSecureStorageManager() {
        try {
            if (Constants.getOS() == Constants.OS.MAC) {
                this.secureStorageManager = SecureStorageAppleManager.builder();
            } else if (Constants.getOS() == Constants.OS.WINDOWS) {
                this.secureStorageManager = SecureStorageWindowsManager.builder();
            } else if (Constants.getOS() == Constants.OS.LINUX) {
                this.secureStorageManager = SecureStorageLinuxManager.getInstance();
            } else {
                logger.error("Unsupported Operating System. Expected: OSX, Windows, Linux", false);
            }
        }
        catch (NoClassDefFoundError error) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
        }
    }

    void resetSecureStorageManager() {
        logger.debug("Resetting the secure storage manager", new Object[0]);
        this.initSecureStorageManager();
    }

    void injectSecureStorageManager(SecureStorageManager manager) {
        logger.debug("Injecting secure storage manager", new Object[0]);
        this.secureStorageManager = manager;
    }

    public static CredentialManager getInstance() {
        return CredentialManagerHolder.INSTANCE;
    }

    void fillCachedIdToken(SFLoginInput loginInput) throws SFException {
        logger.debug("Looking for cached id token for user: {}, host: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl());
        this.fillCachedCredential(loginInput, ID_TOKEN);
    }

    void fillCachedMfaToken(SFLoginInput loginInput) throws SFException {
        logger.debug("Looking for cached mfa token for user: {}, host: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl());
        this.fillCachedCredential(loginInput, MFA_TOKEN);
    }

    synchronized void fillCachedCredential(SFLoginInput loginInput, String credType) throws SFException {
        if (this.secureStorageManager == null) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
            return;
        }
        String cred = null;
        try {
            cred = this.secureStorageManager.getCredential(loginInput.getHostFromServerUrl(), loginInput.getUserName(), credType);
        }
        catch (NoClassDefFoundError error) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
            return;
        }
        if (cred == null) {
            logger.debug("Retrieved {} is null", credType);
        }
        if (credType == ID_TOKEN) {
            logger.debug("Setting {}id token for user: {}, host: {}", cred == null ? "null " : "", loginInput.getUserName(), loginInput.getHostFromServerUrl());
            loginInput.setIdToken(cred);
        } else if (credType == MFA_TOKEN) {
            logger.debug("Setting {}mfa token for user: {}, host: {}", cred == null ? "null " : "", loginInput.getUserName(), loginInput.getHostFromServerUrl());
            loginInput.setMfaToken(cred);
        } else {
            logger.debug("Unrecognized type {} for local cached credential", credType);
        }
    }

    void writeIdToken(SFLoginInput loginInput, SFLoginOutput loginOutput) throws SFException {
        logger.debug("Caching id token in a secure storage for user: {}, host: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl());
        this.writeTemporaryCredential(loginInput, loginOutput.getIdToken(), ID_TOKEN);
    }

    void writeMfaToken(SFLoginInput loginInput, SFLoginOutput loginOutput) throws SFException {
        logger.debug("Caching mfa token in a secure storage for user: {}, host: {}", loginInput.getUserName(), loginInput.getHostFromServerUrl());
        this.writeTemporaryCredential(loginInput, loginOutput.getMfaToken(), MFA_TOKEN);
    }

    synchronized void writeTemporaryCredential(SFLoginInput loginInput, String cred, String credType) throws SFException {
        if (Strings.isNullOrEmpty((String)cred)) {
            logger.debug("No {} is given.", credType);
            return;
        }
        if (this.secureStorageManager == null) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
            return;
        }
        try {
            this.secureStorageManager.setCredential(loginInput.getHostFromServerUrl(), loginInput.getUserName(), credType, cred);
        }
        catch (NoClassDefFoundError error) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
        }
    }

    void deleteIdTokenCache(String host, String user) {
        logger.debug("Removing cached id token from a secure storage for user: {}, host: {}", user, host);
        this.deleteTemporaryCredential(host, user, ID_TOKEN);
    }

    void deleteMfaTokenCache(String host, String user) {
        logger.debug("Removing cached mfa token from a secure storage for user: {}, host: {}", user, host);
        this.deleteTemporaryCredential(host, user, MFA_TOKEN);
    }

    synchronized void deleteTemporaryCredential(String host, String user, String credType) {
        if (this.secureStorageManager == null) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
            return;
        }
        try {
            this.secureStorageManager.deleteCredential(host, user, credType);
        }
        catch (NoClassDefFoundError error) {
            CredentialManager.logMissingJnaJarForSecureLocalStorage();
        }
    }

    private static void logMissingJnaJarForSecureLocalStorage() {
        logger.warn("JNA jar files are needed for Secure Local Storage service. Please follow the Snowflake JDBC instruction for Secure Local Storage feature. Fall back to normal process.", false);
    }

    private static class CredentialManagerHolder {
        private static final CredentialManager INSTANCE = new CredentialManager();

        private CredentialManagerHolder() {
        }
    }
}

