/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SfSqlArray;
import net.snowflake.client.jdbc.DefaultSFConnectionHandler;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SFBaseFileTransferAgent;
import net.snowflake.client.jdbc.SFConnectionHandler;
import net.snowflake.client.jdbc.SnowflakeCallableStatementV1;
import net.snowflake.client.jdbc.SnowflakeClob;
import net.snowflake.client.jdbc.SnowflakeConnectString;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.log.SFLoggerUtil;
import net.snowflake.client.util.Stopwatch;

public class SnowflakeConnectionV1
implements Connection,
SnowflakeConnection {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeConnectionV1.class);
    private final Set<Statement> openStatements = ConcurrentHashMap.newKeySet();
    private final AtomicInteger _injectedDelay = new AtomicInteger(0);
    private boolean isClosed;
    private SQLWarning sqlWarnings = null;
    private List<DriverPropertyInfo> missingProperties = null;
    private int networkTimeoutInMilli = 0;
    private int transactionIsolation = 0;
    private SFBaseSession sfSession;
    private SFConnectionHandler sfConnectionHandler;
    private boolean showStatementParameters;

    public SnowflakeConnectionV1(SFConnectionHandler sfConnectionHandler) throws SQLException {
        this.initConnectionWithImpl(sfConnectionHandler, null, null);
    }

    public SnowflakeConnectionV1(SFConnectionHandler sfConnectionHandler, String url, Properties info) throws SQLException {
        this.initConnectionWithImpl(sfConnectionHandler, url, info);
    }

    public SnowflakeConnectionV1(String url, Properties info) throws SQLException {
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(url, info);
        if (!conStr.isValid()) {
            throw new SnowflakeSQLException(ErrorCode.INVALID_CONNECT_STRING, url);
        }
        this.initConnectionWithImpl(new DefaultSFConnectionHandler(conStr), url, info);
        this.appendWarnings(this.sfSession.getSqlWarnings());
        this.isClosed = false;
    }

    public SnowflakeConnectionV1(String url, Properties info, boolean fakeConnection) throws SQLException {
        SnowflakeConnectString conStr = SnowflakeConnectString.parse(url, info);
        if (!conStr.isValid()) {
            throw new SnowflakeSQLException("08000", (int)ErrorCode.INVALID_CONNECT_STRING.getMessageCode(), url);
        }
        this.initConnectionWithImpl(new DefaultSFConnectionHandler(conStr, true), url, info);
        this.isClosed = false;
    }

    private void initConnectionWithImpl(SFConnectionHandler sfConnectionHandler, String url, Properties info) throws SQLException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        logger.debug("Initializing new connection", new Object[0]);
        this.sfConnectionHandler = sfConnectionHandler;
        sfConnectionHandler.initializeConnection(url, info);
        this.sfSession = sfConnectionHandler.getSFSession();
        this.missingProperties = this.sfSession.checkProperties();
        this.showStatementParameters = this.sfSession.getPreparedStatementLogging();
        stopwatch.stop();
        logger.debug("Connection initialized successfully in {} ms. Session id: {}", stopwatch.elapsedMillis(), this.sfSession.getSessionId());
    }

    public List<DriverPropertyInfo> returnMissingProperties() {
        return this.missingProperties;
    }

    private void raiseSQLExceptionIfConnectionIsClosed() throws SQLException {
        if (this.isClosed) {
            throw new SnowflakeSQLException(ErrorCode.CONNECTION_CLOSED, new Object[0]);
        }
    }

    private void executeImmediate(String stmtText) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.execute(stmtText);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement stmt = this.createStatement(1003, 1007);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public ResultSet createResultSet(String queryID) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        ResultSet rs = this.sfConnectionHandler.createResultSet(queryID, this.createStatement());
        return rs;
    }

    public String[] getChildQueryIds(String queryID) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        try (Statement statement = this.createStatement();){
            String[] stringArray = statement.unwrap(SnowflakeStatementV1.class).getChildQueryIds(queryID);
            return stringArray;
        }
    }

    @Override
    public void close() throws SQLException {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        String sessionId = null;
        if (this.sfSession != null) {
            sessionId = this.sfSession.getSessionId();
            logger.debug("Closing connection with session id: {}", sessionId);
        } else {
            logger.debug("Closing connection without associated session", new Object[0]);
        }
        if (this.isClosed) {
            logger.debug("Connection is already closed", new Object[0]);
            return;
        }
        this.isClosed = true;
        try {
            if (this.sfSession != null && this.sfSession.isSafeToClose()) {
                this.sfSession.close();
                this.sfSession = null;
            }
            if (!this.openStatements.isEmpty()) {
                logger.debug("Closing {} opened statements", this.openStatements.size());
            }
            for (Statement stmt : this.openStatements) {
                if (stmt == null || stmt.isClosed()) continue;
                if (stmt.isWrapperFor(SnowflakeStatementV1.class)) {
                    stmt.unwrap(SnowflakeStatementV1.class).close(false);
                    continue;
                }
                stmt.close();
            }
            if (!this.openStatements.isEmpty()) {
                logger.debug("Statements closed successfully", new Object[0]);
            }
            this.openStatements.clear();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLLoggedException(this.sfSession, ex.getSqlState(), ex.getVendorCode(), ex.getCause(), ex.getParams());
        }
        stopwatch.stop();
        logger.debug("Connection with session id: {} closed successfully in {} ms", sessionId, stopwatch.elapsedMillis());
    }

    @Override
    public String getSessionID() throws SQLException {
        if (this.isClosed) {
            this.raiseSQLExceptionIfConnectionIsClosed();
        }
        return this.sfSession.getSessionId();
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.trace("boolean isClosed()", false);
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.trace("DatabaseMetaData getMetaData()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return new SnowflakeDatabaseMetaData(this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.trace("CallableStatement prepareCall(String sql)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        CallableStatement stmt = this.prepareCall(sql, false);
        this.openStatements.add(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, boolean skipParsing) throws SQLException {
        logger.trace("CallableStatement prepareCall(String sql, boolean skipParsing)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        SnowflakeCallableStatementV1 stmt = new SnowflakeCallableStatementV1(this, sql, skipParsing, 1003, 1007, 2);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.trace("CallableStatement prepareCall(String sql, int resultSetType,int resultSetConcurrency", false);
        CallableStatement stmt = this.prepareCall(sql, resultSetType, resultSetConcurrency, 2);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.trace("CallableStatement prepareCall(String sql, int resultSetType,", false);
        SnowflakeCallableStatementV1 stmt = new SnowflakeCallableStatementV1(this, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.trace("String nativeSQL(String sql)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return sql;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.trace("boolean getAutoCommit()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        logger.trace("void setAutoCommit(boolean isAutoCommit)", false);
        boolean currentAutoCommit = this.getAutoCommit();
        if (isAutoCommit != currentAutoCommit) {
            this.sfSession.setAutoCommit(isAutoCommit);
            this.executeImmediate("alter session /* JDBC:SnowflakeConnectionV1.setAutoCommit*/ set autocommit=" + isAutoCommit);
        }
    }

    @Override
    public void commit() throws SQLException {
        logger.trace("void commit()", false);
        this.executeImmediate("commit");
    }

    @Override
    public void rollback() throws SQLException {
        logger.trace("void rollback()", false);
        this.executeImmediate("rollback");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        logger.trace("void rollback(Savepoint savepoint)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.trace("boolean isReadOnly()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.trace("void setReadOnly(boolean readOnly)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        if (readOnly) {
            logger.debug("setReadOnly not supported.", false);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getDatabase();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        logger.trace("void setCatalog(String catalog)", false);
        this.executeImmediate("use database \"" + catalog + "\"");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.trace("int getTransactionIsolation()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.trace("void setTransactionIsolation(int level), level = {}", level);
        this.raiseSQLExceptionIfConnectionIsClosed();
        if (level != 0 && level != 2) {
            throw new SQLFeatureNotSupportedException("Transaction Isolation " + level + " not supported.", ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.transactionIsolation = level;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.trace("SQLWarning getWarnings()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sqlWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.trace("void clearWarnings()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.clearSqlWarnings();
        this.sqlWarnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.trace("Statement createStatement(int resultSetType, int resultSetConcurrency)", false);
        Statement stmt = this.createStatement(resultSetType, resultSetConcurrency, 2);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.trace("Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability", false);
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        PreparedStatement stmt = this.prepareStatement(sql, false);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)", false);
        if (autoGeneratedKeys == 2) {
            return this.prepareStatement(sql);
        }
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, int[] columnIndexes)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, String[] columnNames)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, int resultSetType,", false);
        PreparedStatement stmt = this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, int resultSetType,", false);
        SnowflakePreparedStatementV1 stmt = new SnowflakePreparedStatementV1(this, sql, false, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.openStatements.add(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, boolean skipParsing) throws SQLException {
        logger.trace("PreparedStatement prepareStatement(String sql, boolean skipParsing)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        SnowflakePreparedStatementV1 stmt = new SnowflakePreparedStatementV1(this, sql, skipParsing, 1003, 1007, 2);
        this.openStatements.add(stmt);
        return stmt;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("The given parameter is not a ResultSet holdability constant.");
        }
        if (holdability == 1) {
            throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return new SnowflakeClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout is less than 0");
        }
        if (this.isClosed) {
            return false;
        }
        try {
            this.sfSession.callHeartBeat(timeout);
        }
        catch (Exception | SFException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
        failedProps.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        this.raiseSetClientInfoException(failedProps);
    }

    private void raiseSetClientInfoException(Map<String, ClientInfoStatus> failedProps) throws SQLClientInfoException {
        if (this.isClosed) {
            throw new SQLClientInfoException("The connection is not opened.", ErrorCode.CONNECTION_CLOSED.getSqlState(), (int)ErrorCode.CONNECTION_CLOSED.getMessageCode(), failedProps);
        }
        throw new SQLClientInfoException("The client property cannot be set by setClientInfo.", ErrorCode.INVALID_PARAMETER_VALUE.getSqlState(), (int)ErrorCode.INVALID_PARAMETER_VALUE.getMessageCode(), failedProps);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.trace("Properties getClientInfo()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getClientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
        Enumeration<?> propList = properties.propertyNames();
        while (propList.hasMoreElements()) {
            String name = (String)propList.nextElement();
            failedProps.put(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
        }
        this.raiseSetClientInfoException(failedProps);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        logger.trace("String getClientInfo(String name)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getClientInfo(name);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        logger.trace("Array createArrayOf(String typeName, Object[] elements)", false);
        return new SfSqlArray(JDBCType.valueOf(typeName.toUpperCase()).getVendorTypeNumber(), elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        logger.trace("Struct createStruct(String typeName, Object[] attributes)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.sfSession);
    }

    @Override
    public String getSchema() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.sfSession.getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        logger.trace("void setSchema(String schema)", false);
        String databaseName = this.getCatalog();
        if (databaseName == null) {
            this.executeImmediate("use schema \"" + schema + "\"");
        } else {
            this.executeImmediate("use schema \"" + databaseName + "\".\"" + schema + "\"");
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        logger.trace("void abort(Executor executor)", false);
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        logger.trace("void setNetworkTimeout(Executor executor, int milliseconds)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.networkTimeoutInMilli = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        logger.trace("int getNetworkTimeout()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.networkTimeoutInMilli;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.trace("boolean isWrapperFor(Class<?> iface)", false);
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.trace("<T> T unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    int getDatabaseMajorVersion() {
        return this.sfSession.getDatabaseMajorVersion();
    }

    int getDatabaseMinorVersion() {
        return this.sfSession.getDatabaseMinorVersion();
    }

    String getDatabaseVersion() {
        return this.sfSession.getDatabaseVersion();
    }

    @Override
    public SFConnectionHandler getHandler() {
        return this.sfConnectionHandler;
    }

    @Deprecated
    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, false);
    }

    @Override
    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, boolean compressData) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, compressData);
    }

    @Deprecated
    public void compressAndUploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, true);
    }

    private void uploadStreamInternal(String stageName, String destPrefix, InputStream inputStream, String destFileName, boolean compressData) throws SQLException {
        logger.debug("Upload data from stream: stageName={}, destPrefix={}, destFileName={}", stageName, destPrefix, destFileName);
        if (stageName == null) {
            throw new SnowflakeSQLLoggedException(this.sfSession, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "stage name is null");
        }
        if (destFileName == null) {
            throw new SnowflakeSQLLoggedException(this.sfSession, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "stage name is null");
        }
        SnowflakeStatementV1 stmt = this.createStatement().unwrap(SnowflakeStatementV1.class);
        StringBuilder destStage = new StringBuilder();
        if (!(stageName.startsWith("@") || stageName.startsWith("'@") || stageName.startsWith("$$@"))) {
            destStage.append("@");
        }
        destStage.append(stageName);
        if (destPrefix != null) {
            if (!destPrefix.startsWith("/")) {
                destStage.append("/");
            }
            destStage.append(destPrefix);
        }
        StringBuilder putCommand = new StringBuilder();
        putCommand.append("put file:///tmp/placeholder ");
        putCommand.append(destStage.toString());
        putCommand.append(" overwrite=true");
        SFBaseFileTransferAgent transferAgent = this.sfConnectionHandler.getFileTransferAgent(putCommand.toString(), stmt.getSFBaseStatement());
        transferAgent.setDestStagePath(destStage.toString());
        transferAgent.setSourceStream(inputStream);
        transferAgent.setDestFileNameForStreamSource(destFileName);
        transferAgent.setCompressSourceFromStream(compressData);
        transferAgent.execute();
        stmt.close();
    }

    @Override
    public InputStream downloadStream(String stageName, String sourceFileName, boolean decompress) throws SQLException {
        boolean isSpecialChar;
        logger.debug("Download data to stream: stageName={}, sourceFileName={}", stageName, sourceFileName);
        if (Strings.isNullOrEmpty((String)stageName)) {
            throw new SnowflakeSQLLoggedException(this.sfSession, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "stage name is null or empty");
        }
        if (Strings.isNullOrEmpty((String)sourceFileName)) {
            throw new SnowflakeSQLLoggedException(this.sfSession, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "source file name is null or empty");
        }
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this, 1003, 1007, 2);
        StringBuilder getCommand = new StringBuilder();
        getCommand.append("get ");
        if (!stageName.startsWith("@")) {
            getCommand.append("@");
        }
        getCommand.append(stageName);
        getCommand.append("/");
        if (sourceFileName.startsWith("/")) {
            sourceFileName = sourceFileName.substring(1);
        }
        getCommand.append(sourceFileName);
        boolean bl = isSpecialChar = !sourceFileName.matches("^[a-zA-Z0-9_/.]*$");
        if (isSpecialChar) {
            getCommand.insert(getCommand.indexOf("@"), "'");
            getCommand.append("'");
        }
        getCommand.append(" file:///tmp/ /*jdbc download stream*/");
        String[] split = sourceFileName.split("/");
        String fileName = Pattern.quote(split[split.length - 1]);
        getCommand.append(" PATTERN=\".*").append(fileName).append("$\"");
        SFBaseFileTransferAgent transferAgent = this.sfConnectionHandler.getFileTransferAgent(getCommand.toString(), stmt.getSFBaseStatement());
        InputStream stream = transferAgent.downloadStream(sourceFileName);
        if (decompress) {
            try {
                return new GZIPInputStream(stream);
            }
            catch (IOException ex) {
                throw new SnowflakeSQLLoggedException(this.sfSession, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", ex.getMessage());
            }
        }
        return stream;
    }

    public void setInjectedDelay(int delay) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.setInjectedDelay(delay);
    }

    void injectedDelay() throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setInjectFileUploadFailure(String fileToFail) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        this.sfSession.setInjectFileUploadFailure(fileToFail);
    }

    public SFBaseSession getSFBaseSession() {
        return this.sfSession;
    }

    public SFSession getSfSession() throws SnowflakeSQLException {
        if (this.sfSession instanceof SFSession) {
            return (SFSession)this.sfSession;
        }
        throw new SnowflakeSQLException("getSFSession() called with a different SFBaseSession type.");
    }

    private void appendWarning(SQLWarning w) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = w;
        } else {
            this.sqlWarnings.setNextWarning(w);
        }
    }

    private void appendWarnings(List<SFException> warnings) {
        for (SFException e : warnings) {
            this.appendWarning(new SQLWarning(e.getMessage(), e.getSqlState(), e.getVendorCode()));
        }
    }

    public boolean getShowStatementParameters() {
        return this.showStatementParameters;
    }

    void removeClosedStatement(Statement stmt) {
        this.openStatements.remove(stmt);
    }

    static {
        SFLoggerUtil.initializeSnowflakeLogger();
    }
}

