/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataQueryResultSet;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataResultSet;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.snowflake.common.util.Wildcard;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.jdbc.telemetry.TelemetryUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeDatabaseMetaData
implements DatabaseMetaData {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDatabaseMetaData.class);
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static final String DatabaseProductName = "Snowflake";
    private static final String DriverName = "Snowflake";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final String JDBCVersion = "4.2";
    public static final String NumericFunctionsSupported = "ABS,ACOS,ASIN,ATAN,ATAN2,CBRT,CEILING,COS,COT,DEGREES,EXP,FACTORIAL,FLOOR,HAVERSINE,LN,LOG,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,SQUARE,TAN,TRUNCATE";
    public static final String StringFunctionsSupported = "ASCII,BIT_LENGTH,CHAR,CONCAT,INSERT,LCASE,LEFT,LENGTH,LPAD,LOCATE,LTRIM,OCTET_LENGTH,PARSE_IP,PARSE_URL,REPEAT,REVERSE,REPLACE,RPAD,RTRIMMED_LENGTH,SPACE,SPLIT,SPLIT_PART,SPLIT_TO_TABLE,STRTOK,STRTOK_TO_ARRAY,STRTOK_SPLIT_TO_TABLE,TRANSLATE,TRIM,UNICODE,UUID_STRING,INITCAP,LOWER,UPPER,REGEXP,REGEXP_COUNT,REGEXP_INSTR,REGEXP_LIKE,REGEXP_REPLACE,REGEXP_SUBSTR,RLIKE,CHARINDEX,CONTAINS,EDITDISTANCE,ENDSWITH,ILIKE,ILIKE ANY,LIKE,LIKE ALL,LIKE ANY,POSITION,REPLACE,RIGHT,STARTSWITH,SUBSTRING,COMPRESS,DECOMPRESS_BINARY,DECOMPRESS_STRING,BASE64_DECODE_BINARY,BASE64_DECODE_STRING,BASE64_ENCODE,HEX_DECODE_BINARY,HEX_DECODE_STRING,HEX_ENCODE,TRY_BASE64_DECODE_BINARY,TRY_BASE64_DECODE_STRING,TRY_HEX_DECODE_BINARY,TRY_HEX_DECODE_STRING,MD_5,MD5_HEX,MD5_BINARY,SHA1,SHA1_HEX,SHA2,SHA1_BINARY,SHA2_HEX,SHA2_BINARY, HASH,HASH_AGG,COLLATE,COLLATION";
    private static final String DateAndTimeFunctionsSupported = "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR";
    public static final String SystemFunctionsSupported = "DATABASE,IFNULL,USER";
    private static final String notSQL2003Keywords = String.join((CharSequence)",", "ACCOUNT", "ASOF", "BIT", "BYTEINT", "CONNECTION", "DATABASE", "DATETIME", "DATE_PART", "FIXED", "FOLLOWING", "GSCLUSTER", "GSPACKAGE", "IDENTIFIER", "ILIKE", "INCREMENT", "ISSUE", "LONG", "MAP", "MATCH_CONDITION", "MINUS", "NUMBER", "OBJECT", "ORGANIZATION", "QUALIFY", "REFERENCE", "REGEXP", "RLIKE", "SAMPLE", "SCHEMA", "STRING", "TEXT", "TIMESTAMPLTZ", "TIMESTAMPNTZ", "TIMESTAMPTZ", "TIMESTAMP_LTZ", "TIMESTAMP_NTZ", "TIMESTAMP_TZ", "TINYINT", "TRANSIT", "TRY_CAST", "VARIANT", "VECTOR", "VIEW");
    private static final String MAX_VARCHAR_BINARY_SIZE_PARAM_NAME = "VARCHAR_AND_BINARY_MAX_SIZE_IN_RESULT";
    private static final int DEFAULT_MAX_LOB_SIZE = 0x1000000;
    private final Connection connection;
    private final SFBaseSession session;
    private Telemetry ibInstance;
    private final boolean metadataRequestUseConnectionCtx;
    private boolean useSessionSchema = false;
    private final boolean metadataRequestUseSessionDatabase;
    private boolean stringsQuoted = false;
    private int procedureResultsetColumnNum;
    private boolean isPatternMatchingEnabled = true;
    private boolean exactSchemaSearchEnabled;

    SnowflakeDatabaseMetaData(Connection connection) throws SQLException {
        logger.trace("SnowflakeDatabaseMetaData(SnowflakeConnection connection)", false);
        this.connection = connection;
        this.session = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
        this.metadataRequestUseConnectionCtx = this.session.getMetadataRequestUseConnectionCtx();
        this.metadataRequestUseSessionDatabase = this.session.getMetadataRequestUseSessionDatabase();
        this.stringsQuoted = this.session.isStringQuoted();
        this.ibInstance = this.session.getTelemetryClient();
        this.procedureResultsetColumnNum = -1;
        this.isPatternMatchingEnabled = this.session.getEnablePatternSearch();
        this.exactSchemaSearchEnabled = this.session.getEnableExactSchemaSearch();
    }

    private void raiseSQLExceptionIfConnectionIsClosed() throws SQLException {
        if (this.connection.isClosed()) {
            throw new SnowflakeSQLException(ErrorCode.CONNECTION_CLOSED, new Object[0]);
        }
    }

    private void sendInBandTelemetryMetadataMetrics(ResultSet resultSet, String functionName, String catalog, String schema, String generalNamePattern, String specificNamePattern) {
        String queryId = "";
        try {
            if (resultSet.isWrapperFor(SnowflakeResultSet.class)) {
                queryId = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
            } else if (resultSet.isWrapperFor(SnowflakeDatabaseMetaDataResultSet.class)) {
                queryId = resultSet.unwrap(SnowflakeDatabaseMetaDataResultSet.class).getQueryID();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ObjectNode ibValue = mapper.createObjectNode();
        ibValue.put("type", TelemetryField.METADATA_METRICS.toString());
        ibValue.put("query_id", queryId);
        ibValue.put("function_name", functionName);
        ibValue.with("function_parameters").put("catalog", catalog);
        ibValue.with("function_parameters").put("schema", schema);
        ibValue.with("function_parameters").put("general_name_pattern", generalNamePattern);
        ibValue.with("function_parameters").put("specific_name_pattern", specificNamePattern);
        ibValue.put("use_connection_context", this.metadataRequestUseConnectionCtx ? "true" : "false");
        ibValue.put("session_database_name", this.session.getDatabase());
        ibValue.put("session_schema_name", this.session.getSchema());
        TelemetryData data = TelemetryUtil.buildJobData(ibValue);
        this.ibInstance.addLogToBatch(data);
    }

    private String unescapeChars(String escapedString) {
        String unescapedString = escapedString.replace("\\_", "_");
        unescapedString = unescapedString.replace("\\%", "%");
        unescapedString = unescapedString.replace("\\\\", "\\");
        unescapedString = this.escapeSqlQuotes(unescapedString);
        return unescapedString;
    }

    private String escapeSqlQuotes(String originalString) {
        return originalString.replace("\"", "\"\"");
    }

    private String escapeSingleQuoteForLikeCommand(String arg) {
        if (arg == null) {
            return null;
        }
        int i = 0;
        int index = arg.indexOf("'", i);
        while (index != -1) {
            if (index == 0 || index > 0 && arg.charAt(index - 1) != '\\') {
                arg = arg.replace("'", "\\'");
                i = index + 2;
            } else {
                i = index + 1;
            }
            index = i < arg.length() ? arg.indexOf("'", i) : -1;
        }
        return arg;
    }

    private boolean isSchemaNameWildcardPattern(String inputString) {
        return this.useSessionSchema ? false : Wildcard.isWildcardPatternStr(inputString);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        logger.trace("boolean allProceduresAreCallable()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        logger.trace("boolean allTablesAreSelectable()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        logger.trace("String getURL()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        String url = this.session.getUrl();
        return url.startsWith("http://") ? url.replace("http://", "jdbc:snowflake://") : url.replace("https://", "jdbc:snowflake://");
    }

    @Override
    public String getUserName() throws SQLException {
        logger.trace("String getUserName()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.session.getUser();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.trace("boolean isReadOnly()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        logger.trace("boolean nullsAreSortedHigh()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        logger.trace("boolean nullsAreSortedLow()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        logger.trace("boolean nullsAreSortedAtStart()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        logger.trace("boolean nullsAreSortedAtEnd()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        logger.trace("String getDatabaseProductName()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "Snowflake";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        logger.trace("String getDatabaseProductVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        logger.trace("String getDriverName()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "Snowflake";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        logger.trace("String getDriverVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return SnowflakeDriver.majorVersion + "." + SnowflakeDriver.minorVersion + "." + SnowflakeDriver.patchVersion;
    }

    @Override
    public int getDriverMajorVersion() {
        logger.trace("int getDriverMajorVersion()", false);
        return SnowflakeDriver.majorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        logger.trace("int getDriverMinorVersion()", false);
        return SnowflakeDriver.minorVersion;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        logger.trace("boolean usesLocalFiles()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        logger.trace("boolean usesLocalFilePerTable()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        logger.trace("boolean supportsMixedCaseIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        logger.trace("boolean storesUpperCaseIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        logger.trace("boolean storesLowerCaseIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        logger.trace("boolean storesMixedCaseIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        logger.trace("boolean supportsMixedCaseQuotedIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        logger.trace("boolean storesUpperCaseQuotedIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        logger.trace("boolean storesLowerCaseQuotedIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        logger.trace("boolean storesMixedCaseQuotedIdentifiers()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        logger.trace("String getIdentifierQuoteString()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        logger.trace("String getSQLKeywords()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return notSQL2003Keywords;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        logger.trace("String getNumericFunctions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return NumericFunctionsSupported;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        logger.trace("String getStringFunctions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return StringFunctionsSupported;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        logger.trace("String getSystemFunctions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return SystemFunctionsSupported;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        logger.trace("String getTimeDateFunctions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return DateAndTimeFunctionsSupported;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        logger.trace("String getSearchStringEscape()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Character.toString('\\');
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        logger.trace("String getExtraNameCharacters()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        logger.trace("boolean supportsAlterTableWithAddColumn()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        logger.trace("boolean supportsAlterTableWithDropColumn()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        logger.trace("boolean supportsColumnAliasing()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        logger.trace("boolean nullPlusNonNullIsNull()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        logger.trace("boolean supportsConvert()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        logger.trace("boolean supportsConvert(int fromType, int toType)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        logger.trace("boolean supportsTableCorrelationNames()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        logger.trace("boolean supportsDifferentTableCorrelationNames()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        logger.trace("boolean supportsExpressionsInOrderBy()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        logger.trace("boolean supportsOrderByUnrelated()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        logger.trace("boolean supportsGroupBy()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        logger.trace("boolean supportsGroupByUnrelated()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        logger.trace("boolean supportsGroupByBeyondSelect()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        logger.trace("boolean supportsLikeEscapeClause()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        logger.trace("boolean supportsMultipleResultSets()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        logger.trace("boolean supportsMultipleTransactions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        logger.trace("boolean supportsNonNullableColumns()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        logger.trace("boolean supportsMinimumSQLGrammar()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        logger.trace("boolean supportsCoreSQLGrammar()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        logger.trace("boolean supportsExtendedSQLGrammar()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        logger.trace("boolean supportsANSI92EntryLevelSQL()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        logger.trace("boolean supportsANSI92IntermediateSQL()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        logger.trace("boolean supportsANSI92FullSQL()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        logger.trace("boolean supportsIntegrityEnhancementFacility()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        logger.trace("boolean supportsOuterJoins()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        logger.trace("boolean supportsFullOuterJoins()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        logger.trace("boolean supportsLimitedOuterJoins()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        logger.trace("String getSchemaTerm()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        logger.trace("String getProcedureTerm()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        logger.trace("String getCatalogTerm()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        logger.trace("boolean isCatalogAtStart()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        logger.trace("String getCatalogSeparator()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        logger.trace("boolean supportsSchemasInDataManipulation()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        logger.trace("boolean supportsSchemasInProcedureCalls()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        logger.trace("boolean supportsSchemasInTableDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        logger.trace("boolean supportsSchemasInIndexDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        logger.trace("boolean supportsSchemasInPrivilegeDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        logger.trace("boolean supportsCatalogsInDataManipulation()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        logger.trace("boolean supportsCatalogsInProcedureCalls()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        logger.trace("boolean supportsCatalogsInTableDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        logger.trace("boolean supportsCatalogsInIndexDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        logger.trace("boolean supportsCatalogsInPrivilegeDefinitions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        logger.trace("boolean supportsPositionedDelete()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        logger.trace("boolean supportsPositionedUpdate()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        logger.trace("boolean supportsSelectForUpdate()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        logger.trace("boolean supportsStoredProcedures()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        logger.trace("boolean supportsSubqueriesInComparisons()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        logger.trace("boolean supportsSubqueriesInExists()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        logger.trace("boolean supportsSubqueriesInIns()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        logger.trace("boolean supportsSubqueriesInQuantifieds()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        logger.trace("boolean supportsCorrelatedSubqueries()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        logger.trace("boolean supportsUnion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        logger.trace("boolean supportsUnionAll()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        logger.trace("boolean supportsOpenCursorsAcrossCommit()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        logger.trace("boolean supportsOpenCursorsAcrossRollback()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        logger.trace("boolean supportsOpenStatementsAcrossCommit()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        logger.trace("boolean supportsOpenStatementsAcrossRollback()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        logger.trace("int getMaxBinaryLiteralLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.getMaxCharLiteralLength() / 2;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        logger.trace("int getMaxCharLiteralLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Optional<Integer> maxLiteralLengthFromSession = Optional.ofNullable((Integer)this.session.getOtherParameter(MAX_VARCHAR_BINARY_SIZE_PARAM_NAME));
        return maxLiteralLengthFromSession.orElse(0x1000000);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        logger.trace("int getMaxColumnNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        logger.trace("int getMaxColumnsInGroupBy()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        logger.trace("int getMaxColumnsInIndex()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        logger.trace("int getMaxColumnsInOrderBy()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        logger.trace("int getMaxColumnsInSelect()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        logger.trace("int getMaxColumnsInTable()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        logger.trace("int getMaxConnections()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        logger.trace("int getMaxCursorNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        logger.trace("int getMaxIndexLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        logger.trace("int getMaxSchemaNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        logger.trace("int getMaxProcedureNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        logger.trace("int getMaxCatalogNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        logger.trace("int getMaxRowSize()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        logger.trace("boolean doesMaxRowSizeIncludeBlobs()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        logger.trace("int getMaxStatementLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        logger.trace("int getMaxStatements()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        logger.trace("int getMaxTableNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        logger.trace("int getMaxTablesInSelect()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        logger.trace("int getMaxUserNameLength()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 255;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        logger.trace("int getDefaultTransactionIsolation()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        logger.trace("boolean supportsTransactions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        logger.trace("boolean supportsTransactionIsolationLevel(int level)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return level == 0 || level == 2;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        logger.trace("boolean supportsDataDefinitionAndDataManipulationTransactions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        logger.trace("boolean supportsDataManipulationTransactionsOnly()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        logger.trace("boolean dataDefinitionCausesTransactionCommit()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        logger.trace("boolean dataDefinitionIgnoredInTransactions()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getProcedures(String originalCatalog, String originalSchemaPattern, String procedureNamePattern) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        logger.trace("public ResultSet getProcedures(String originalCatalog, String originalSchemaPattern,String procedureNamePattern)", false);
        String showProcedureCommand = this.getFirstResultSetCommand(originalCatalog, originalSchemaPattern, procedureNamePattern, "procedures");
        if (showProcedureCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PROCEDURES, statement);
        }
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        final String schemaPattern = result.schema();
        final boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledProcedurePattern = Wildcard.toRegexPattern(procedureNamePattern, true);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureCommand, DBMetadataResultSetMetadata.GET_PROCEDURES);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getProcedures", catalog, schemaPattern, procedureNamePattern, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_PROCEDURES, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String catalogName = this.showObjectResultSet.getString("catalog_name");
                    String schemaName = this.showObjectResultSet.getString("schema_name");
                    String procedureName = this.showObjectResultSet.getString("name");
                    String remarks = this.showObjectResultSet.getString("description");
                    String specificName = this.showObjectResultSet.getString("arguments");
                    short procedureType = 2;
                    if (compiledProcedurePattern != null && !compiledProcedurePattern.matcher(procedureName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() && (!isExactSchema || !schemaPattern.equals(schemaPattern))) continue;
                    logger.trace("Found a matched function:" + schemaName + "." + procedureName, new Object[0]);
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = procedureName;
                    this.nextRow[3] = remarks;
                    this.nextRow[4] = procedureType;
                    this.nextRow[5] = specificName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        logger.trace("public ResultSet getProcedureColumns(String catalog, String schemaPattern,String procedureNamePattern,String columnNamePattern)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        boolean addAllRows = false;
        String showProcedureCommand = this.getFirstResultSetCommand(catalog, schemaPattern, procedureNamePattern, "procedures");
        if (showProcedureCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS, statement);
        }
        Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        Pattern compiledProcedurePattern = Wildcard.toRegexPattern(procedureNamePattern, true);
        if (columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*")) {
            addAllRows = true;
        }
        ResultSet resultSetStepOne = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureCommand, DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS);
        this.sendInBandTelemetryMetadataMetrics(resultSetStepOne, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSetStepOne.next()) {
            int i;
            String catalogName;
            String showProcedureColCommand;
            ResultSet resultSetStepTwo;
            boolean isSchemaNameMatch;
            String procedureNameUnparsed = resultSetStepOne.getString("arguments").trim();
            String procedureNameNoArgs = resultSetStepOne.getString("name");
            String schemaName = resultSetStepOne.getString("schema_name");
            boolean bl = isSchemaNameMatch = compiledSchemaPattern != null && (compiledSchemaPattern.matcher(schemaName).matches() || schemaName.startsWith("\"") && schemaName.endsWith("\"") && compiledSchemaPattern.matcher(schemaName).region(1, schemaName.length() - 1).matches());
            if (compiledProcedurePattern != null && !compiledProcedurePattern.matcher(procedureNameNoArgs).matches() || compiledSchemaPattern != null && !isSchemaNameMatch || !(resultSetStepTwo = this.executeAndReturnEmptyResultIfNotFound(statement, showProcedureColCommand = this.getSecondResultSetCommand(catalogName = resultSetStepOne.getString("catalog_name"), schemaName, procedureNameUnparsed, "procedure"), DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS)).next()) continue;
            String args = resultSetStepTwo.getString("value");
            resultSetStepTwo.next();
            String res = resultSetStepTwo.getString("value");
            List<String> procedureCols = this.parseColumns(res, args);
            String[] paramNames = new String[procedureCols.size() / 2];
            String[] paramTypes = new String[procedureCols.size() / 2];
            if (procedureCols.size() > 1) {
                for (i = 0; i < procedureCols.size(); ++i) {
                    if (i % 2 == 0) {
                        paramNames[i / 2] = procedureCols.get(i);
                        continue;
                    }
                    paramTypes[i / 2] = procedureCols.get(i);
                }
            }
            for (i = 0; i < paramNames.length; ++i) {
                String typeName;
                if (i != 0 && !paramNames[i].equalsIgnoreCase(columnNamePattern) && !addAllRows) continue;
                Object[] nextRow = new Object[20];
                nextRow[0] = catalog;
                nextRow[1] = schemaName;
                nextRow[2] = procedureNameNoArgs;
                nextRow[3] = paramNames[i];
                nextRow[4] = i == 0 && this.procedureResultsetColumnNum < 0 ? Integer.valueOf(5) : (this.procedureResultsetColumnNum >= 0 && i < this.procedureResultsetColumnNum ? Integer.valueOf(3) : Integer.valueOf(1));
                String typeNameTrimmed = typeName = paramTypes[i];
                if (typeName.contains(" NOT NULL")) {
                    typeNameTrimmed = typeName.substring(0, typeName.indexOf(32));
                }
                if (typeNameTrimmed.contains("(") && typeNameTrimmed.contains(")")) {
                    typeNameTrimmed = typeNameTrimmed.substring(0, typeNameTrimmed.indexOf(40));
                }
                int type = SnowflakeType.convertStringToType(typeName);
                nextRow[5] = type;
                nextRow[6] = typeNameTrimmed;
                int precision = 38;
                short scale = 0;
                if (type < 10) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        precision = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(44)));
                        scale = Short.parseShort(typeName.substring(typeName.indexOf(44) + 1, typeName.indexOf(41)));
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    } else {
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    }
                } else {
                    nextRow[7] = 0;
                    nextRow[9] = null;
                }
                nextRow[8] = 0;
                nextRow[10] = 10;
                if (typeName.toLowerCase().contains("not null")) {
                    nextRow[11] = 0;
                    nextRow[18] = "NO";
                } else if (i == 0) {
                    nextRow[11] = 1;
                    nextRow[18] = "YES";
                } else {
                    nextRow[11] = 2;
                    nextRow[18] = "";
                }
                nextRow[12] = resultSetStepOne.getString("description").trim();
                nextRow[13] = null;
                nextRow[14] = 0;
                nextRow[15] = 0;
                if (type == -2 || type == -3 || type == 1 || type == 12) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        int char_octet_len = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(41)));
                        nextRow[16] = char_octet_len;
                    } else if (type == 1 || type == 12) {
                        nextRow[16] = this.getMaxCharLiteralLength();
                    } else if (type == -2 || type == -3) {
                        nextRow[16] = this.getMaxBinaryLiteralLength();
                    }
                } else {
                    nextRow[16] = null;
                }
                nextRow[17] = this.procedureResultsetColumnNum >= 0 ? (i < this.procedureResultsetColumnNum ? Integer.valueOf(i + 1) : Integer.valueOf(i - this.procedureResultsetColumnNum + 1)) : Integer.valueOf(i);
                nextRow[19] = procedureNameUnparsed;
                rows.add(nextRow);
            }
        }
        Object[][] resultRows = new Object[rows.size()][20];
        for (int i = 0; i < resultRows.length; ++i) {
            resultRows[i] = (Object[])rows.get(i);
        }
        return new SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata.GET_PROCEDURE_COLUMNS, resultRows, statement);
    }

    private ContextAwareMetadataSearch applySessionContext(String catalog, String schemaPattern) {
        if (this.metadataRequestUseConnectionCtx) {
            if (catalog == null) {
                catalog = this.session.getDatabase();
            }
            if (schemaPattern == null) {
                schemaPattern = this.session.getSchema();
                this.useSessionSchema = true;
            }
        } else if (this.metadataRequestUseSessionDatabase && catalog == null) {
            catalog = this.session.getDatabase();
        }
        return new ContextAwareMetadataSearch(catalog, schemaPattern, this.exactSchemaSearchEnabled && this.useSessionSchema);
    }

    private String getFirstResultSetCommand(String catalog, String schemaPattern, String name, String type) {
        ContextAwareMetadataSearch result = this.applySessionContext(catalog, schemaPattern);
        catalog = result.database();
        schemaPattern = result.schema();
        boolean isExactSchema = result.isExactSchema();
        String showProcedureCommand = "show /* JDBC:DatabaseMetaData.getProcedures() */ " + type;
        if (!(name == null || name.isEmpty() || name.trim().equals("%") || name.trim().equals(".*"))) {
            showProcedureCommand = showProcedureCommand + " like '" + this.escapeSingleQuoteForLikeCommand(name) + "'";
        }
        if (catalog == null) {
            showProcedureCommand = showProcedureCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return "";
            }
            String catalogEscaped = this.escapeSqlQuotes(catalog);
            if (!isExactSchema && (schemaPattern == null || this.isSchemaNameWildcardPattern(schemaPattern))) {
                showProcedureCommand = showProcedureCommand + " in database \"" + catalogEscaped + "\"";
            } else {
                if (schemaPattern.isEmpty()) {
                    return "";
                }
                schemaPattern = this.unescapeChars(schemaPattern);
                showProcedureCommand = showProcedureCommand + " in schema \"" + catalogEscaped + "\".\"" + schemaPattern + "\"";
            }
        }
        logger.debug("Sql command to get column metadata: {}", showProcedureCommand);
        return showProcedureCommand;
    }

    private String getSecondResultSetCommand(String catalog, String schemaPattern, String name, String type) {
        if (Strings.isNullOrEmpty((String)name)) {
            return "";
        }
        String procedureCols = name.substring(name.indexOf("("), name.indexOf(" RETURN"));
        String quotedName = "\"" + name.substring(0, name.indexOf("(")) + "\"";
        String procedureName = quotedName + procedureCols;
        String showProcedureColCommand = !Strings.isNullOrEmpty((String)catalog) && !Strings.isNullOrEmpty((String)schemaPattern) ? "desc " + type + " " + catalog + "." + schemaPattern + "." + procedureName : (!Strings.isNullOrEmpty((String)schemaPattern) ? "desc " + type + " " + schemaPattern + "." + procedureName : "desc " + type + " " + procedureName);
        return showProcedureColCommand;
    }

    @Override
    public ResultSet getTables(String originalCatalog, String originalSchemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean tableOnly;
        logger.trace("public ResultSet getTables(String catalog={}, String schemaPattern={}, String tableNamePattern={}, String[] types={})", originalCatalog, originalSchemaPattern, tableNamePattern, () -> Arrays.toString(types));
        this.raiseSQLExceptionIfConnectionIsClosed();
        HashSet<String> supportedTableTypes = new HashSet<String>();
        ResultSet resultSet = this.getTableTypes();
        while (resultSet.next()) {
            supportedTableTypes.add(resultSet.getString("TABLE_TYPE"));
        }
        resultSet.close();
        ArrayList<String> inputValidTableTypes = new ArrayList<String>();
        if (types != null) {
            for (String t : types) {
                if (!supportedTableTypes.contains(t)) continue;
                inputValidTableTypes.add(t);
            }
        } else {
            inputValidTableTypes = new ArrayList(supportedTableTypes);
        }
        Statement statement = this.connection.createStatement();
        if (inputValidTableTypes.size() == 0) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
        }
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        String schemaPattern = result.schema();
        boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledTablePattern = Wildcard.toRegexPattern(tableNamePattern, true);
        String showTablesCommand = null;
        final boolean viewOnly = inputValidTableTypes.size() == 1 && "VIEW".equalsIgnoreCase((String)inputValidTableTypes.get(0));
        boolean bl = tableOnly = inputValidTableTypes.size() == 1 && "TABLE".equalsIgnoreCase((String)inputValidTableTypes.get(0));
        showTablesCommand = viewOnly ? "show /* JDBC:DatabaseMetaData.getTables() */ views" : (tableOnly ? "show /* JDBC:DatabaseMetaData.getTables() */ tables" : "show /* JDBC:DatabaseMetaData.getTables() */ objects");
        if (!(tableNamePattern == null || tableNamePattern.isEmpty() || tableNamePattern.trim().equals("%") || tableNamePattern.trim().equals(".*"))) {
            showTablesCommand = showTablesCommand + " like '" + this.escapeSingleQuoteForLikeCommand(tableNamePattern) + "'";
        }
        if (catalog == null) {
            showTablesCommand = showTablesCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
            }
            String catalogEscaped = this.escapeSqlQuotes(catalog);
            if (schemaPattern == null || this.isSchemaNameWildcardPattern(schemaPattern)) {
                showTablesCommand = showTablesCommand + " in database \"" + catalogEscaped + "\"";
            } else {
                if (schemaPattern.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLES, statement);
                }
                String schemaUnescaped = isExactSchema ? schemaPattern : this.unescapeChars(schemaPattern);
                showTablesCommand = showTablesCommand + " in schema \"" + catalogEscaped + "\".\"" + schemaUnescaped + "\"";
            }
        }
        logger.debug("Sql command to get table metadata: {}", showTablesCommand);
        resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showTablesCommand, DBMetadataResultSetMetadata.GET_TABLES);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getTables", originalCatalog, originalSchemaPattern, tableNamePattern, Arrays.toString(types));
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_TABLES, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String comment;
                    String kind;
                    String schemaName;
                    String dbName;
                    String tableName = this.showObjectResultSet.getString(2);
                    if (viewOnly) {
                        dbName = this.showObjectResultSet.getString(4);
                        schemaName = this.showObjectResultSet.getString(5);
                        kind = "VIEW";
                        comment = this.showObjectResultSet.getString(7);
                    } else {
                        dbName = this.showObjectResultSet.getString(3);
                        schemaName = this.showObjectResultSet.getString(4);
                        kind = this.showObjectResultSet.getString(5);
                        comment = this.showObjectResultSet.getString(6);
                    }
                    if (compiledTablePattern != null && !compiledTablePattern.matcher(tableName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches()) continue;
                    this.nextRow[0] = dbName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = tableName;
                    this.nextRow[3] = kind;
                    this.nextRow[4] = comment;
                    this.nextRow[5] = null;
                    this.nextRow[6] = null;
                    this.nextRow[7] = null;
                    this.nextRow[8] = null;
                    this.nextRow[9] = null;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        logger.trace("ResultSet getSchemas()", false);
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        logger.trace("ResultSet getCatalogs()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        String showDB = "show /* JDBC:DatabaseMetaData.getCatalogs() */ databases in account";
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_CATALOGS, statement.executeQuery(showDB), statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                if (this.showObjectResultSet.next()) {
                    String dbName = this.showObjectResultSet.getString(2);
                    this.nextRow[0] = dbName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        logger.trace("ResultSet getTableTypes()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Collections.singletonList("TABLE_TYPE"), Collections.singletonList("TEXT"), Collections.singletonList(12), new Object[][]{{"TABLE"}, {"VIEW"}}, statement);
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern, false);
    }

    public ResultSet getColumns(String originalCatalog, String originalSchemaPattern, String tableNamePattern, String columnNamePattern, final boolean extendedSet) throws SQLException {
        logger.trace("public ResultSet getColumns(String catalog={}, String schemaPattern={}, String tableNamePattern={}, String columnNamePattern={}, boolean extendedSet={}", originalCatalog, originalSchemaPattern, tableNamePattern, columnNamePattern, extendedSet);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        String schemaPattern = result.schema();
        boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledTablePattern = Wildcard.toRegexPattern(tableNamePattern, true);
        final Pattern compiledColumnPattern = Wildcard.toRegexPattern(columnNamePattern, true);
        String showColumnsCommand = "show /* JDBC:DatabaseMetaData.getColumns() */ columns";
        if (!(columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*"))) {
            showColumnsCommand = showColumnsCommand + " like '" + this.escapeSingleQuoteForLikeCommand(columnNamePattern) + "'";
        }
        if (catalog == null) {
            showColumnsCommand = showColumnsCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
            }
            String catalogEscaped = this.escapeSqlQuotes(catalog);
            if (schemaPattern == null || this.isSchemaNameWildcardPattern(schemaPattern)) {
                showColumnsCommand = showColumnsCommand + " in database \"" + catalogEscaped + "\"";
            } else {
                String schemaUnescaped;
                if (schemaPattern.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
                }
                String string = schemaUnescaped = isExactSchema ? schemaPattern : this.unescapeChars(schemaPattern);
                if (tableNamePattern == null || Wildcard.isWildcardPatternStr(tableNamePattern)) {
                    showColumnsCommand = showColumnsCommand + " in schema \"" + catalogEscaped + "\".\"" + schemaUnescaped + "\"";
                } else {
                    if (tableNamePattern.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, statement);
                    }
                    String tableNameUnescaped = this.unescapeChars(tableNamePattern);
                    showColumnsCommand = showColumnsCommand + " in table \"" + catalogEscaped + "\".\"" + schemaUnescaped + "\".\"" + tableNameUnescaped + "\"";
                }
            }
        }
        logger.debug("Sql command to get column metadata: {}", showColumnsCommand);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showColumnsCommand, extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getColumns", originalCatalog, originalSchemaPattern, tableNamePattern, columnNamePattern);
        return new SnowflakeDatabaseMetaDataQueryResultSet(extendedSet ? DBMetadataResultSetMetadata.GET_COLUMNS_EXTENDED_SET : DBMetadataResultSetMetadata.GET_COLUMNS, resultSet, statement){
            int ordinalPosition;
            String currentTableName;
            {
                super(metadataType, resultSet, statement);
                this.ordinalPosition = 0;
                this.currentTableName = null;
            }

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    int internalColumnType;
                    JsonNode jsonNode;
                    String tableName = this.showObjectResultSet.getString(1);
                    String schemaName = this.showObjectResultSet.getString(2);
                    String columnName = this.showObjectResultSet.getString(3);
                    String dataTypeStr = this.showObjectResultSet.getString(4);
                    String defaultValue = this.showObjectResultSet.getString(6);
                    defaultValue.trim();
                    if (defaultValue.isEmpty()) {
                        defaultValue = null;
                    } else if (!SnowflakeDatabaseMetaData.this.stringsQuoted && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                        defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
                        defaultValue = defaultValue.replace("''", "'");
                    }
                    String comment = this.showObjectResultSet.getString(9);
                    String catalogName = this.showObjectResultSet.getString(10);
                    String autoIncrement = this.showObjectResultSet.getString(11);
                    if (compiledTablePattern != null && !compiledTablePattern.matcher(tableName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() || compiledColumnPattern != null && !compiledColumnPattern.matcher(columnName).matches()) continue;
                    logger.debug("Found a matched column:" + tableName + "." + columnName, new Object[0]);
                    if (!tableName.equals(this.currentTableName)) {
                        this.ordinalPosition = 1;
                        this.currentTableName = tableName;
                    } else {
                        ++this.ordinalPosition;
                    }
                    try {
                        jsonNode = mapper.readTree(dataTypeStr);
                    }
                    catch (Exception ex) {
                        logger.error("Exception when parsing column result", ex);
                        throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "error parsing data type: " + dataTypeStr);
                    }
                    logger.debug("Data type string: {}", dataTypeStr);
                    SnowflakeColumnMetadata columnMetadata = new SnowflakeColumnMetadata(jsonNode, this.session.isJdbcTreatDecimalAsInt(), this.session);
                    logger.debug("Nullable: {}", columnMetadata.isNullable());
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = tableName;
                    this.nextRow[3] = columnName;
                    int externalColumnType = internalColumnType = columnMetadata.getType();
                    if (internalColumnType == 50000) {
                        externalColumnType = 93;
                    }
                    if (internalColumnType == 50001) {
                        externalColumnType = this.session == null ? 2014 : (this.session.getEnableReturnTimestampWithTimeZone() ? 2014 : 93);
                    }
                    this.nextRow[4] = externalColumnType;
                    this.nextRow[5] = columnMetadata.getTypeName();
                    int columnSize = 0;
                    if (columnMetadata.getType() == 12 || columnMetadata.getType() == 1 || columnMetadata.getType() == -2) {
                        columnSize = columnMetadata.getLength();
                    } else if (columnMetadata.getType() == 3 || columnMetadata.getType() == -5 || columnMetadata.getType() == 92 || columnMetadata.getType() == 93) {
                        columnSize = columnMetadata.getPrecision();
                    } else if (columnMetadata.getType() == 50003) {
                        columnSize = columnMetadata.getDimension();
                    }
                    this.nextRow[6] = columnSize;
                    this.nextRow[7] = null;
                    this.nextRow[8] = columnMetadata.getScale();
                    this.nextRow[9] = null;
                    this.nextRow[10] = columnMetadata.isNullable() ? 1 : 0;
                    logger.debug("Returning nullable: {}", this.nextRow[10]);
                    this.nextRow[11] = comment;
                    this.nextRow[12] = defaultValue;
                    this.nextRow[13] = externalColumnType;
                    this.nextRow[14] = null;
                    this.nextRow[15] = columnMetadata.getType() == 12 || columnMetadata.getType() == 1 ? Integer.valueOf(columnMetadata.getLength()) : null;
                    this.nextRow[16] = this.ordinalPosition;
                    this.nextRow[17] = columnMetadata.isNullable() ? "YES" : "NO";
                    this.nextRow[18] = null;
                    this.nextRow[19] = null;
                    this.nextRow[20] = null;
                    this.nextRow[21] = null;
                    this.nextRow[22] = "".equals(autoIncrement) ? "NO" : "YES";
                    this.nextRow[23] = "NO";
                    if (extendedSet) {
                        this.nextRow[24] = columnMetadata.getBase().name();
                    }
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        logger.trace("public ResultSet getColumnPrivileges(String catalog, String schema,String table, String columnNamePattern)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"), Arrays.asList("TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT", "TEXT"), Arrays.asList(12, 12, 12, 12, 12, 12, 12, 12), new Object[0][], statement);
    }

    @Override
    public ResultSet getTablePrivileges(String originalCatalog, String originalSchemaPattern, String tableNamePattern) throws SQLException {
        logger.trace("public ResultSet getTablePrivileges(String catalog, String schemaPattern,String tableNamePattern)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        if (tableNamePattern == null) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_TABLE_PRIVILEGES, statement);
        }
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        String schemaPattern = result.schema();
        boolean isExactSchema = result.isExactSchema();
        String showView = "select * from ";
        if (!(catalog == null || catalog.isEmpty() || catalog.trim().equals("%") || catalog.trim().equals(".*"))) {
            showView = showView + "\"" + this.escapeSqlQuotes(catalog) + "\".";
        }
        showView = showView + "information_schema.table_privileges";
        if (!(tableNamePattern == null || tableNamePattern.isEmpty() || tableNamePattern.trim().equals("%") || tableNamePattern.trim().equals(".*"))) {
            showView = showView + " where table_name = '" + tableNamePattern + "'";
        }
        if (!(schemaPattern == null || schemaPattern.isEmpty() || schemaPattern.trim().equals("%") || schemaPattern.trim().equals(".*"))) {
            String unescapedSchema = isExactSchema ? schemaPattern : this.unescapeChars(schemaPattern);
            showView = showView.contains("where table_name") ? showView + " and table_schema = '" + unescapedSchema + "'" : showView + " where table_schema = '" + unescapedSchema + "'";
        }
        showView = showView + " order by table_catalog, table_schema, table_name, privilege_type";
        final String catalogIn = catalog;
        final String schemaIn = schemaPattern;
        final String tableIn = tableNamePattern;
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showView, DBMetadataResultSetMetadata.GET_TABLE_PRIVILEGES);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getTablePrivileges", originalCatalog, originalSchemaPattern, tableNamePattern, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_TABLE_PRIVILEGES, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String table_cat = this.showObjectResultSet.getString("TABLE_CATALOG");
                    String table_schema = this.showObjectResultSet.getString("TABLE_SCHEMA");
                    String table_name = this.showObjectResultSet.getString("TABLE_NAME");
                    String grantor = this.showObjectResultSet.getString("GRANTOR");
                    String grantee = this.showObjectResultSet.getString("GRANTEE");
                    String privilege = this.showObjectResultSet.getString("PRIVILEGE_TYPE");
                    String is_grantable = this.showObjectResultSet.getString("IS_GRANTABLE");
                    if (catalogIn != null && !catalogIn.trim().equals("%") && !catalogIn.trim().equals(table_cat) || schemaIn != null && !schemaIn.trim().equals("%") && !schemaIn.trim().equals(table_schema) || !tableIn.trim().equals(table_name) && !tableIn.trim().equals("%")) continue;
                    this.nextRow[0] = table_cat;
                    this.nextRow[1] = table_schema;
                    this.nextRow[2] = table_name;
                    this.nextRow[3] = grantor;
                    this.nextRow[4] = grantee;
                    this.nextRow[5] = privilege;
                    this.nextRow[6] = is_grantable;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        logger.trace("public ResultSet getBestRowIdentifier(String catalog, String schema,String table, int scope,boolean nullable)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        logger.trace("public ResultSet getVersionColumns(String catalog, String schema, String table)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getPrimaryKeys(String originalCatalog, String originalSchema, String table) throws SQLException {
        logger.trace("public ResultSet getPrimaryKeys(String catalog={}, String schema={}, String table={})", originalCatalog, originalSchema, table);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        String showPKCommand = "show /* JDBC:DatabaseMetaData.getPrimaryKeys() */ primary keys in ";
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchema);
        String catalog = result.database();
        String schema = result.schema();
        boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schema, true);
        final Pattern compiledTablePattern = Wildcard.toRegexPattern(table, true);
        if (catalog == null) {
            showPKCommand = showPKCommand + "account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
            }
            String catalogUnescaped = this.escapeSqlQuotes(catalog);
            if (schema == null || this.isPatternMatchingEnabled && this.isSchemaNameWildcardPattern(schema)) {
                showPKCommand = showPKCommand + "database \"" + catalogUnescaped + "\"";
            } else {
                String schemaUnescaped;
                if (schema.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
                }
                String string = schemaUnescaped = isExactSchema ? schema : this.unescapeChars(schema);
                if (table == null) {
                    showPKCommand = showPKCommand + "schema \"" + catalogUnescaped + "\".\"" + schemaUnescaped + "\"";
                } else {
                    if (table.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, statement);
                    }
                    String tableUnescaped = this.unescapeChars(table);
                    showPKCommand = showPKCommand + "table \"" + catalogUnescaped + "\".\"" + schemaUnescaped + "\".\"" + tableUnescaped + "\"";
                }
            }
        }
        final String catalogIn = catalog;
        final String schemaIn = schema;
        final String tableIn = table;
        logger.debug("Sql command to get primary key metadata: {}", showPKCommand);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showPKCommand, DBMetadataResultSetMetadata.GET_PRIMARY_KEYS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getPrimaryKeys", originalCatalog, originalSchema, table, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_PRIMARY_KEYS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String table_cat = this.showObjectResultSet.getString(2);
                    String table_schem = this.showObjectResultSet.getString(3);
                    String table_name = this.showObjectResultSet.getString(4);
                    String column_name = this.showObjectResultSet.getString(5);
                    int key_seq = this.showObjectResultSet.getInt(6);
                    String pk_name = this.showObjectResultSet.getString(7);
                    boolean isMatch = false;
                    isMatch = SnowflakeDatabaseMetaData.this.isPatternMatchingEnabled ? this.isPrimaryKeyPatternSearch(table_cat, table_schem, table_name, column_name, key_seq, pk_name) : this.isPrimaryKeyExactSearch(table_cat, table_schem, table_name, column_name, key_seq, pk_name);
                    if (!isMatch) continue;
                    this.createPrimaryKeyRow(table_cat, table_schem, table_name, column_name, key_seq, pk_name);
                    return true;
                }
                this.close();
                return false;
            }

            private boolean isPrimaryKeyExactSearch(String table_cat, String table_schem, String table_name, String column_name, int key_seq, String pk_name) {
                return !(catalogIn != null && !catalogIn.equals(table_cat) || schemaIn != null && !schemaIn.equals(table_schem) || tableIn != null && !tableIn.equals(table_name));
            }

            private boolean isPrimaryKeyPatternSearch(String table_cat, String table_schem, String table_name, String column_name, int key_seq, String pk_name) {
                return !(catalogIn != null && !catalogIn.equals(table_cat) || compiledSchemaPattern != null && !compiledSchemaPattern.equals(table_schem) && !compiledSchemaPattern.matcher(table_schem).matches() || compiledTablePattern != null && !compiledTablePattern.equals(table_name) && !compiledTablePattern.matcher(table_name).matches());
            }

            private void createPrimaryKeyRow(String table_cat, String table_schem, String table_name, String column_name, int key_seq, String pk_name) {
                this.nextRow[0] = table_cat;
                this.nextRow[1] = table_schem;
                this.nextRow[2] = table_name;
                this.nextRow[3] = column_name;
                this.nextRow[4] = key_seq;
                this.nextRow[5] = pk_name;
            }
        };
    }

    private ResultSet getForeignKeys(final String client, String originalParentCatalog, String originalParentSchema, String parentTable, final String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        StringBuilder commandBuilder = new StringBuilder();
        ContextAwareMetadataSearch result = this.applySessionContext(originalParentCatalog, originalParentSchema);
        String parentCatalog = result.database();
        String parentSchema = result.schema();
        boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(parentSchema, true);
        final Pattern compiledParentTablePattern = Wildcard.toRegexPattern(parentTable, true);
        final Pattern compiledForeignSchemaPattern = Wildcard.toRegexPattern(foreignSchema, true);
        final Pattern compiledForeignTablePattern = Wildcard.toRegexPattern(foreignTable, true);
        if (client.equals("export") || client.equals("cross")) {
            commandBuilder.append("show /* JDBC:DatabaseMetaData.getForeignKeys() */ exported keys in ");
        } else if (client.equals("import")) {
            commandBuilder.append("show /* JDBC:DatabaseMetaData.getForeignKeys() */ imported keys in ");
        }
        if (parentCatalog == null) {
            commandBuilder.append("account");
        } else {
            if (parentCatalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
            }
            String unescapedParentCatalog = this.escapeSqlQuotes(parentCatalog);
            if (parentSchema == null || this.isPatternMatchingEnabled && this.isSchemaNameWildcardPattern(parentSchema)) {
                commandBuilder.append("database \"" + unescapedParentCatalog + "\"");
            } else {
                String unescapedParentSchema;
                if (parentSchema.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
                }
                String string = unescapedParentSchema = isExactSchema ? parentSchema : this.unescapeChars(parentSchema);
                if (parentTable == null) {
                    commandBuilder.append("schema \"" + unescapedParentCatalog + "\".\"" + unescapedParentSchema + "\"");
                } else {
                    if (parentTable.isEmpty()) {
                        return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, statement);
                    }
                    String unescapedParentTable = this.unescapeChars(parentTable);
                    commandBuilder.append("table \"" + unescapedParentCatalog + "\".\"" + unescapedParentSchema + "\".\"" + unescapedParentTable + "\"");
                }
            }
        }
        final String finalParentCatalog = parentCatalog;
        final String finalForeignCatalog = foreignCatalog;
        final String finalParentSchema = parentSchema;
        final String finalParentTable = parentTable;
        final String finalForeignSchema = foreignSchema;
        final String finalForeignTable = foreignTable;
        String command = commandBuilder.toString();
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, command, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getForeignKeys", originalParentCatalog, originalParentSchema, parentTable, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_FOREIGN_KEYS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String pktable_cat = this.showObjectResultSet.getString(2);
                    String pktable_schem = this.showObjectResultSet.getString(3);
                    String pktable_name = this.showObjectResultSet.getString(4);
                    String pkcolumn_name = this.showObjectResultSet.getString(5);
                    String fktable_cat = this.showObjectResultSet.getString(6);
                    String fktable_schem = this.showObjectResultSet.getString(7);
                    String fktable_name = this.showObjectResultSet.getString(8);
                    String fkcolumn_name = this.showObjectResultSet.getString(9);
                    int key_seq = this.showObjectResultSet.getInt(10);
                    short updateRule = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("update", this.showObjectResultSet.getString(11));
                    short deleteRule = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("delete", this.showObjectResultSet.getString(12));
                    String fk_name = this.showObjectResultSet.getString(13);
                    String pk_name = this.showObjectResultSet.getString(14);
                    short deferrability = SnowflakeDatabaseMetaData.this.getForeignKeyConstraintProperty("deferrability", this.showObjectResultSet.getString(15));
                    boolean passedFilter = false;
                    passedFilter = SnowflakeDatabaseMetaData.this.isPatternMatchingEnabled ? this.isForeignKeyPatternMatch(fktable_cat, fktable_schem, fktable_name, passedFilter, pktable_cat, pktable_schem, pktable_name) : this.isForeignKeyExactMatch(fktable_cat, fktable_schem, fktable_name, passedFilter, pktable_cat, pktable_schem, pktable_name);
                    if (!passedFilter) continue;
                    this.createForeinKeyRow(pktable_cat, pktable_schem, pktable_name, pkcolumn_name, fktable_cat, fktable_schem, fktable_name, fkcolumn_name, key_seq, updateRule, deleteRule, fk_name, pk_name, deferrability);
                    return true;
                }
                this.close();
                return false;
            }

            private void createForeinKeyRow(String pktable_cat, String pktable_schem, String pktable_name, String pkcolumn_name, String fktable_cat, String fktable_schem, String fktable_name, String fkcolumn_name, int key_seq, short updateRule, short deleteRule, String fk_name, String pk_name, short deferrability) {
                this.nextRow[0] = pktable_cat;
                this.nextRow[1] = pktable_schem;
                this.nextRow[2] = pktable_name;
                this.nextRow[3] = pkcolumn_name;
                this.nextRow[4] = fktable_cat;
                this.nextRow[5] = fktable_schem;
                this.nextRow[6] = fktable_name;
                this.nextRow[7] = fkcolumn_name;
                this.nextRow[8] = key_seq;
                this.nextRow[9] = updateRule;
                this.nextRow[10] = deleteRule;
                this.nextRow[11] = fk_name;
                this.nextRow[12] = pk_name;
                this.nextRow[13] = deferrability;
            }

            private boolean isForeignKeyExactMatch(String fktable_cat, String fktable_schem, String fktable_name, boolean passedFilter, String pktable_cat, String pktable_schem, String pktable_name) {
                if (client.equals("import")) {
                    if (!(finalParentCatalog != null && !finalParentCatalog.equals(fktable_cat) || finalParentSchema != null && !finalParentSchema.equals(fktable_schem) || finalParentTable != null && !finalParentTable.equals(fktable_name))) {
                        passedFilter = true;
                    }
                } else if (client.equals("export")) {
                    if (!(finalParentCatalog != null && !finalParentCatalog.equals(pktable_cat) || finalParentSchema != null && !finalParentSchema.equals(pktable_schem) || finalParentTable != null && !finalParentTable.equals(pktable_name))) {
                        passedFilter = true;
                    }
                } else if (!(!client.equals("cross") || finalParentCatalog != null && !finalParentCatalog.equals(pktable_cat) || finalParentSchema != null && !finalParentSchema.equals(pktable_schem) || finalParentTable != null && !finalParentTable.equals(pktable_name) || finalForeignCatalog != null && !finalForeignCatalog.equals(fktable_cat) || finalForeignSchema != null && !finalForeignSchema.equals(fktable_schem) || finalForeignTable != null && !finalForeignTable.equals(fktable_name))) {
                    passedFilter = true;
                }
                return passedFilter;
            }

            private boolean isForeignKeyPatternMatch(String fktable_cat, String fktable_schem, String fktable_name, boolean passedFilter, String pktable_cat, String pktable_schem, String pktable_name) {
                if (client.equals("import")) {
                    if ((finalParentCatalog == null || finalParentCatalog.equals(fktable_cat)) && (compiledSchemaPattern == null || compiledSchemaPattern.equals(fktable_schem) || compiledSchemaPattern.matcher(fktable_schem).matches()) && (compiledParentTablePattern == null || compiledParentTablePattern.equals(fktable_name) || compiledParentTablePattern.matcher(fktable_name).matches())) {
                        passedFilter = true;
                    }
                } else if (client.equals("export")) {
                    if ((finalParentCatalog == null || finalParentCatalog.equals(pktable_cat)) && (compiledSchemaPattern == null || compiledSchemaPattern.equals(pktable_schem) || compiledSchemaPattern.matcher(pktable_schem).matches()) && (compiledParentTablePattern == null || compiledParentTablePattern.equals(pktable_name) || compiledParentTablePattern.matcher(pktable_name).matches())) {
                        passedFilter = true;
                    }
                } else if (client.equals("cross") && (finalParentCatalog == null || finalParentCatalog.equals(pktable_cat)) && (compiledSchemaPattern == null || compiledSchemaPattern.equals(pktable_schem) || compiledSchemaPattern.matcher(pktable_schem).matches()) && (compiledParentTablePattern == null || compiledParentTablePattern.equals(pktable_name) || compiledParentTablePattern.matcher(pktable_name).matches()) && (foreignCatalog == null || foreignCatalog.equals(fktable_cat)) && (compiledForeignSchemaPattern == null || compiledForeignSchemaPattern.equals(fktable_schem) || compiledForeignSchemaPattern.matcher(fktable_schem).matches()) && (compiledForeignTablePattern == null || compiledForeignTablePattern.equals(fktable_name) || compiledForeignTablePattern.matcher(fktable_name).matches())) {
                    passedFilter = true;
                }
                return passedFilter;
            }
        };
    }

    private short getForeignKeyConstraintProperty(String property_name, String property) {
        int result = 0;
        block5 : switch (property_name) {
            case "update": 
            case "delete": {
                switch (property) {
                    case "NO ACTION": {
                        result = 3;
                        break;
                    }
                    case "CASCADE": {
                        result = 0;
                        break;
                    }
                    case "SET NULL": {
                        result = 2;
                        break;
                    }
                    case "SET DEFAULT": {
                        result = 4;
                        break;
                    }
                    case "RESTRICT": {
                        result = 1;
                    }
                }
                break;
            }
            case "deferrability": {
                switch (property) {
                    case "INITIALLY DEFERRED": {
                        result = 5;
                        break block5;
                    }
                    case "INITIALLY IMMEDIATE": {
                        result = 6;
                        break block5;
                    }
                    case "NOT DEFERRABLE": {
                        result = 7;
                    }
                }
            }
        }
        return (short)result;
    }

    @Override
    public ResultSet getImportedKeys(String originalCatalog, String originalSchema, String table) throws SQLException {
        logger.trace("public ResultSet getImportedKeys(String catalog={}, String schema={}, String table={})", originalCatalog, originalSchema, table);
        return this.getForeignKeys("import", originalCatalog, originalSchema, table, null, null, null);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        logger.trace("public ResultSet getExportedKeys(String catalog={}, String schema={}, String table={})", catalog, schema, table);
        return this.getForeignKeys("export", catalog, schema, table, null, null, null);
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        logger.trace("public ResultSet getCrossReference(String parentCatalog={}, String parentSchema={}, String parentTable={}, String foreignCatalog={}, String foreignSchema={}, String foreignTable={})", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        return this.getForeignKeys("cross", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        logger.trace("ResultSet getTypeInfo()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"), Arrays.asList("TEXT", "INTEGER", "INTEGER", "TEXT", "TEXT", "TEXT", "SHORT", "BOOLEAN", "SHORT", "BOOLEAN", "BOOLEAN", "BOOLEAN", "TEXT", "SHORT", "SHORT", "INTEGER", "INTEGER", "INTEGER"), Arrays.asList(12, 4, 4, 12, 12, 12, 5, 16, 5, 16, 16, 16, 12, 5, 5, 4, 4, 4), new Object[][]{{"NUMBER", 3, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 37, -1, -1, -1}, {"INTEGER", 4, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 0, -1, -1, -1}, {"DOUBLE", 8, 38, null, null, null, 1, false, 3, false, true, true, null, 0, 37, -1, -1, -1}, {"VARCHAR", 12, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"DATE", 91, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"TIME", 92, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"TIMESTAMP", 93, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}, {"BOOLEAN", 16, -1, null, null, null, 1, false, 3, false, true, true, null, -1, -1, -1, -1, -1}}, statement);
    }

    public ResultSet getStreams(String originalCatalog, String originalSchemaPattern, final String streamName) throws SQLException {
        logger.trace("public ResultSet getStreams(String catalog={}, String schemaPattern={}String streamName={}", originalCatalog, originalSchemaPattern, streamName);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        String schemaPattern = result.schema();
        boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledStreamNamePattern = Wildcard.toRegexPattern(streamName, true);
        String showStreamsCommand = "show streams";
        if (!(streamName == null || streamName.isEmpty() || streamName.trim().equals("%") || streamName.trim().equals(".*"))) {
            showStreamsCommand = showStreamsCommand + " like '" + this.escapeSingleQuoteForLikeCommand(streamName) + "'";
        }
        if (catalog == null) {
            showStreamsCommand = showStreamsCommand + " in account";
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_STREAMS, statement);
            }
            String catalogEscaped = this.escapeSqlQuotes(catalog);
            if (schemaPattern == null || this.isSchemaNameWildcardPattern(schemaPattern)) {
                showStreamsCommand = showStreamsCommand + " in database \"" + catalogEscaped + "\"";
            } else {
                String schemaUnescaped;
                if (schemaPattern.isEmpty()) {
                    return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_STREAMS, statement);
                }
                String string = schemaUnescaped = isExactSchema ? schemaPattern : this.unescapeChars(schemaPattern);
                if (streamName == null || Wildcard.isWildcardPatternStr(streamName)) {
                    showStreamsCommand = showStreamsCommand + " in schema \"" + catalogEscaped + "\".\"" + schemaUnescaped + "\"";
                }
            }
        }
        logger.debug("Sql command to get stream metadata: {}", showStreamsCommand);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showStreamsCommand, DBMetadataResultSetMetadata.GET_STREAMS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getStreams", originalCatalog, originalSchemaPattern, streamName, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_STREAMS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", new Object[0]);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String name = this.showObjectResultSet.getString(2);
                    String databaseName = this.showObjectResultSet.getString(3);
                    String schemaName = this.showObjectResultSet.getString(4);
                    String owner = this.showObjectResultSet.getString(5);
                    String comment = this.showObjectResultSet.getString(6);
                    String tableName = this.showObjectResultSet.getString(7);
                    String sourceType = this.showObjectResultSet.getString(8);
                    String baseTables = this.showObjectResultSet.getString(9);
                    String type = this.showObjectResultSet.getString(10);
                    String stale = this.showObjectResultSet.getString(11);
                    String mode = this.showObjectResultSet.getString(12);
                    if (compiledStreamNamePattern != null && !compiledStreamNamePattern.matcher(streamName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() || compiledStreamNamePattern != null && !compiledStreamNamePattern.matcher(streamName).matches()) continue;
                    logger.debug("Found a matched column:" + tableName + "." + streamName, new Object[0]);
                    this.nextRow[0] = name;
                    this.nextRow[1] = databaseName;
                    this.nextRow[2] = schemaName;
                    this.nextRow[3] = owner;
                    this.nextRow[4] = comment;
                    this.nextRow[5] = tableName;
                    this.nextRow[6] = sourceType;
                    this.nextRow[7] = baseTables;
                    this.nextRow[8] = type;
                    this.nextRow[9] = stale;
                    this.nextRow[10] = mode;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        logger.trace("public ResultSet getIndexInfo(String catalog, String schema, String table,boolean unique, boolean approximate)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"), Arrays.asList("TEXT", "TEXT", "TEXT", "BOOLEAN", "TEXT", "TEXT", "SHORT", "SHORT", "TEXT", "TEXT", "INTEGER", "INTEGER", "TEXT"), Arrays.asList(12, 12, 12, 16, 12, 12, 5, 5, 12, 12, 4, 4, 12), new Object[0][], statement);
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        logger.trace("boolean supportsResultSetType(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        logger.trace("public boolean supportsResultSetConcurrency(int type, int concurrency)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        logger.trace("boolean ownUpdatesAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        logger.trace("boolean ownDeletesAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        logger.trace("boolean ownInsertsAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        logger.trace("boolean othersUpdatesAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        logger.trace("boolean othersDeletesAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        logger.trace("boolean othersInsertsAreVisible(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        logger.trace("boolean updatesAreDetected(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        logger.trace("boolean deletesAreDetected(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        logger.trace("boolean insertsAreDetected(int type)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        logger.trace("boolean supportsBatchUpdates()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        logger.trace("public ResultSet getUDTs(String catalog, String schemaPattern,String typeNamePattern, int[] types)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        return new SnowflakeDatabaseMetaDataResultSet(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList("TEXT", "TEXT", "TEXT", "TEXT", "INTEGER", "TEXT", "SHORT"), Arrays.asList(12, 12, 12, 12, 4, 12, 5), new Object[0][], statement);
    }

    @Override
    public Connection getConnection() throws SQLException {
        logger.trace("Connection getConnection()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        logger.trace("boolean supportsSavepoints()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        logger.trace("boolean supportsNamedParameters()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        logger.trace("boolean supportsMultipleOpenResults()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        logger.trace("boolean supportsGetGeneratedKeys()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        logger.trace("public ResultSet getSuperTypes(String catalog, String schemaPattern,String typeNamePattern)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        logger.trace("public ResultSet getSuperTables(String catalog, String schemaPattern,String tableNamePattern)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        logger.trace("public ResultSet getAttributes(String catalog, String schemaPattern,String typeNamePattern,String attributeNamePattern)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        logger.trace("boolean supportsResultSetHoldability(int holdability)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        logger.trace("int getResultSetHoldability()", false);
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        logger.trace("int getDatabaseMajorVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        logger.trace("int getDatabaseMinorVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return this.connection.unwrap(SnowflakeConnectionV1.class).getDatabaseMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        logger.trace("int getJDBCMajorVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Integer.parseInt(JDBCVersion.split("\\.", 2)[0]);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        logger.trace("int getJDBCMinorVersion()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return Integer.parseInt(JDBCVersion.split("\\.", 2)[1]);
    }

    @Override
    public int getSQLStateType() throws SQLException {
        logger.trace("int getSQLStateType()", false);
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        logger.trace("boolean locatorsUpdateCopy()", false);
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        logger.trace("boolean supportsStatementPooling()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        logger.trace("RowIdLifetime getRowIdLifetime()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getSchemas(String originalCatalog, String originalSchema) throws SQLException {
        logger.trace("public ResultSet getSchemas(String catalog={}, String schemaPattern={})", originalCatalog, originalSchema);
        this.raiseSQLExceptionIfConnectionIsClosed();
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchema);
        String catalog = result.database();
        final String schemaPattern = result.schema();
        final boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        StringBuilder showSchemas = new StringBuilder("show /* JDBC:DatabaseMetaData.getSchemas() */ schemas");
        Statement statement = this.connection.createStatement();
        if (isExactSchema) {
            String escapedSchema = schemaPattern.replaceAll("_", "\\\\\\\\_").replaceAll("%", "\\\\\\\\%");
            showSchemas.append(" like '").append(escapedSchema).append("'");
        } else if (!(schemaPattern == null || schemaPattern.isEmpty() || schemaPattern.trim().equals("%") || schemaPattern.trim().equals(".*"))) {
            showSchemas.append(" like '").append(this.escapeSingleQuoteForLikeCommand(schemaPattern)).append("'");
        }
        if (catalog == null) {
            showSchemas.append(" in account");
        } else {
            if (catalog.isEmpty()) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_SCHEMAS, statement);
            }
            showSchemas.append(" in database \"").append(this.escapeSqlQuotes(catalog)).append("\"");
        }
        String sqlQuery = showSchemas.toString();
        logger.debug("Sql command to get schemas metadata: {}", sqlQuery);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, sqlQuery, DBMetadataResultSetMetadata.GET_SCHEMAS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getSchemas", originalCatalog, originalSchema, "none", "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_SCHEMAS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String schemaName = this.showObjectResultSet.getString(2);
                    String dbName = this.showObjectResultSet.getString(5);
                    if (compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() && (!isExactSchema || !schemaPattern.equals(schemaPattern))) continue;
                    this.nextRow[0] = schemaName;
                    this.nextRow[1] = dbName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        logger.trace("boolean supportsStoredFunctionsUsingCallSyntax()", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        logger.trace("boolean autoCommitFailureClosesAllResultSets()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        logger.trace("ResultSet getClientInfoProperties()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public ResultSet getFunctions(String originalCatalog, String originalSchemaPattern, String functionNamePattern) throws SQLException {
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        logger.trace("public ResultSet getFunctions(String catalog={}, String schemaPattern={}, String functionNamePattern={}", originalCatalog, originalSchemaPattern, functionNamePattern);
        String showFunctionCommand = this.getFirstResultSetCommand(originalCatalog, originalSchemaPattern, functionNamePattern, "functions");
        if (showFunctionCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FUNCTIONS, statement);
        }
        ContextAwareMetadataSearch result = this.applySessionContext(originalCatalog, originalSchemaPattern);
        String catalog = result.database();
        final String schemaPattern = result.schema();
        final boolean isExactSchema = result.isExactSchema();
        final Pattern compiledSchemaPattern = Wildcard.toRegexPattern(schemaPattern, true);
        final Pattern compiledFunctionPattern = Wildcard.toRegexPattern(functionNamePattern, true);
        ResultSet resultSet = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionCommand, DBMetadataResultSetMetadata.GET_FUNCTIONS);
        this.sendInBandTelemetryMetadataMetrics(resultSet, "getFunctions", catalog, schemaPattern, functionNamePattern, "none");
        return new SnowflakeDatabaseMetaDataQueryResultSet(DBMetadataResultSetMetadata.GET_FUNCTIONS, resultSet, statement){

            @Override
            public boolean next() throws SQLException {
                logger.trace("boolean next()", false);
                this.incrementRow();
                while (this.showObjectResultSet.next()) {
                    String catalogName = this.showObjectResultSet.getString(11);
                    String schemaName = this.showObjectResultSet.getString(3);
                    String functionName = this.showObjectResultSet.getString(2);
                    String remarks = this.showObjectResultSet.getString(10);
                    int functionType = "Y".equals(this.showObjectResultSet.getString(12)) ? 2 : 1;
                    String specificName = functionName;
                    if (compiledFunctionPattern != null && !compiledFunctionPattern.matcher(functionName).matches() || compiledSchemaPattern != null && !compiledSchemaPattern.matcher(schemaName).matches() && (!isExactSchema || !schemaPattern.equals(schemaPattern))) continue;
                    logger.debug("Found a matched function:" + schemaName + "." + functionName, new Object[0]);
                    this.nextRow[0] = catalogName;
                    this.nextRow[1] = schemaName;
                    this.nextRow[2] = functionName;
                    this.nextRow[3] = remarks;
                    this.nextRow[4] = functionType;
                    this.nextRow[5] = specificName;
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    private List<String> parseColumns(String retType, String args) {
        int i;
        ArrayList<String> columns = new ArrayList<String>();
        if (retType.substring(0, 5).equalsIgnoreCase("table")) {
            String typeStr = retType.substring(retType.indexOf(40) + 1, retType.lastIndexOf(41));
            String[] types = typeStr.split("\\s+|, ");
            if (types.length != 1) {
                for (i = 0; i < types.length; ++i) {
                    columns.add(types[i]);
                }
                this.procedureResultsetColumnNum = columns.size() / 2;
            }
        } else {
            columns.add("");
            columns.add(retType);
            this.procedureResultsetColumnNum = -1;
        }
        String argStr = args.substring(args.indexOf(40) + 1, args.lastIndexOf(41));
        String[] arguments = argStr.split("\\s+|, ");
        if (arguments.length != 1) {
            for (i = 0; i < arguments.length; ++i) {
                columns.add(arguments[i]);
            }
        }
        return columns;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        logger.trace("public ResultSet getFunctionColumns(String catalog, String schemaPattern,String functionNamePattern,String columnNamePattern)", false);
        this.raiseSQLExceptionIfConnectionIsClosed();
        Statement statement = this.connection.createStatement();
        boolean addAllRows = false;
        String showFunctionCommand = this.getFirstResultSetCommand(catalog, schemaPattern, functionNamePattern, "functions");
        if (showFunctionCommand.isEmpty()) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS, statement);
        }
        if (columnNamePattern == null || columnNamePattern.isEmpty() || columnNamePattern.trim().equals("%") || columnNamePattern.trim().equals(".*")) {
            addAllRows = true;
        }
        ResultSet resultSetStepOne = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionCommand, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
        this.sendInBandTelemetryMetadataMetrics(resultSetStepOne, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSetStepOne.next()) {
            int i;
            String functionNameUnparsed = resultSetStepOne.getString("arguments").trim();
            String functionNameNoArgs = resultSetStepOne.getString("name");
            String realSchema = resultSetStepOne.getString("schema_name");
            String realDatabase = resultSetStepOne.getString("catalog_name");
            String showFunctionColCommand = this.getSecondResultSetCommand(realDatabase, realSchema, functionNameUnparsed, "function");
            ResultSet resultSetStepTwo = this.executeAndReturnEmptyResultIfNotFound(statement, showFunctionColCommand, DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS);
            if (!resultSetStepTwo.next()) continue;
            String args = resultSetStepTwo.getString("value");
            resultSetStepTwo.next();
            String res = resultSetStepTwo.getString("value");
            List<String> functionCols = this.parseColumns(res, args);
            String[] paramNames = new String[functionCols.size() / 2];
            String[] paramTypes = new String[functionCols.size() / 2];
            if (functionCols.size() > 1) {
                for (i = 0; i < functionCols.size(); ++i) {
                    if (i % 2 == 0) {
                        paramNames[i / 2] = functionCols.get(i);
                        continue;
                    }
                    paramTypes[i / 2] = functionCols.get(i);
                }
            }
            for (i = 0; i < paramNames.length; ++i) {
                if (i != 0 && !paramNames[i].equalsIgnoreCase(columnNamePattern) && !addAllRows) continue;
                Object[] nextRow = new Object[17];
                nextRow[0] = catalog;
                nextRow[1] = schemaPattern;
                nextRow[2] = functionNameNoArgs;
                nextRow[3] = paramNames[i];
                nextRow[4] = i == 0 && this.procedureResultsetColumnNum < 0 ? Integer.valueOf(4) : (this.procedureResultsetColumnNum >= 0 && i < this.procedureResultsetColumnNum ? Integer.valueOf(5) : Integer.valueOf(1));
                String typeName = paramTypes[i];
                int type = SnowflakeType.convertStringToType(typeName);
                nextRow[5] = type;
                nextRow[6] = typeName;
                int precision = 38;
                short scale = 0;
                if (type < 10) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        precision = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(44)));
                        scale = Short.parseShort(typeName.substring(typeName.indexOf(44) + 1, typeName.indexOf(41)));
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    } else if (type == 6) {
                        nextRow[7] = 0;
                        nextRow[9] = null;
                    } else {
                        nextRow[7] = precision;
                        nextRow[9] = scale;
                    }
                } else {
                    nextRow[7] = 0;
                    nextRow[9] = null;
                }
                nextRow[8] = 0;
                nextRow[10] = 10;
                nextRow[11] = 2;
                nextRow[12] = resultSetStepOne.getString("description").trim();
                if (type == -2 || type == -3 || type == 1 || type == 12) {
                    if (typeName.contains("(") && typeName.contains(")")) {
                        int char_octet_len = Integer.parseInt(typeName.substring(typeName.indexOf(40) + 1, typeName.indexOf(41)));
                        nextRow[13] = char_octet_len;
                    } else if (type == 1 || type == 12) {
                        nextRow[13] = this.getMaxCharLiteralLength();
                    } else if (type == -2 || type == -3) {
                        nextRow[13] = this.getMaxBinaryLiteralLength();
                    }
                } else {
                    nextRow[13] = null;
                }
                nextRow[14] = this.procedureResultsetColumnNum >= 0 ? (i < this.procedureResultsetColumnNum ? Integer.valueOf(i + 1) : Integer.valueOf(i - this.procedureResultsetColumnNum + 1)) : Integer.valueOf(i);
                nextRow[15] = "";
                nextRow[16] = functionNameUnparsed;
                rows.add(nextRow);
            }
        }
        Object[][] resultRows = new Object[rows.size()][17];
        for (int i = 0; i < resultRows.length; ++i) {
            resultRows[i] = (Object[])rows.get(i);
        }
        return new SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata.GET_FUNCTION_COLUMNS, resultRows, statement);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        logger.trace("public ResultSet getPseudoColumns(String catalog, String schemaPattern,String tableNamePattern,String columnNamePattern)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        logger.trace("boolean generatedKeyAlwaysReturned()", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.trace("<T> T unwrap(Class<T> iface)", false);
        if (!iface.isInstance(this)) {
            throw new SQLException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.trace("boolean isWrapperFor(Class<?> iface)", false);
        throw new SnowflakeLoggedFeatureNotSupportedException(this.session);
    }

    private ResultSet executeAndReturnEmptyResultIfNotFound(Statement statement, String sql, DBMetadataResultSetMetadata metadataType) throws SQLException {
        ResultSet resultSet;
        if (Strings.isNullOrEmpty((String)sql)) {
            return SnowflakeDatabaseMetaDataResultSet.getEmptyResultSet(metadataType, statement);
        }
        try {
            resultSet = statement.executeQuery(sql);
        }
        catch (SnowflakeSQLException e) {
            if (e.getSQLState().equals("02000") || e.getSQLState().equals("42S02") || e.getMessage().contains("Operation is not supported in reader account")) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResult(metadataType, statement, e.getQueryId());
            }
            if (sql.contains("desc function") && e.getSQLState().equals("42000")) {
                return SnowflakeDatabaseMetaDataResultSet.getEmptyResult(metadataType, statement, e.getQueryId());
            }
            throw e;
        }
        return resultSet;
    }

    private static class ContextAwareMetadataSearch {
        private final String database;
        private final String schema;
        private final boolean isExactSchema;

        public ContextAwareMetadataSearch(String database, String schema, boolean isExactSchema) {
            this.database = database;
            this.schema = schema;
            this.isExactSchema = isExactSchema;
        }

        public String database() {
            return this.database;
        }

        public String schema() {
            return this.schema;
        }

        public boolean isExactSchema() {
            return this.isExactSchema;
        }
    }
}

