/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.Map;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.jdbc.ErrorCode;

public class SFLoginInput {
    private String serverUrl;
    private String databaseName;
    private String schemaName;
    private String warehouse;
    private String role;
    private boolean validateDefaultParameters;
    private String originalAuthenticator;
    private String authenticator;
    private String oktaUserName;
    private String accountName;
    private int loginTimeout = -1;
    private int retryTimeout = 300;
    private int authTimeout = 0;
    private String userName;
    private String password;
    private boolean passcodeInPassword;
    private String passcode;
    private String token;
    private Duration connectionTimeout = HttpUtil.getConnectionTimeout();
    private Duration socketTimeout = HttpUtil.getSocketTimeout();
    private String appId;
    private String appVersion;
    private String sessionToken;
    private String masterToken;
    private Map<String, Object> sessionParameters;
    private PrivateKey privateKey;
    private String application;
    private String idToken;
    private String mfaToken;
    private String oauthAccessToken;
    private String oauthRefreshToken;
    private String dpopPublicKey;
    private boolean dpopEnabled = false;
    private String serviceName;
    private OCSPMode ocspMode;
    private HttpClientSettingsKey httpClientKey;
    private String privateKeyFile;
    private String privateKeyBase64;
    private String privateKeyPwd;
    private String inFlightCtx;
    private SFOauthLoginInput oauthLoginInput;
    private boolean disableConsoleLogin = true;
    private boolean disableSamlURLCheck = false;
    private boolean enableClientStoreTemporaryCredential;
    private boolean enableClientRequestMfaToken;
    private String workloadIdentityProvider;
    private WorkloadIdentityAttestation workloadIdentityAttestation;
    private String workloadIdentityEntraResource;
    private int redirectUriPort = -1;
    private String clientId;
    private String clientSecret;
    private Duration browserResponseTimeout;
    Map<String, String> additionalHttpHeadersForSnowsight;

    @SnowflakeJdbcInternalApi
    public SFLoginInput() {
    }

    Duration getBrowserResponseTimeout() {
        return this.browserResponseTimeout;
    }

    SFLoginInput setBrowserResponseTimeout(Duration browserResponseTimeout) {
        this.browserResponseTimeout = browserResponseTimeout;
        return this;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @SnowflakeJdbcInternalApi
    public SFLoginInput setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public boolean getDisableConsoleLogin() {
        return this.disableConsoleLogin;
    }

    SFLoginInput setDisableConsoleLogin(boolean disableConsoleLogin) {
        this.disableConsoleLogin = disableConsoleLogin;
        return this;
    }

    String getDatabaseName() {
        return this.databaseName;
    }

    SFLoginInput setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public SFLoginInput setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public SFLoginInput setWarehouse(String warehouse) {
        this.warehouse = warehouse;
        return this;
    }

    public String getRole() {
        return this.role;
    }

    public SFLoginInput setRole(String role) {
        this.role = role;
        return this;
    }

    public boolean isValidateDefaultParameters() {
        return this.validateDefaultParameters;
    }

    public SFLoginInput setValidateDefaultParameters(Object v) {
        this.validateDefaultParameters = SFLoginInput.getBooleanValue(v);
        return this;
    }

    public String getAuthenticator() {
        return this.authenticator;
    }

    public SFLoginInput setAuthenticator(String authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public String getOKTAUserName() {
        return this.oktaUserName;
    }

    public SFLoginInput setOKTAUserName(String oktaUserName) {
        this.oktaUserName = oktaUserName;
        return this;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public SFLoginInput setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    SFLoginInput setLoginTimeout(int loginTimeout) {
        this.loginTimeout = loginTimeout > this.retryTimeout && this.retryTimeout != 0 ? this.retryTimeout : loginTimeout;
        return this;
    }

    int getRetryTimeout() {
        return this.retryTimeout;
    }

    SFLoginInput setRetryTimeout(int retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public int getAuthTimeout() {
        return this.authTimeout;
    }

    SFLoginInput setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    SFLoginInput setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SFLoginInput setPassword(String password) {
        this.password = password;
        return this;
    }

    String getPasscode() {
        return this.passcode;
    }

    SFLoginInput setPasscode(String passcode) {
        this.passcode = passcode;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public SFLoginInput setToken(String token) {
        this.token = token;
        return this;
    }

    int getConnectionTimeoutInMillis() {
        return (int)this.connectionTimeout.toMillis();
    }

    SFLoginInput setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public int getSocketTimeoutInMillis() {
        return (int)this.socketTimeout.toMillis();
    }

    @SnowflakeJdbcInternalApi
    public SFLoginInput setSocketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    boolean isPasscodeInPassword() {
        return this.passcodeInPassword;
    }

    SFLoginInput setPasscodeInPassword(boolean passcodeInPassword) {
        this.passcodeInPassword = passcodeInPassword;
        return this;
    }

    String getAppId() {
        return this.appId;
    }

    SFLoginInput setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    String getAppVersion() {
        return this.appVersion;
    }

    SFLoginInput setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public SFLoginInput setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    String getMasterToken() {
        return this.masterToken;
    }

    SFLoginInput setMasterToken(String masterToken) {
        this.masterToken = masterToken;
        return this;
    }

    String getIdToken() {
        return this.idToken;
    }

    SFLoginInput setIdToken(String idToken) {
        this.idToken = idToken;
        return this;
    }

    String getMfaToken() {
        return this.mfaToken;
    }

    SFLoginInput setMfaToken(String mfaToken) {
        this.mfaToken = mfaToken;
        return this;
    }

    String getOauthAccessToken() {
        return this.oauthAccessToken;
    }

    SFLoginInput setOauthAccessToken(String oauthAccessToken) {
        this.oauthAccessToken = oauthAccessToken;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public String getOauthRefreshToken() {
        return this.oauthRefreshToken;
    }

    SFLoginInput setOauthRefreshToken(String oauthRefreshToken) {
        this.oauthRefreshToken = oauthRefreshToken;
        return this;
    }

    String getWorkloadIdentityProvider() {
        return this.workloadIdentityProvider;
    }

    SFLoginInput setWorkloadIdentityProvider(String workloadIdentityProvider) {
        this.workloadIdentityProvider = workloadIdentityProvider;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public String getDPoPPublicKey() {
        return this.dpopPublicKey;
    }

    SFLoginInput setDPoPPublicKey(String dpopPublicKey) {
        this.dpopPublicKey = dpopPublicKey;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public boolean isDPoPEnabled() {
        return this.dpopEnabled;
    }

    @SnowflakeJdbcInternalApi
    public void setDPoPEnabled(boolean dpopEnabled) {
        this.dpopEnabled = dpopEnabled;
    }

    Map<String, Object> getSessionParameters() {
        return this.sessionParameters;
    }

    SFLoginInput setSessionParameters(Map<String, Object> sessionParameters) {
        this.sessionParameters = sessionParameters;
        return this;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    SFLoginInput setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    String getPrivateKeyBase64() {
        return this.privateKeyBase64;
    }

    SFLoginInput setPrivateKeyBase64(String privateKeyBase64) {
        this.privateKeyBase64 = privateKeyBase64;
        return this;
    }

    SFLoginInput setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
        return this;
    }

    SFLoginInput setPrivateKeyPwd(String privateKeyPwd) {
        this.privateKeyPwd = privateKeyPwd;
        return this;
    }

    String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    String getPrivateKeyPwd() {
        return this.privateKeyPwd;
    }

    boolean isPrivateKeyProvided() {
        return this.getPrivateKey() != null || this.getPrivateKeyFile() != null || this.getPrivateKeyBase64() != null;
    }

    public String getApplication() {
        return this.application;
    }

    public SFLoginInput setApplication(String application) {
        this.application = application;
        return this;
    }

    String getServiceName() {
        return this.serviceName;
    }

    SFLoginInput setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    OCSPMode getOCSPMode() {
        return this.ocspMode;
    }

    SFLoginInput setOCSPMode(OCSPMode ocspMode) {
        this.ocspMode = ocspMode;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public HttpClientSettingsKey getHttpClientSettingsKey() {
        return this.httpClientKey;
    }

    @SnowflakeJdbcInternalApi
    public SFLoginInput setHttpClientSettingsKey(HttpClientSettingsKey key) {
        this.httpClientKey = key;
        return this;
    }

    String getInFlightCtx() {
        return this.inFlightCtx;
    }

    SFLoginInput setInFlightCtx(String inFlightCtx) {
        this.inFlightCtx = inFlightCtx;
        return this;
    }

    boolean getDisableSamlURLCheck() {
        return this.disableSamlURLCheck;
    }

    SFLoginInput setDisableSamlURLCheck(boolean disableSamlURLCheck) {
        this.disableSamlURLCheck = disableSamlURLCheck;
        return this;
    }

    public int getRedirectUriPort() {
        return this.redirectUriPort;
    }

    public SFLoginInput setRedirectUriPort(int redirectUriPort) {
        this.redirectUriPort = redirectUriPort;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public SFLoginInput setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public SFLoginInput setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    Map<String, String> getAdditionalHttpHeadersForSnowsight() {
        return this.additionalHttpHeadersForSnowsight;
    }

    public SFLoginInput setAdditionalHttpHeadersForSnowsight(Map<String, String> additionalHttpHeaders) {
        this.additionalHttpHeadersForSnowsight = additionalHttpHeaders;
        return this;
    }

    static boolean getBooleanValue(Object v) {
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return !Boolean.FALSE.toString().equalsIgnoreCase((String)v) && !"off".equalsIgnoreCase((String)v) && (Boolean.TRUE.toString().equalsIgnoreCase((String)v) || "on".equalsIgnoreCase((String)v));
        }
        return false;
    }

    String getHostFromServerUrl() throws SFException {
        URL url;
        try {
            url = !this.serverUrl.startsWith("http") ? new URL("https://" + this.serverUrl) : new URL(this.serverUrl);
        }
        catch (MalformedURLException e) {
            throw new SFException(e, ErrorCode.INTERNAL_ERROR, "Invalid serverUrl for retrieving host name");
        }
        return url.getHost();
    }

    boolean isEnableClientStoreTemporaryCredential() {
        return this.enableClientStoreTemporaryCredential;
    }

    SFLoginInput setEnableClientStoreTemporaryCredential(boolean enableClientStoreTemporaryCredential) {
        this.enableClientStoreTemporaryCredential = enableClientStoreTemporaryCredential;
        return this;
    }

    boolean isEnableClientRequestMfaToken() {
        return this.enableClientRequestMfaToken;
    }

    SFLoginInput setEnableClientRequestMfaToken(boolean enableClientRequestMfaToken) {
        this.enableClientRequestMfaToken = enableClientRequestMfaToken;
        return this;
    }

    @SnowflakeJdbcInternalApi
    public SFOauthLoginInput getOauthLoginInput() {
        return this.oauthLoginInput;
    }

    @SnowflakeJdbcInternalApi
    public SFLoginInput setOauthLoginInput(SFOauthLoginInput oauthLoginInput) {
        this.oauthLoginInput = oauthLoginInput;
        return this;
    }

    void restoreOriginalAuthenticator() {
        this.authenticator = this.originalAuthenticator;
    }

    String getOriginalAuthenticator() {
        return this.originalAuthenticator;
    }

    SFLoginInput setOriginalAuthenticator(String originalAuthenticator) {
        this.originalAuthenticator = originalAuthenticator;
        return this;
    }

    public void setWorkloadIdentityAttestation(WorkloadIdentityAttestation workloadIdentityAttestation) {
        this.workloadIdentityAttestation = workloadIdentityAttestation;
    }

    public WorkloadIdentityAttestation getWorkloadIdentityAttestation() {
        return this.workloadIdentityAttestation;
    }

    public String getWorkloadIdentityEntraResource() {
        return this.workloadIdentityEntraResource;
    }

    public SFLoginInput setWorkloadIdentityEntraResource(String workloadIdentityEntraResource) {
        this.workloadIdentityEntraResource = workloadIdentityEntraResource;
        return this;
    }
}

