/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SecureStorageLinuxManager
implements SecureStorageManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SecureStorageLinuxManager.class);
    private static final String CACHE_FILE_NAME = "credential_cache_v1.json";
    private static final String CACHE_DIR_PROP = "net.snowflake.jdbc.temporaryCredentialCacheDir";
    private static final String CACHE_DIR_ENV = "SF_TEMPORARY_CREDENTIAL_CACHE_DIR";
    private static final String CACHE_FILE_TOKENS_OBJECT_NAME = "tokens";
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    private final FileCacheManager fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty("net.snowflake.jdbc.temporaryCredentialCacheDir").setCacheDirectoryEnvironmentVariable("SF_TEMPORARY_CREDENTIAL_CACHE_DIR").setBaseCacheFileName("credential_cache_v1.json").setCacheFileLockExpirationInSeconds(60L).build();

    private SecureStorageLinuxManager() {
        logger.debug("Using temporary file: {} as a token cache storage", this.fileCacheManager.getCacheFilePath());
    }

    public static SecureStorageLinuxManager getInstance() {
        return SecureStorageLinuxManagerHolder.INSTANCE;
    }

    @Override
    public synchronized SecureStorageManager.SecureStorageStatus setCredential(String host, String user, String type, String token) {
        if (SnowflakeUtil.isNullOrEmpty(token)) {
            logger.warn("No token provided", false);
            return SecureStorageManager.SecureStorageStatus.SUCCESS;
        }
        this.fileCacheManager.withLock(() -> {
            Map<String, Map<String, String>> cachedCredentials = this.readJsonStoreCache(this.fileCacheManager.readCacheFile());
            cachedCredentials.computeIfAbsent(CACHE_FILE_TOKENS_OBJECT_NAME, tokensMap -> new HashMap());
            Map<String, String> credentialsMap = cachedCredentials.get(CACHE_FILE_TOKENS_OBJECT_NAME);
            credentialsMap.put(SecureStorageManager.buildCredentialsKey(host, user, type), token);
            this.fileCacheManager.writeCacheFile((JsonNode)this.localCacheToJson(cachedCredentials));
            return null;
        });
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    @Override
    public synchronized String getCredential(String host, String user, String type) {
        return this.fileCacheManager.withLock(() -> {
            JsonNode res = this.fileCacheManager.readCacheFile();
            Map<String, Map<String, String>> cache = this.readJsonStoreCache(res);
            Map<String, String> credentialsMap = cache.get(CACHE_FILE_TOKENS_OBJECT_NAME);
            if (credentialsMap == null) {
                return null;
            }
            return credentialsMap.get(SecureStorageManager.buildCredentialsKey(host, user, type));
        });
    }

    @Override
    public synchronized SecureStorageManager.SecureStorageStatus deleteCredential(String host, String user, String type) {
        this.fileCacheManager.withLock(() -> {
            JsonNode res = this.fileCacheManager.readCacheFile();
            Map<String, Map<String, String>> cache = this.readJsonStoreCache(res);
            Map<String, String> credentialsMap = cache.get(CACHE_FILE_TOKENS_OBJECT_NAME);
            if (credentialsMap != null) {
                credentialsMap.remove(SecureStorageManager.buildCredentialsKey(host, user, type));
                if (credentialsMap.isEmpty()) {
                    cache.remove(CACHE_FILE_TOKENS_OBJECT_NAME);
                }
            }
            this.fileCacheManager.writeCacheFile((JsonNode)this.localCacheToJson(cache));
            return null;
        });
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    private ObjectNode localCacheToJson(Map<String, Map<String, String>> cache) {
        ObjectNode jsonNode = StmtUtil.mapper.createObjectNode();
        Map<String, String> tokensMap = cache.get(CACHE_FILE_TOKENS_OBJECT_NAME);
        if (tokensMap != null) {
            ObjectNode tokensNode = StmtUtil.mapper.createObjectNode();
            for (Map.Entry<String, String> credential : tokensMap.entrySet()) {
                tokensNode.put(credential.getKey(), credential.getValue());
            }
            jsonNode.set(CACHE_FILE_TOKENS_OBJECT_NAME, (JsonNode)tokensNode);
        }
        return jsonNode;
    }

    private Map<String, Map<String, String>> readJsonStoreCache(JsonNode node) {
        HashMap<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
        if (node == null || !node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            logger.debug("Invalid cache file format.", new Object[0]);
            return cache;
        }
        cache.put(CACHE_FILE_TOKENS_OBJECT_NAME, new HashMap());
        JsonNode credentialsNode = node.get(CACHE_FILE_TOKENS_OBJECT_NAME);
        Map credentialsCache = (Map)cache.get(CACHE_FILE_TOKENS_OBJECT_NAME);
        if (credentialsNode != null && node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            Iterator itr = credentialsNode.fields();
            while (itr.hasNext()) {
                Map.Entry credential = (Map.Entry)itr.next();
                credentialsCache.put((String)credential.getKey(), ((JsonNode)credential.getValue()).asText());
            }
        }
        return cache;
    }

    private static class SecureStorageLinuxManagerHolder {
        private static final SecureStorageLinuxManager INSTANCE = new SecureStorageLinuxManager();

        private SecureStorageLinuxManagerHolder() {
        }
    }
}

