/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDateWithTimezone;
import net.snowflake.client.jdbc.SnowflakeTimeWithTimezone;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class DateTimeConverter {
    private final TimeZone sessionTimeZone;
    private final long resultVersion;
    private final boolean honorClientTZForTimestampNTZ;
    private final boolean treatNTZAsUTC;
    private final boolean useSessionTimezone;
    private final boolean formatDateWithTimeZone;
    private final SFBaseSession session;

    public DateTimeConverter(TimeZone sessionTimeZone, SFBaseSession session, long resultVersion, boolean honorClientTZForTimestampNTZ, boolean treatNTZAsUTC, boolean useSessionTimezone, boolean formatDateWithTimeZone) {
        this.sessionTimeZone = sessionTimeZone;
        this.session = session;
        this.resultVersion = resultVersion;
        this.honorClientTZForTimestampNTZ = honorClientTZForTimestampNTZ;
        this.treatNTZAsUTC = treatNTZAsUTC;
        this.useSessionTimezone = useSessionTimezone;
        this.formatDateWithTimeZone = formatDateWithTimeZone;
    }

    public Timestamp getTimestamp(Object obj, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        if (obj == null) {
            return null;
        }
        if (93 == columnType || 2014 == columnType) {
            SFTimestamp sfTS;
            Timestamp res;
            if (tz == null) {
                tz = TimeZone.getDefault();
            }
            if ((res = (sfTS = ResultUtil.getSFTimestamp(obj.toString(), scale, columnSubType, this.resultVersion, this.sessionTimeZone, this.session)).getTimestamp()) == null) {
                return null;
            }
            if (this.useSessionTimezone) {
                if (columnSubType == 50000 || columnSubType == 50001) {
                    TimeZone specificSessionTimezone = this.adjustTimezoneForTimestampTZ(obj, columnSubType);
                    res = new SnowflakeTimestampWithTimezone(res, specificSessionTimezone);
                } else {
                    res = new SnowflakeTimestampWithTimezone(res);
                }
            } else if (this.treatNTZAsUTC && columnSubType == 93) {
                res = new SnowflakeTimestampWithTimezone(res);
            }
            if (columnSubType == 93 && (!this.treatNTZAsUTC && this.honorClientTZForTimestampNTZ || this.useSessionTimezone)) {
                res = sfTS.moveToTimeZone(tz).getTimestamp();
            }
            return ResultUtil.adjustTimestamp(res);
        }
        if (91 == columnType) {
            Date d = this.getDate(obj, columnType, columnSubType, tz, scale);
            if (d == null) {
                return null;
            }
            return new Timestamp(d.getTime());
        }
        if (92 == columnType) {
            Time t = this.getTime(obj, columnType, columnSubType, tz, scale);
            if (t == null) {
                return null;
            }
            if (this.useSessionTimezone) {
                SFTime sfTime = ResultUtil.getSFTime(obj.toString(), scale, this.session);
                return new SnowflakeTimestampWithTimezone(sfTime.getFractionalSeconds(3), sfTime.getNanosecondsWithinSecond(), TimeZone.getTimeZone("UTC"));
            }
            return new Timestamp(t.getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "timestamp", obj);
    }

    public Time getTime(Object obj, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        if (obj == null) {
            return null;
        }
        if (92 == columnType) {
            SFTime sfTime = ResultUtil.getSFTime(obj.toString(), scale, this.session);
            Time ts = new Time(sfTime.getFractionalSeconds(3));
            if (this.useSessionTimezone) {
                ts = SnowflakeUtil.getTimeInSessionTimezone(SnowflakeUtil.getSecondsFromMillis(ts.getTime()), sfTime.getNanosecondsWithinSecond());
            }
            return ts;
        }
        if (93 == columnType || 2014 == columnType) {
            Timestamp ts = this.getTimestamp(obj, columnType, columnSubType, tz, scale);
            if (ts == null) {
                return null;
            }
            if (this.useSessionTimezone) {
                ts = this.getTimestamp(obj, columnType, columnSubType, this.sessionTimeZone, scale);
                TimeZone sessionTimeZone = this.adjustTimezoneForTimestampTZ(obj, columnSubType);
                return new SnowflakeTimeWithTimezone(ts, sessionTimeZone, this.useSessionTimezone);
            }
            return new Time(ts.getTime());
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "time", obj);
    }

    public Date getDate(Object obj, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        if (obj == null) {
            return null;
        }
        if (93 == columnType || 2014 == columnType) {
            if (tz == null) {
                tz = TimeZone.getDefault();
            }
            if (columnSubType == 50001 || columnSubType == 50000) {
                TimeZone specificSessionTimeZone = this.adjustTimezoneForTimestampTZ(obj, columnSubType);
                return new SnowflakeDateWithTimezone(this.getTimestamp(obj, columnType, columnSubType, tz, scale).getTime(), specificSessionTimeZone, this.useSessionTimezone);
            }
            return new Date(this.getTimestamp(obj, columnType, columnSubType, tz, scale).getTime());
        }
        if (91 == columnType) {
            if (tz == null || !this.formatDateWithTimeZone) {
                return ArrowResultUtil.getDate(Integer.parseInt((String)obj));
            }
            return ArrowResultUtil.getDate(Integer.parseInt((String)obj), tz, this.sessionTimeZone);
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "date", obj);
    }

    private TimeZone adjustTimezoneForTimestampTZ(Object obj, int columnSubType) {
        if (obj != null && columnSubType == 50001 && this.resultVersion > 0L) {
            String timestampStr = obj.toString();
            int indexForSeparator = timestampStr.indexOf(32);
            String timezoneIndexStr = timestampStr.substring(indexForSeparator + 1);
            return SFTimestamp.convertTimezoneIndexToTimeZone(Integer.parseInt(timezoneIndexStr));
        }
        return this.sessionTimeZone;
    }
}

