/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFClientConfigParser {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFClientConfigParser.class);
    public static final String SF_CLIENT_CONFIG_FILE_NAME = "sf_client_config.json";
    public static final String SF_CLIENT_CONFIG_ENV_NAME = "SF_CLIENT_CONFIG_FILE";

    public static SFClientConfig loadSFClientConfig(String configFilePath) throws IOException {
        if (configFilePath != null) {
            logger.debug("Attempting to enable easy logging with file path {}", configFilePath);
        }
        String derivedConfigFilePath = null;
        if (configFilePath != null && !configFilePath.isEmpty()) {
            logger.debug("Using config file specified from connection string: {}", configFilePath);
            derivedConfigFilePath = configFilePath;
        } else if (System.getenv().containsKey(SF_CLIENT_CONFIG_ENV_NAME)) {
            String filePath = SnowflakeUtil.systemGetEnv(SF_CLIENT_CONFIG_ENV_NAME);
            logger.debug("Using config file specified from environment variable: {}", filePath);
            derivedConfigFilePath = filePath;
        } else {
            String driverLocation = Paths.get(SFClientConfigParser.getConfigFilePathFromJDBCJarLocation(), SF_CLIENT_CONFIG_FILE_NAME).toString();
            if (Files.exists(Paths.get(driverLocation, new String[0]), new LinkOption[0])) {
                logger.debug("Using config file specified from driver directory: {}", driverLocation);
                derivedConfigFilePath = driverLocation;
            } else {
                String userHomeFilePath;
                String homeDirectory = SnowflakeUtil.systemGetProperty("user.home");
                if (homeDirectory != null && Files.exists(Paths.get(userHomeFilePath = Paths.get(homeDirectory, SF_CLIENT_CONFIG_FILE_NAME).toString(), new String[0]), new LinkOption[0])) {
                    logger.debug("Using config file specified from home directory: {}", userHomeFilePath);
                    derivedConfigFilePath = userHomeFilePath;
                }
            }
        }
        if (derivedConfigFilePath != null) {
            try {
                File configFile = new File(derivedConfigFilePath);
                ObjectMapper objectMapper = new ObjectMapper();
                SFClientConfig clientConfig = (SFClientConfig)objectMapper.readValue(configFile, SFClientConfig.class);
                logger.debug("Reading values logLevel {} and logPath {} from client configuration", clientConfig.getCommonProps().getLogLevel(), clientConfig.getCommonProps().getLogPath());
                Set<String> unknownParams = clientConfig.getUnknownParamKeys();
                if (!unknownParams.isEmpty()) {
                    for (String unknownParam : unknownParams) {
                        logger.warn("Unknown field from config: {}", unknownParam);
                    }
                }
                clientConfig.setConfigFilePath(derivedConfigFilePath);
                return clientConfig;
            }
            catch (IOException e) {
                String customErrorMessage = "Error while reading config file: " + derivedConfigFilePath;
                throw new IOException(customErrorMessage, e);
            }
        }
        return null;
    }

    public static String getConfigFilePathFromJDBCJarLocation() {
        try {
            if (SnowflakeDriver.class.getProtectionDomain() != null && SnowflakeDriver.class.getProtectionDomain().getCodeSource() != null && SnowflakeDriver.class.getProtectionDomain().getCodeSource().getLocation() != null) {
                String jarPath = SnowflakeDriver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String updatedPath = new File(jarPath).getParentFile().getPath();
                if (SnowflakeUtil.systemGetProperty("os.name") != null && SnowflakeUtil.systemGetProperty("os.name").toLowerCase().startsWith("windows")) {
                    updatedPath = SFClientConfigParser.convertToWindowsPath(updatedPath);
                }
                return updatedPath;
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    @SnowflakeJdbcInternalApi
    public static void checkConfigFilePermissions(String derivedConfigFilePath) throws IOException {
        if (Constants.getOS() != Constants.OS.WINDOWS && SFClientConfigParser.checkGroupOthersWritePermissions(derivedConfigFilePath).booleanValue()) {
            String error = String.format("Error due to other users having permission to modify the config file: %s", derivedConfigFilePath);
            logger.warn(error, new Object[0]);
        }
    }

    static Boolean checkGroupOthersWritePermissions(String configFilePath) throws IOException {
        Set<PosixFilePermission> folderPermissions = Files.getPosixFilePermissions(Paths.get(configFilePath, new String[0]), new LinkOption[0]);
        return folderPermissions.contains((Object)PosixFilePermission.GROUP_WRITE) || folderPermissions.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    static String convertToWindowsPath(String filePath) {
        Pattern windowsFilePattern = Pattern.compile("[C-Z]:[\\\\/]");
        Matcher matcher = windowsFilePattern.matcher(filePath);
        String prefix = "";
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        } else if (filePath.startsWith("file:\\")) {
            filePath = filePath.substring(6);
        } else if (filePath.startsWith("nested:\\")) {
            filePath = filePath.substring(8);
        } else if (filePath.startsWith("\\")) {
            filePath = filePath.substring(2);
        } else if (matcher.find() && matcher.start() != 0) {
            prefix = filePath.substring(0, matcher.start());
            filePath = filePath.substring(matcher.start());
        }
        filePath = prefix + filePath.replace("/", "\\");
        return filePath;
    }
}

