/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultChunk;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class JsonResultChunk
extends SnowflakeResultChunk {
    private static final SFLogger logger = SFLoggerFactory.getLogger(JsonResultChunk.class);
    private ResultChunkData data;
    private int currentRow;
    private SFBaseSession session;

    public JsonResultChunk(String url, int rowCount, int colCount, int uncompressedSize, SFBaseSession session) {
        super(url, rowCount, colCount, uncompressedSize);
        this.data = new BlockResultChunkDataV2(this.computeCharactersNeeded(), rowCount, colCount, session);
        this.session = session;
    }

    public static Object extractCell(JsonNode resultData, int rowIdx, int colIdx) {
        JsonNode currentRow = resultData.get(rowIdx);
        JsonNode colNode = currentRow.get(colIdx);
        if (colNode.isTextual()) {
            return colNode.asText();
        }
        if (colNode.isNumber()) {
            return colNode.numberValue();
        }
        if (colNode.isNull()) {
            return null;
        }
        throw new RuntimeException("Unknow json type");
    }

    public void tryReuse(ResultChunkDataCache cache) {
        cache.reuseOrCreateResultData(this.data);
    }

    public final Object getCell(int rowIdx, int colIdx) {
        return this.data.get(this.colCount * rowIdx + colIdx);
    }

    public final void addRow(Object[] row) throws SnowflakeSQLException {
        if (row.length != this.colCount) {
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Exception: expected " + this.colCount + " columns and received " + row.length);
        }
        for (Object cell : row) {
            if (cell == null) {
                this.data.add(null);
                continue;
            }
            if (cell instanceof String) {
                this.data.add((String)cell);
                continue;
            }
            if (cell instanceof Boolean) {
                this.data.add((Boolean)cell != false ? "1" : "0");
                continue;
            }
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "unknown data type in JSON row " + cell.getClass().toString());
        }
        ++this.currentRow;
    }

    public final void ensureRowsComplete() throws SnowflakeSQLException {
        if (this.rowCount != this.currentRow) {
            throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Exception: expected " + this.rowCount + " rows and received " + this.currentRow);
        }
    }

    @Override
    public void reset() {
        this.currentRow = 0;
        this.data.reset();
    }

    @Override
    public final long computeNeededChunkMemory() {
        if (this.data != null) {
            return this.data.computeNeededChunkMemory();
        }
        return 0L;
    }

    @Override
    public final void freeData() {
        if (this.data != null) {
            this.data.freeData();
        }
    }

    public int computeCharactersNeeded() {
        return this.uncompressedSize - this.rowCount * 2 - this.rowCount * this.colCount;
    }

    public void addOffset(int offset) throws SnowflakeSQLException {
        this.data.addOffset(offset);
    }

    public void setIsNull() throws SnowflakeSQLException {
        this.data.setIsNull();
    }

    public void setLastLength(int len) throws SnowflakeSQLException {
        this.data.setLastLength(len);
    }

    public void nextIndex() throws SnowflakeSQLException {
        this.data.nextIndex();
    }

    public byte get(int offset) throws SnowflakeSQLException {
        return this.data.getByte(offset);
    }

    public void addByte(byte b, int pos) throws SnowflakeSQLException {
        this.data.addByte(b, pos);
    }

    public void addBytes(byte[] src, int offset, int pos, int length) throws SnowflakeSQLException {
        this.data.addBytes(src, offset, pos, length);
    }

    static class ResultChunkDataCache {
        List<SoftReference<ResultChunkData>> cache = new LinkedList<SoftReference<ResultChunkData>>();

        ResultChunkDataCache() {
        }

        void add(JsonResultChunk chunk) {
            this.cache.add(new SoftReference<ResultChunkData>(chunk.data));
            chunk.data = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reuseOrCreateResultData(ResultChunkData data) {
            ArrayList<SoftReference<ResultChunkData>> remove = new ArrayList<SoftReference<ResultChunkData>>();
            try {
                for (SoftReference<ResultChunkData> ref : this.cache) {
                    ResultChunkData dat = ref.get();
                    if (dat == null) {
                        remove.add(ref);
                        continue;
                    }
                    if (dat instanceof BlockResultChunkDataV2) {
                        BlockResultChunkDataV2 bTargetData = (BlockResultChunkDataV2)data;
                        BlockResultChunkDataV2 bCachedDat = (BlockResultChunkDataV2)dat;
                        if (bCachedDat.data.size() == 0 && bCachedDat.offsets.size() == 0) {
                            remove.add(ref);
                            continue;
                        }
                        while (bTargetData.data.size() < bTargetData.blockCount && bCachedDat.data.size() > 0) {
                            bTargetData.data.add((byte[])bCachedDat.data.remove(bCachedDat.data.size() - 1));
                        }
                        while (bTargetData.offsets.size() < bTargetData.metaBlockCount && bCachedDat.offsets.size() > 0) {
                            bTargetData.offsets.add((int[])bCachedDat.offsets.remove(bCachedDat.offsets.size() - 1));
                            BitSet isNulls = (BitSet)bCachedDat.isNulls.remove(bCachedDat.isNulls.size() - 1);
                            isNulls.clear();
                            bTargetData.isNulls.add(isNulls);
                        }
                        if (bTargetData.data.size() != bTargetData.blockCount || bTargetData.offsets.size() != bTargetData.metaBlockCount) continue;
                        return;
                    }
                    remove.add(ref);
                }
            }
            finally {
                this.cache.removeAll(remove);
            }
        }

        void clear() {
            for (SoftReference<ResultChunkData> ref : this.cache) {
                ResultChunkData dat = ref.get();
                if (dat == null) continue;
                dat.freeData();
            }
            this.cache.clear();
        }
    }

    private static class BlockResultChunkDataV2
    implements ResultChunkData {
        int blockCount;
        private static final int blockLengthBits = 23;
        private static int blockLength = 0x800000;
        private final ArrayList<byte[]> data = new ArrayList();
        SFBaseSession session;
        int metaBlockCount;
        private static int metaBlockLengthBits = 15;
        private static int metaBlockLength = 1 << metaBlockLengthBits;
        private final ArrayList<int[]> offsets = new ArrayList();
        private final ArrayList<BitSet> isNulls = new ArrayList();
        private int lastLength;
        private int rowCount;
        private int colCount;
        private int nextIndex = 0;

        BlockResultChunkDataV2(int totalLength, int rowCount, int colCount, SFBaseSession session) {
            this.blockCount = BlockResultChunkDataV2.getBlock(totalLength - 1) + 1;
            this.rowCount = rowCount;
            this.colCount = colCount;
            this.metaBlockCount = BlockResultChunkDataV2.getMetaBlock(this.rowCount * this.colCount - 1) + 1;
            this.session = session;
        }

        @Override
        public void reset() {
            this.freeData();
            this.lastLength = 0;
            this.nextIndex = 0;
        }

        @Override
        public void addOffset(int offset) {
            if (this.data.size() < this.blockCount || this.offsets.size() < this.metaBlockCount) {
                this.allocateArrays();
            }
            this.offsets.get((int)BlockResultChunkDataV2.getMetaBlock((int)this.nextIndex))[BlockResultChunkDataV2.getMetaBlockIndex((int)this.nextIndex)] = offset;
        }

        @Override
        public void setIsNull() {
            this.isNulls.get(BlockResultChunkDataV2.getMetaBlock(this.nextIndex)).set(BlockResultChunkDataV2.getMetaBlockIndex(this.nextIndex));
        }

        @Override
        public void setLastLength(int len) {
            this.lastLength = len;
        }

        @Override
        public byte getByte(int offset) {
            return this.data.get(BlockResultChunkDataV2.getBlock(offset))[BlockResultChunkDataV2.getBlockOffset(offset)];
        }

        @Override
        public void addByte(byte b, int pos) {
            if (this.data.size() < this.blockCount || this.offsets.size() < this.metaBlockCount) {
                this.allocateArrays();
            }
            this.data.get((int)BlockResultChunkDataV2.getBlock((int)pos))[BlockResultChunkDataV2.getBlockOffset((int)pos)] = b;
        }

        @Override
        public void addBytes(byte[] src, int src_offset, int pos, int length) {
            if (this.data.size() < this.blockCount || this.offsets.size() < this.metaBlockCount) {
                this.allocateArrays();
            }
            int offset = pos;
            if (BlockResultChunkDataV2.spaceLeftOnBlock(offset) < length) {
                int copySize;
                for (int copied = 0; copied < length; copied += copySize) {
                    copySize = Math.min(length - copied, BlockResultChunkDataV2.spaceLeftOnBlock(offset + copied));
                    System.arraycopy(src, src_offset + copied, this.data.get(BlockResultChunkDataV2.getBlock(offset + copied)), BlockResultChunkDataV2.getBlockOffset(offset + copied), copySize);
                }
            } else {
                System.arraycopy(src, src_offset, this.data.get(BlockResultChunkDataV2.getBlock(offset)), BlockResultChunkDataV2.getBlockOffset(offset), length);
            }
        }

        @Override
        public void nextIndex() {
            ++this.nextIndex;
        }

        @Override
        public void add(String string) throws SnowflakeSQLException {
            throw new SnowflakeSQLLoggedException(this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unimplemented");
        }

        private int getLength(int index, int offset) {
            if (index == this.rowCount * this.colCount - 1) {
                return this.lastLength;
            }
            int nextOffset = this.offsets.get(BlockResultChunkDataV2.getMetaBlock(index + 1))[BlockResultChunkDataV2.getMetaBlockIndex(index + 1)];
            return nextOffset - offset;
        }

        @Override
        public String get(int index) {
            boolean isNull = this.isNulls.get(BlockResultChunkDataV2.getMetaBlock(index)).get(BlockResultChunkDataV2.getMetaBlockIndex(index));
            if (isNull) {
                return null;
            }
            int offset = this.offsets.get(BlockResultChunkDataV2.getMetaBlock(index))[BlockResultChunkDataV2.getMetaBlockIndex(index)];
            int length = this.getLength(index, offset);
            if (BlockResultChunkDataV2.spaceLeftOnBlock(offset) < length) {
                int copySize;
                byte[] cell = new byte[length];
                for (int copied = 0; copied < length; copied += copySize) {
                    copySize = Math.min(length - copied, BlockResultChunkDataV2.spaceLeftOnBlock(offset + copied));
                    System.arraycopy(this.data.get(BlockResultChunkDataV2.getBlock(offset + copied)), BlockResultChunkDataV2.getBlockOffset(offset + copied), cell, copied, copySize);
                }
                return new String(cell, StandardCharsets.UTF_8);
            }
            return new String(this.data.get(BlockResultChunkDataV2.getBlock(offset)), BlockResultChunkDataV2.getBlockOffset(offset), length, StandardCharsets.UTF_8);
        }

        @Override
        public long computeNeededChunkMemory() {
            long dataRequirement = (long)(this.blockCount * blockLength) * 1L;
            long metadataRequirement = (long)(this.metaBlockCount * metaBlockLength) * 4L + (long)(this.metaBlockCount * metaBlockLength) / 8L + 1L;
            return dataRequirement + metadataRequirement;
        }

        @Override
        public void freeData() {
            this.data.clear();
            this.offsets.clear();
            this.isNulls.clear();
        }

        private static int getBlock(int offset) {
            return offset >> 23;
        }

        private static int getBlockOffset(int offset) {
            return offset & blockLength - 1;
        }

        private static int spaceLeftOnBlock(int offset) {
            return blockLength - BlockResultChunkDataV2.getBlockOffset(offset);
        }

        private static int getMetaBlock(int index) {
            return index >> metaBlockLengthBits;
        }

        private static int getMetaBlockIndex(int index) {
            return index & metaBlockLength - 1;
        }

        private void allocateArrays() {
            logger.debug("allocating {} B for ResultChunk", this.computeNeededChunkMemory());
            while (this.data.size() < this.blockCount) {
                this.data.add(new byte[0x800000]);
            }
            while (this.offsets.size() < this.metaBlockCount) {
                this.offsets.add(new int[1 << metaBlockLengthBits]);
                this.isNulls.add(new BitSet(1 << metaBlockLengthBits));
            }
            logger.debug("allocated {} B for ResultChunk", this.computeNeededChunkMemory());
        }
    }

    private static interface ResultChunkData {
        public void add(String var1) throws SnowflakeSQLException;

        public String get(int var1);

        public long computeNeededChunkMemory();

        public void freeData();

        public void addOffset(int var1) throws SnowflakeSQLException;

        public void setIsNull() throws SnowflakeSQLException;

        public void nextIndex() throws SnowflakeSQLException;

        public void setLastLength(int var1) throws SnowflakeSQLException;

        public byte getByte(int var1) throws SnowflakeSQLException;

        public void addByte(byte var1, int var2) throws SnowflakeSQLException;

        public void addBytes(byte[] var1, int var2, int var3, int var4) throws SnowflakeSQLException;

        public void reset();
    }
}

