/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.http.HttpMethodName;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;

@SnowflakeJdbcInternalApi
public class AwsSdkGCPSigner
extends AWS4Signer {
    private static final Map<String, String> headerMap = new HashMap<String, String>(){
        {
            this.put("x-amz-storage-class", "x-goog-storage-class");
            this.put("x-amz-acl", "x-goog-acl");
            this.put("x-amz-date", "x-goog-date");
            this.put("x-amz-copy-source", "x-goog-copy-source");
            this.put("x-amz-metadata-directive", "x-goog-metadata-directive");
            this.put("x-amz-copy-source-if-match", "x-goog-copy-source-if-match");
            this.put("x-amz-copy-source-if-none-match", "x-goog-copy-source-if-none-match");
            this.put("x-amz-copy-source-if-unmodified-since", "x-goog-copy-source-if-unmodified-since");
            this.put("x-amz-copy-source-if-modified-since", "x-goog-copy-source-if-modified-since");
        }
    };

    public void sign(SignableRequest<?> request, AWSCredentials credentials) {
        if (credentials.getAWSAccessKeyId() != null && !"".equals(credentials.getAWSAccessKeyId())) {
            request.addHeader("Authorization", "Bearer " + credentials.getAWSAccessKeyId());
        }
        if (request.getHttpMethod() == HttpMethodName.GET) {
            request.addHeader("Accept-Encoding", "gzip,deflate");
        }
        Map<String, String> headerCopy = request.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, String> entry : headerCopy.entrySet()) {
            String entryKey = entry.getKey().toLowerCase();
            if (headerMap.containsKey(entryKey)) {
                request.addHeader(headerMap.get(entryKey), entry.getValue());
                continue;
            }
            if (!entryKey.startsWith("x-amz-meta-")) continue;
            request.addHeader(entryKey.replace("x-amz-meta-", "x-goog-meta-"), entry.getValue());
        }
    }
}

